/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityBlockItem;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class TallSeaPlant
extends Block {
    private boolean compiled = false;
    private int squareid3D = 0;
    private float blockrenderwidth = 16.0f;

    public TallSeaPlant(String n, String txt) {
        super(n, txt);
        this.breaksound = "DangerZone:leavesbreak";
        this.placesound = "DangerZone:leavesplace";
        this.hitsound = "DangerZone:leaves_hit";
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.alwaysRender = true;
        this.randomtick = true;
        this.isLeaves = true;
        this.isWaterPlant = true;
        this.maxdamage = 1;
        this.burntime = 10;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        EntityBlockItem e;
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.stone.blockID && bid != Blocks.sand.blockID && bid != this.blockID) {
            w.setblock(d, x, y, z, Blocks.water.blockID);
            if (w.rand.nextInt(4) == 1 && (e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
                e.fill(this, 1);
                w.spawnEntityInWorld(e);
            }
        }
        if ((bid = w.getblock(d, x, y + 1, z)) != Blocks.waterstatic.blockID && bid != Blocks.water.blockID && bid != this.blockID) {
            w.setblock(d, x, y, z, Blocks.water.blockID);
            if (w.rand.nextInt(4) == 1 && (e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
                e.fill(this, 1);
                w.spawnEntityInWorld(e);
            }
        }
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        int j;
        int bid = 0;
        bid = w.getblock(d, x, y + 1, z);
        if (bid != Blocks.waterstatic.blockID && bid != this.blockID) {
            w.setblock(d, x, y, z, Blocks.water.blockID);
            return;
        }
        bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.stone.blockID && bid != Blocks.sand.blockID && bid != this.blockID) {
            w.setblock(d, x, y, z, Blocks.water.blockID);
            return;
        }
        if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
            return;
        }
        if (w.rand.nextInt(2000) == 1) {
            int i = -1;
            while (i <= 1) {
                j = -1;
                while (j <= 1) {
                    int k = -1;
                    while (k <= 1) {
                        bid = w.getblock(d, x + i, y + j, z + k);
                        if ((bid == Blocks.stone.blockID || bid == Blocks.sand.blockID) && w.getblock(d, x + i, y + j + 1, z + k) == Blocks.waterstatic.blockID && w.rand.nextInt(4) == 1) {
                            w.setblock(d, x + i, y + j + 1, z + k, this.blockID);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (w.rand.nextInt(200) == 1) {
            j = y;
            while (j < 255) {
                if ((bid = w.getblock(d, x, ++j, z)) == this.blockID) continue;
                if (bid != Blocks.waterstatic.blockID || w.getblock(d, x, j + 1, z) != Blocks.waterstatic.blockID) break;
                w.setblock(d, x, j, z, this.blockID);
                break;
            }
        }
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        float brw = this.blockrenderwidth / 2.0f;
        st = builder.findVBOtextureforblockside(0, bid);
        v = builder.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v != null) {
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            int stride;
            int textureoff = stride = 12;
            int coloroff = stride += 8;
            stride += 12;
            this.squareid3D = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)this.squareid3D);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            ByteBuffer vbodata = BufferUtils.createByteBuffer(8 * stride);
            TallSeaPlant.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            TallSeaPlant.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            TallSeaPlant.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            TallSeaPlant.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            TallSeaPlant.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            TallSeaPlant.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            TallSeaPlant.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            TallSeaPlant.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            int vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            this.compiled = true;
        }
        wr.loadtextureforblockside(0, bid, false);
        MatrixStack.sendFinalStack();
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL30.glBindVertexArray((int)this.squareid3D);
        GL11.glDrawArrays((int)7, (int)0, (int)8);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
    }

    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        vbodata.putFloat(vx);
        vbodata.putFloat(vy);
        vbodata.putFloat(vz);
        vbodata.putFloat(tx);
        vbodata.putFloat(ty);
        vbodata.putFloat(br);
        vbodata.putFloat(bg);
        vbodata.putFloat(bb);
    }
}

