/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.BetterTorch;
import dangerzone.blocks.Block;
import dangerzone.blocks.BlockAppleLeaves;
import dangerzone.blocks.BlockBarrier;
import dangerzone.blocks.BlockBlockDark;
import dangerzone.blocks.BlockBlockLight;
import dangerzone.blocks.BlockCherryLeaves;
import dangerzone.blocks.BlockChest;
import dangerzone.blocks.BlockClaim;
import dangerzone.blocks.BlockClaimMarker;
import dangerzone.blocks.BlockCloud;
import dangerzone.blocks.BlockColoredGlass;
import dangerzone.blocks.BlockCorn;
import dangerzone.blocks.BlockDark;
import dangerzone.blocks.BlockDesk;
import dangerzone.blocks.BlockDirt;
import dangerzone.blocks.BlockDownRail;
import dangerzone.blocks.BlockFlower;
import dangerzone.blocks.BlockFurnace;
import dangerzone.blocks.BlockFurnaceOn;
import dangerzone.blocks.BlockGlass;
import dangerzone.blocks.BlockInstability;
import dangerzone.blocks.BlockLava;
import dangerzone.blocks.BlockLavaFiller;
import dangerzone.blocks.BlockLavaStatic;
import dangerzone.blocks.BlockLeaves;
import dangerzone.blocks.BlockLight;
import dangerzone.blocks.BlockLog;
import dangerzone.blocks.BlockMetal;
import dangerzone.blocks.BlockMilk;
import dangerzone.blocks.BlockMilkStatic;
import dangerzone.blocks.BlockMilkweed;
import dangerzone.blocks.BlockOre;
import dangerzone.blocks.BlockOreBloodstone;
import dangerzone.blocks.BlockOreDiamond;
import dangerzone.blocks.BlockOreEmerald;
import dangerzone.blocks.BlockOreSunstone;
import dangerzone.blocks.BlockPeachLeaves;
import dangerzone.blocks.BlockRail;
import dangerzone.blocks.BlockSand;
import dangerzone.blocks.BlockSapling;
import dangerzone.blocks.BlockShredder;
import dangerzone.blocks.BlockSpawner;
import dangerzone.blocks.BlockStand;
import dangerzone.blocks.BlockStone;
import dangerzone.blocks.BlockUpRail;
import dangerzone.blocks.BlockWater;
import dangerzone.blocks.BlockWaterLight;
import dangerzone.blocks.BlockWaterPump;
import dangerzone.blocks.BlockWaterSpout;
import dangerzone.blocks.BlockWaterStatic;
import dangerzone.blocks.BlockWood;
import dangerzone.blocks.BlockWorkBench;
import dangerzone.blocks.ButterflyPlant;
import dangerzone.blocks.ColoringBlock;
import dangerzone.blocks.DarkStick;
import dangerzone.blocks.Door;
import dangerzone.blocks.FireStone;
import dangerzone.blocks.FishNursery;
import dangerzone.blocks.Grass;
import dangerzone.blocks.GrassBlock;
import dangerzone.blocks.Ladder;
import dangerzone.blocks.MusicBlock;
import dangerzone.blocks.Post;
import dangerzone.blocks.PuddleMaker;
import dangerzone.blocks.RadishPlant;
import dangerzone.blocks.RicePlant;
import dangerzone.blocks.RoachBlock;
import dangerzone.blocks.SeaPlant;
import dangerzone.blocks.StickyBlock;
import dangerzone.blocks.StopBlock;
import dangerzone.blocks.TallSeaPlant;
import dangerzone.blocks.WaterAnd;
import dangerzone.blocks.WaterCannon;
import dangerzone.blocks.WaterNot;
import dangerzone.blocks.WaterStone;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.gui.InventoryMenus;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.World;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import slick.Texture;

public class Blocks {
    public static Block sapling_tallwood = new BlockSapling("DangerZone:Tall Wood Tree Sapling", "res/blocks/sapling.png");
    public static Block sapling_cherry = new BlockSapling("DangerZone:Cherry Tree Sapling", "res/blocks/sapling_cherry.png");
    public static Block sapling_peach = new BlockSapling("DangerZone:Peach Tree Sapling", "res/blocks/sapling_peach.png");
    public static Block sapling_apple = new BlockSapling("DangerZone:Apple Tree Sapling", "res/blocks/sapling_apple.png");
    public static Block sapling_scragglyredwood = new BlockSapling("DangerZone:Scraggly Redwood Tree Sapling", "res/blocks/sapling_scragglyredwood.png");
    public static Block sapling_scraggly = new BlockSapling("DangerZone:Scraggly Tree Sapling", "res/blocks/sapling_scraggly.png");
    public static Block sapling_bigroundredwood = new BlockSapling("DangerZone:Big Round Redwood Tree Sapling", "res/blocks/sapling_bigroundredwood.png");
    public static Block sapling_bigroundwillow = new BlockSapling("DangerZone:Big Round Willow Tree Sapling", "res/blocks/sapling_bigroundwillow.png");
    public static Block sapling_flower = new BlockSapling("DangerZone:Flower Tree Sapling", "res/blocks/sapling_flower.png");
    public static Block sapling_flowertwo = new BlockSapling("DangerZone:Another Flower Tree Sapling", "res/blocks/sapling_flowertwo.png");
    public static Block sapling_scrub = new BlockSapling("DangerZone:Scrub Tree Sapling", "res/blocks/sapling_scrub.png");
    public static Block sapling_flowernormal = new BlockSapling("DangerZone:Forest Tree Sapling", "res/blocks/sapling_flowernormal.png");
    public static Block sapling_umbrella = new BlockSapling("DangerZone:Umbrella Tree Sapling", "res/blocks/sapling_umbrella.png");
    public static Block sapling_bulb = new BlockSapling("DangerZone:Bulb Tree Sapling", "res/blocks/sapling_bulb.png");
    public static Block sapling_looplowspiral = new BlockSapling("DangerZone:Loopy Spiral Tree Sapling", "res/blocks/sapling_looplowspiral.png");
    public static Block sapling_loop = new BlockSapling("DangerZone:Loop Tree Sapling", "res/blocks/sapling_loop.png");
    public static Block sapling_generic = new BlockSapling("DangerZone:Generic Tree Sapling", "res/blocks/sapling_generic.png");
    public static Block sapling_tallwillow = new BlockSapling("DangerZone:Tall Willow Tree Sapling", "res/blocks/sapling_tallwillow.png");
    public static Block sapling_vase = new BlockSapling("DangerZone:Vase Tree Sapling", "res/blocks/sapling_vase.png");
    public static Block sapling_spiral = new BlockSapling("DangerZone:Spiral Tree Sapling", "res/blocks/sapling_spiral.png");
    public static Block sapling_loopspiral = new BlockSapling("DangerZone:Another Loopy Spiral Tree Sapling", "res/blocks/sapling_loopspiral.png");
    public static Block sapling_bowl = new BlockSapling("DangerZone:Bowl Tree Sapling", "res/blocks/sapling_bowl.png");
    public static Block sapling_doublebowl = new BlockSapling("DangerZone:Double Bowl Tree Sapling", "res/blocks/sapling_doublebowl.png");
    public static Block stone = new BlockStone("DangerZone:Stone", "res/blocks/stone.png", 100);
    public static Block stone2 = new BlockStone("DangerZone:Decorative Stone", "res/blocks/stone2.png", 95);
    public static Block stone3 = new BlockStone("DangerZoneI:Decorative Stone", "res/blocks/stone3.png", 90);
    public static Block stone4 = new BlockStone("DangerZoneII:Decorative Stone", "res/blocks/stone4.png", 85);
    public static Block greystone = new BlockStone("DangerZone:Grey Stone", "res/blocks/greystone.png", 120);
    public static Block greystone2 = new BlockStone("DangerZone:Decorative Grey Stone", "res/blocks/greystone2.png", 115);
    public static Block greystone3 = new BlockStone("DangerZoneI:Decorative Grey Stone", "res/blocks/greystone3.png", 110);
    public static Block greystone4 = new BlockStone("DangerZoneII:Decorative Grey Stone", "res/blocks/greystone4.png", 105);
    public static Block whitestone = new BlockStone("DangerZone:White Stone", "res/blocks/whitestone.png", 140);
    public static Block dirt = new BlockDirt("DangerZone:Dirt", "res/blocks/dirt.png");
    public static Block stopblock = new StopBlock("DangerZone:Stop Block", "res/blocks/stopblock.png");
    public static Block hitbox = new Block("DangerZone:Hitbox", "res/blocks/hitbox.png");
    public static Block hardrock = new StopBlock("DangerZone:Hard Rock", "res/blocks/hardrock.png");
    public static Block firestone = new FireStone("DangerZone:Fire Stone", "res/blocks/firestone.png", 85);
    public static Block redwoodlog = new BlockLog("DangerZone:Redwood Log", "res/blocks/redwood.png", "res/blocks/redwood_top.png");
    public static Block willowlog = new BlockLog("DangerZone:Willow Log", "res/blocks/willowwood.png", "res/blocks/willowwood_top.png");
    public static Block log = new BlockLog("DangerZone:Log", "res/blocks/wood.png", "res/blocks/wood_top.png");
    public static Block lightplywood = new BlockWood("DangerZone:Light Plywood", "res/blocks/lightplywood.png");
    public static Block plywood = new BlockWood("DangerZone:Plywood", "res/blocks/plywood.png");
    public static Block darkplywood = new BlockWood("DangerZone:Dark Plywood", "res/blocks/darkplywood.png");
    public static Block leaves = new BlockLeaves("DangerZone:Leaves", "res/blocks/leaves.png");
    public static Block redwoodleaves = new BlockLeaves("DangerZone:Redwood Leaves", "res/blocks/redwoodleaves.png");
    public static Block redleaves = new BlockLeaves("DangerZone:Red Leaves", "res/blocks/redleaves.png");
    public static Block orangeleaves = new BlockLeaves("DangerZone:Orange Leaves", "res/blocks/orangeleaves.png");
    public static Block yellowleaves = new BlockLeaves("DangerZone:Yellow Leaves", "res/blocks/yellowleaves.png");
    public static Block greenleaves = new BlockLeaves("DangerZone:Green Leaves", "res/blocks/greenleaves.png");
    public static Block willowleaves = new BlockLeaves("DangerZone:Willow Leaves", "res/blocks/willowleaves.png");
    public static Block pineleaves = new BlockLeaves("DangerZone:Pine Leaves", "res/blocks/pineleaves.png");
    public static Block grassblock = new GrassBlock("DangerZone:Grass Block", "res/blocks/grasstop.png", "res/blocks/grassbottom.png", "res/blocks/grassside.png");
    public static Block grass = new Grass("DangerZone:Grass", "res/blocks/grass.png");
    public static Block orecopper = new BlockOre("DangerZone:Copper Ore", "res/blocks/orecopper.png", 50, 1);
    public static Block oretin = new BlockOre("DangerZone:Tin Ore", "res/blocks/oretin.png", 100, 5);
    public static Block oresilver = new BlockOre("DangerZone:Silver Ore", "res/blocks/oresilver.png", 150, 6);
    public static Block oreplatinum = new BlockOre("DangerZone:Platinum Ore", "res/blocks/oreplatinum.png", 200, 8);
    public static Block orediamond = new BlockOreDiamond("DangerZone:Diamond Ore", "res/blocks/orediamond.png", 225, 12);
    public static Block oreemerald = new BlockOreEmerald("DangerZone:Emerald Ore", "res/blocks/oreemerald.png", 150, 12);
    public static Block orebloodstone = new BlockOreBloodstone("DangerZone:Bloodstone Ore", "res/blocks/orebloodstone.png", 125, 12);
    public static Block oresunstone = new BlockOreSunstone("DangerZone:Sunstone Ore", "res/blocks/oresunstone.png", 125, 12);
    public static Block workbench = new BlockWorkBench("DangerZone:Workbench");
    public static Block furnace = new BlockFurnace("DangerZone:Furnace");
    public static Block furnaceOn = new BlockFurnaceOn("DangerZone:FurnaceOn");
    public static Block chest = new BlockChest("DangerZone:Chest");
    public static Block claim_block = new BlockClaim("DangerZone:Chunk Claimer", "res/blocks/claim_block.png");
    public static Block claim_marker = new BlockClaimMarker("DangerZone:Chunk Marker", "res/blocks/claim_marker.png");
    public static Block lightstick = new BetterTorch("DangerZone:Lightstick", "res/blocks/torch.png", "res/blocks/BetterTorchTexture.png");
    public static Block darkstick = new DarkStick("DangerZone:Darkstick", "res/blocks/darkstick.png", "res/blocks/BetterDarkStickTexture.png");
    public static Block oredark = new BlockDark("DangerZone:Dark Ore", "res/blocks/oredark.png", 200);
    public static Block orelight = new BlockLight("DangerZone:Light Ore", "res/blocks/orelight.png", 50);
    public static Block water = new BlockWater("DangerZone:Water", "res/blocks/water.png");
    public static Block waterstatic = new BlockWaterStatic("DangerZone:Water Source", "res/blocks/water.png");
    public static Block corn_plant = new BlockCorn("DangerZone:Baby Corn Plant", "res/blocks/corn_0.png");
    public static Block corn_plant1 = new BlockCorn("DangerZone:Corn Plant", "res/blocks/corn_1.png");
    public static Block corn_plant2 = new BlockCorn("DangerZone:Flowering Corn Plant", "res/blocks/corn_2.png");
    public static Block corn_plant3 = new BlockCorn("DangerZone:Ripe Corn Plant", "res/blocks/corn_3.png");
    public static Block milkweed_plant = new BlockMilkweed("DangerZone:Baby Milkweed Plant", "res/blocks/milkweed_0.png");
    public static Block milkweed_plant1 = new BlockMilkweed("DangerZone:Milkweed Plant", "res/blocks/milkweed_1.png");
    public static Block milkweed_plant2 = new BlockMilkweed("DangerZone:Flowering Milkweed Plant", "res/blocks/milkweed_2.png");
    public static Block milkweed_plant3 = new BlockMilkweed("DangerZone:Milkweed Seed Pods", "res/blocks/milkweed_3.png");
    public static Block roachnest = new RoachBlock("DangerZone:Cockroach Nest", "res/blocks/roachnest.png", "res/blocks/grassbottom.png", "res/blocks/grassside.png");
    public static Block glass = new BlockGlass("DangerZone:Glass", "res/blocks/glass.png", 10);
    public static Block flower_red = new BlockFlower("DangerZone:Red Flower", "res/blocks/flower_red.png");
    public static Block flower_blue = new BlockFlower("DangerZone:Blue Flower", "res/blocks/flower_pink.png");
    public static Block flower_purple = new BlockFlower("DangerZone:Purple Flower", "res/blocks/flower_purple.png");
    public static Block flower_yellow = new BlockFlower("DangerZone:Yellow Flower", "res/blocks/flower_yellow.png");
    public static Block butterfly_plant = new ButterflyPlant("DangerZone:Butterfly Plant", "res/blocks/butterfly_0.png");
    public static Block butterfly_plant1 = new ButterflyPlant("DangerZone:Butterfly Plant 1", "res/blocks/butterfly_1.png");
    public static Block butterfly_plant2 = new ButterflyPlant("DangerZone:Butterfly Plant 2", "res/blocks/butterfly_2.png");
    public static Block butterfly_plant3 = new ButterflyPlant("DangerZone:Butterfly Plant 3", "res/blocks/butterfly_3.png");
    public static Block fishnursery = new FishNursery("DangerZone:Fish Nursery", "res/blocks/fishnursery.png");
    public static Block sand = new BlockSand("DangerZone:Sand", "res/blocks/sand.png");
    public static Block radish_plant = new RadishPlant("DangerZone:Radish Plant", "res/blocks/radish_0.png");
    public static Block radish_plant1 = new RadishPlant("DangerZone:Radish Plant 1", "res/blocks/radish_1.png");
    public static Block radish_plant2 = new RadishPlant("DangerZone:Radish Plant 2", "res/blocks/radish_2.png");
    public static Block radish_plant3 = new RadishPlant("DangerZone:Ripe Radish Plant", "res/blocks/radish_3.png");
    public static Block rice_plant = new RicePlant("DangerZone:Rice Plant", "res/blocks/rice_0.png");
    public static Block rice_plant1 = new RicePlant("DangerZone:Rice Plant 1", "res/blocks/rice_1.png");
    public static Block rice_plant2 = new RicePlant("DangerZone:Rice Plant 2", "res/blocks/rice_2.png");
    public static Block rice_plant3 = new RicePlant("DangerZone:Ripe Rice Plant", "res/blocks/rice_3.png");
    public static Block blockcopper = new BlockMetal("DangerZone:Copper Block", "res/blocks/blockcopper.png", 100);
    public static Block blocktin = new BlockMetal("DangerZone:Tin Block", "res/blocks/blocktin.png", 125);
    public static Block blocksilver = new BlockMetal("DangerZone:Silver Block", "res/blocks/blocksilver.png", 150);
    public static Block blockplatinum = new BlockMetal("DangerZone:Platinum Block", "res/blocks/blockplatinum.png", 250);
    public static Block blockdiamond = new BlockMetal("DangerZone:Diamond Block", "res/blocks/blockdiamond.png", 250);
    public static Block blockemerald = new BlockMetal("DangerZone:Emerald Block", "res/blocks/blockemerald.png", 200);
    public static Block blockbloodstone = new BlockMetal("DangerZone:Bloodstone Block", "res/blocks/blockbloodstone.png", 175);
    public static Block blocksunstone = new BlockMetal("DangerZone:Sunstone Block", "res/blocks/blocksunstone.png", 175);
    public static Block blockdark = new BlockBlockDark("DangerZone:Dark Block", "res/blocks/blockdark.png", 400);
    public static Block blocklight = new BlockBlockLight("DangerZone:Light Block", "res/blocks/blocklight.png", 350);
    public static Block peachleaves = new BlockPeachLeaves("DangerZone: Peach Leaves", "res/blocks/peachleaves.png");
    public static Block cherryleaves = new BlockCherryLeaves("DangerZone:Cherry Leaves", "res/blocks/cherryleaves.png");
    public static Block appleleaves = new BlockAppleLeaves("DangerZone:Apple Leaves", "res/blocks/appleleaves.png");
    public static Block blueglass = new BlockColoredGlass("DangerZone:Blue Glass", "res/blocks/glassblue.png", 10);
    public static Block greenglass = new BlockColoredGlass("DangerZone:Green Glass", "res/blocks/glassgreen.png", 10);
    public static Block redglass = new BlockColoredGlass("DangerZone:Red Glass", "res/blocks/glassred.png", 10);
    public static Block violetglass = new BlockColoredGlass("DangerZone:Violet Glass", "res/blocks/glassviolet.png", 10);
    public static Block yellowglass = new BlockColoredGlass("DangerZone:Yellow Glass", "res/blocks/glassyellow.png", 10);
    public static Block stickyblock = new StickyBlock("DangerZone:Sticky Block", "res/blocks/stickyblock.png");
    public static Block coloringblock = new ColoringBlock("DangerZone:Coloring Block", "res/blocks/coloringblock.png");
    public static Block doortop = new Door("DangerZone:Door Top", "res/blocks/door_top.png");
    public static Block doorbottom = new Door("DangerZone:Door Bottom", "res/blocks/door_bottom.png");
    public static Block blockinstability = new BlockInstability("DangerZone:Instability Block", "res/blocks/instability.png", 1);
    public static Block blockinstability_large = new BlockInstability("DangerZone:Large Instability Block", "res/blocks/instability_large.png", 10);
    public static Block blockinstability_huge = new BlockInstability("DangerZone:Huge Instability Block", "res/blocks/instability_huge.png", 100);
    public static Block waterpump = new BlockWaterPump("DangerZone:Water Pump");
    public static Block waterspout = new BlockWaterSpout("DangerZone:Water Spout", "res/blocks/waterspouttop.png", "res/blocks/waterspoutside.png", "res/blocks/waterpump.png");
    public static Block waterlight = new BlockWaterLight("DangerZone:Water Light", "res/blocks/waterlight.png", "res/blocks/waterlightside.png", "res/blocks/waterpump.png", 0.65f);
    public static Block waterdark = new BlockWaterLight("DangerZone:Water Dark", "res/blocks/waterdark.png", "res/blocks/waterdarkside.png", "res/blocks/waterpump.png", -0.65f);
    public static Block musicbox = new MusicBlock("DangerZone:Music Box", "res/blocks/musicbox.png", "res/blocks/waterspoutside.png", "res/blocks/waterpump.png");
    public static Block puddlemaker = new PuddleMaker("DangerZone:Puddle Maker", "res/blocks/puddlemaker.png", "res/blocks/waterspoutside.png", "res/blocks/waterpump.png");
    public static Block watercannon = new WaterCannon("DangerZone:Water Cannon", "res/blocks/watercannon.png", "res/blocks/waterspoutside.png", "res/blocks/waterpump.png");
    public static Block waterstone = new WaterStone("DangerZone:Squishy Stone", "res/blocks/stone.png");
    public static Block unwaterpump = new WaterNot("DangerZone:Un-Water Pump");
    public static Block waterswitch = new WaterAnd("DangerZone:Water Switch");
    public static Block milk = new BlockMilk("DangerZone:Milk", "res/blocks/milk.png");
    public static Block milkstatic = new BlockMilkStatic("DangerZone:Milk Source", "res/blocks/milk.png");
    public static Block lava = new BlockLava("DangerZone:Lava", "res/blocks/lava.png");
    public static Block lavastatic = new BlockLavaStatic("DangerZone:Lava Source", "res/blocks/lava.png");
    public static Block lavafiller = new BlockLavaFiller("DangerZone:Lava Filler", "res/blocks/lava.png");
    public static Block autofence = new BlockBarrier("DangerZone:Auto-Fence", "res/blocks/barrier.png", "res/blocks/BetterFenceTexture.png");
    public static Block post = new Post("DangerZone:Fence Post", "res/blocks/post.png", "res/blocks/BetterFenceTexture.png");
    public static Block ladder = new Ladder("DangerZone:Ladder", "res/blocks/ladder.png", "res/blocks/LadderTexture.png");
    public static Block shredder = new BlockShredder("DangerZone:Shredder");
    public static Block desk = new BlockDesk("DangerZone:Desk");
    public static BlockStand stand = new BlockStand("DangerZone:Stand", "res/blocks/stand.png", "res/blocks/Standtexture.png");
    public static Block rail = new BlockRail("DangerZone:MagLev Rail", "res/blocks/rail.png", "res/blocks/Railtexture.png");
    public static Block railspeed = new BlockRail("DangerZone:Acceleration Rail", "res/blocks/speedrail.png", "res/blocks/SpeedRailtexture.png");
    public static Block railslow = new BlockRail("DangerZone:Deceleration Rail", "res/blocks/slowrail.png", "res/blocks/SlowRailtexture.png");
    public static Block railstop = new BlockRail("DangerZone:Stop Rail", "res/blocks/stoprail.png", "res/blocks/StopRailtexture.png");
    public static Block railup = new BlockUpRail("DangerZone:Levitate Up Rail", "res/blocks/uprail.png", "res/blocks/UpRailtexture.png");
    public static Block raildown = new BlockDownRail("DangerZone:Levitate Down Rail", "res/blocks/downrail.png", "res/blocks/DownRailtexture.png");
    public static Block railfixedslow = new BlockRail("DangerZone:Slow Speed Rail", "res/blocks/fixedslowrail.png", "res/blocks/FixedSlowRailtexture.png");
    public static Block railfixedmedium = new BlockRail("DangerZone:Medium Speed Rail", "res/blocks/fixedmediumrail.png", "res/blocks/FixedMediumRailtexture.png");
    public static Block railload = new BlockRail("DangerZone:Load Rail", "res/blocks/loadrail.png", "res/blocks/LoadRailtexture.png");
    public static Block railunload = new BlockRail("DangerZone:Unload Rail", "res/blocks/unloadrail.png", "res/blocks/UnLoadRailtexture.png");
    public static Block raildplus = new BlockUpRail("DangerZone:Dimension+ Rail", "res/blocks/raildplus.png", "res/blocks/raildplustexture.png");
    public static Block raildminus = new BlockUpRail("DangerZone:Dimension- Rail", "res/blocks/raildminus.png", "res/blocks/raildminustexture.png");
    public static Block cloud_light = new BlockCloud("DangerZone:Cloud", "res/blocks/cloud_light.png");
    public static Block cloud_rain = new BlockCloud("DangerZone:Rain Cloud", "res/blocks/cloud_rain.png");
    public static Block cloud_thunder = new BlockCloud("DangerZone:Thunder Cloud", "res/blocks/cloud_thunder.png");
    public static Block butterflyspawner = new BlockSpawner("DangerZone:Butterfly Spawner", "DangerZone:Butterfly", 0.8f, 200, 3, 0.55f, 1.75f);
    public static Block monarchspawner = new BlockSpawner("DangerZone:Monarch Butterfly Spawner", "DangerZone:Monarch", 0.75f, 200, 5, 0.55f, 1.75f);
    public static Block ghostspawner = new BlockSpawner("DangerZone:Ghost Spawner", "DangerZone:Ghost", 0.65f, 300, 2, -0.35f, 0.55f);
    public static Block ghostskellyspawner = new BlockSpawner("DangerZone:Ghost Skelly Spawner", "DangerZone:GhostSkelly", 0.5f, 400, 2, -0.35f, 0.55f);
    public static Block ratspawner = new BlockSpawner("DangerZone:Rat Spawner", "DangerZone:Rat", 0.65f, 300, 3, -0.25f, 1.0f);
    public static Block cockroachspawner = new BlockSpawner("DangerZone:Cockroach Spawner", "DangerZone:Cockroach", 1.25f, 300, 3, -0.35f, 1.55f);
    public static Block moosespawner = new BlockSpawner("DangerZone:Moose Spawner", "DangerZone:Moose", 0.25f, 600, 1, 0.55f, 1.55f);
    public static Block sparklemuffinspawner = new BlockSpawner("DangerZone:Sparklemuffin Spawner", "DangerZone:Sparklemuffin", 0.4f, 1200, 1, -0.35f, 0.55f);
    public static Block skeletorusspawner = new BlockSpawner("DangerZone:Skeletorus Spawner", "DangerZone:Skeletorus", 0.4f, 1200, 1, -0.35f, 0.55f);
    public static Block goosespawner = new BlockSpawner("DangerZone:Goose Spawner", "DangerZone:Goose", 0.4f, 600, 2, 0.55f, 1.55f);
    public static Block goslingspawner = new BlockSpawner("DangerZone:Gosling Spawner", "DangerZone:Gosling", 0.9f, 600, 2, 0.55f, 1.55f);
    public static Block ostrichspawner = new BlockSpawner("DangerZone:Ostrich Spawner", "DangerZone:Ostrich", 0.35f, 700, 1, 0.55f, 1.55f);
    public static Block anteaterspawner = new BlockSpawner("DangerZone:Anteater Spawner", "DangerZone:Anteater", 0.25f, 600, 1, 0.55f, 1.55f);
    public static Block werewolfspawner = new BlockSpawner("DangerZone:Werewolf Spawner", "DangerZone:Werewolf", 0.48f, 800, 2, -0.35f, 0.55f);
    public static Block vampirespawner = new BlockSpawner("DangerZone:Vampire Spawner", "DangerZone:Vampire", 0.48f, 800, 2, -0.35f, 0.55f);
    public static Block vaxxedspawner = new BlockSpawner("DangerZone:Vaxxed Spawner", "DangerZone:Vaxxed", 0.48f, 800, 5, -0.35f, 1.55f);
    public static Block libtardspawner = new BlockSpawner("DangerZone:Libtard Spawner", "DangerZone:Libtard", 0.48f, 600, 2, -0.35f, 1.55f);
    public static Block teacherspawner = new BlockSpawner("DangerZone:Teacher Spawner", "DangerZone:Teacher", 0.48f, 400, 2, -0.35f, 1.55f);
    public static Block professorspawner = new BlockSpawner("DangerZone:Professor Spawner", "DangerZone:Professor", 0.48f, 300, 2, -0.35f, 1.55f);
    public static Block deanspawner = new BlockSpawner("DangerZone:Dean Spawner", "DangerZone:Dean", 0.48f, 200, 1, -0.35f, 1.55f);
    public static Block doctorspawner = new BlockSpawner("DangerZone:Doctor Spawner", "DangerZone:Doctor", 0.48f, 200, 1, -0.35f, 1.55f);
    public static Block bigpharmaspawner = new BlockSpawner("DangerZone:Big Pharma Spawner", "DangerZone:Big Pharma", 0.24f, 100, 1, -0.35f, 1.55f);
    public static Block vixenspawner = new BlockSpawner("DangerZone:Vixen Spawner", "DangerZone:Vixen", 0.48f, 800, 2, -0.35f, 0.55f);
    public static Block thecountspawner = new BlockSpawner("DangerZone:The Count Spawner", "DangerZone:The Count", 0.48f, 1200, 1, -0.35f, 0.55f);
    public static Block vampiremoosespawner = new BlockSpawner("DangerZone:Vampire Moose Spawner", "DangerZone:Vampire Moose", 0.25f, 1500, 1, -0.35f, 0.55f);
    public static Block fishspawner = new BlockSpawner("DangerZone:Fish Spawner", "DangerZone:Fish", 0.45f, 300, 3, 0.55f, 1.55f);
    public static Block anotherfishspawner = new BlockSpawner("DangerZone:Another Fish Spawner", "DangerZone:Another Fish", 0.45f, 300, 3, 0.55f, 1.55f);
    public static Block pufferfishspawner = new BlockSpawner("DangerZone:Puffer Fish Spawner", "DangerZone:Puffer Fish", 0.45f, 300, 3, 0.55f, 1.55f);
    public static Block butterflyfishspawner = new BlockSpawner("DangerZone:Butterfly Fish Spawner", "DangerZone:Butterfly Fish", 0.45f, 300, 3, 0.55f, 1.55f);
    public static Block stickfishspawner = new BlockSpawner("DangerZone:Stick Fish Spawner", "DangerZone:Stick Fish", 0.45f, 300, 3, 0.55f, 1.55f);
    public static Block minnowspawner = new BlockSpawner("DangerZone:Minnow Spawner", "DangerZone:Minnow", 0.45f, 200, 7, 0.55f, 1.55f);
    public static Block piranahspawner = new BlockSpawner("DangerZone:Piranah Spawner", "DangerZone:Piranah", 0.4f, 200, 7, 0.55f, 1.55f);
    public static Block snarlerspawner = new BlockSpawner("DangerZone:Snarler Spawner", "DangerZone:Snarler", 0.8f, 200, 3, -0.35f, 0.75f);
    public static Block bulletbatspawner = new BlockSpawner("DangerZone:Bullet Bat Spawner", "DangerZone:Bullet Bat", 0.75f, 200, 5, -0.35f, 1.75f);
    public static Block martianspawner = new BlockSpawner("DangerZone:Martian Spawner", "DangerZone:Martian", 0.45f, 250, 8, -0.35f, 1.75f);
    public static Block desertrainfrogspawner = new BlockSpawner("DangerZone:Desert Rain Frog Spawner", "DangerZone:Desert Rain Frog", 0.45f, 300, 3, 0.55f, 1.55f);
    public static Block eelspawner = new BlockSpawner("DangerZone:Eel Spawner", "DangerZone:Eel", 0.4f, 300, 3, -0.35f, 1.55f);
    public static Block mermaidspawner = new BlockSpawner("DangerZone:Mermaid Spawner", "DangerZone:Mermaid", 0.48f, 800, 2, 0.25f, 1.55f);
    public static Block block_lightgrey = new BlockOre("DangerZone:Light Grey Block", "res/blocks/block_lightgrey.png", 5, 1);
    public static Block block_lightgreen = new BlockOre("DangerZone:Light Green Block", "res/blocks/block_lightgreen.png", 5, 1);
    public static Block block_lightred = new BlockOre("DangerZone:Light Red Block", "res/blocks/block_lightred.png", 5, 1);
    public static Block block_lightblue = new BlockOre("DangerZone:Light Blue Block", "res/blocks/block_lightblue.png", 5, 1);
    public static Block block_lightyellow = new BlockOre("DangerZone:Light Yellow Block", "res/blocks/block_lightyellow.png", 5, 1);
    public static Block block_lightorange = new BlockOre("DangerZone:Light Orange Block", "res/blocks/block_lightorange.png", 5, 1);
    public static Block block_lightpurple = new BlockOre("DangerZone:Light Purple Block", "res/blocks/block_lightpurple.png", 5, 1);
    public static Block block_lightviolet = new BlockOre("DangerZone:Light Violet Block", "res/blocks/block_lightviolet.png", 5, 1);
    public static Block block_lightbrown = new BlockOre("DangerZone:Light Brown Block", "res/blocks/block_lightbrown.png", 5, 1);
    public static Block block_grey = new BlockOre("DangerZone:Grey Block", "res/blocks/block_grey.png", 5, 1);
    public static Block block_green = new BlockOre("DangerZone:Green Block", "res/blocks/block_green.png", 5, 1);
    public static Block block_red = new BlockOre("DangerZone:Red Block", "res/blocks/block_red.png", 5, 1);
    public static Block block_blue = new BlockOre("DangerZone:Blue Block", "res/blocks/block_blue.png", 5, 1);
    public static Block block_yellow = new BlockOre("DangerZone:Yellow Block", "res/blocks/block_yellow.png", 5, 1);
    public static Block block_orange = new BlockOre("DangerZone:Orange Block", "res/blocks/block_orange.png", 5, 1);
    public static Block block_purple = new BlockOre("DangerZone:Purple Block", "res/blocks/block_purple.png", 5, 1);
    public static Block block_violet = new BlockOre("DangerZone:Violet Block", "res/blocks/block_violet.png", 5, 1);
    public static Block block_brown = new BlockOre("DangerZone:Brown Block", "res/blocks/block_brown.png", 5, 1);
    public static Block block_darkgrey = new BlockOre("DangerZone:Dark Grey Block", "res/blocks/block_darkgrey.png", 5, 1);
    public static Block block_darkgreen = new BlockOre("DangerZone:Dark Green Block", "res/blocks/block_darkgreen.png", 5, 1);
    public static Block block_darkred = new BlockOre("DangerZone:Dark Red Block", "res/blocks/block_darkred.png", 5, 1);
    public static Block block_darkblue = new BlockOre("DangerZone:Dark Blue Block", "res/blocks/block_darkblue.png", 5, 1);
    public static Block block_darkyellow = new BlockOre("DangerZone:Dark Yellow Block", "res/blocks/block_darkyellow.png", 5, 1);
    public static Block block_darkorange = new BlockOre("DangerZone:Dark Orange Block", "res/blocks/block_darkorange.png", 5, 1);
    public static Block block_darkpurple = new BlockOre("DangerZone:Dark Purple Block", "res/blocks/block_darkpurple.png", 5, 1);
    public static Block block_darkviolet = new BlockOre("DangerZone:Dark Violet Block", "res/blocks/block_darkviolet.png", 5, 1);
    public static Block block_darkbrown = new BlockOre("DangerZone:Dark Brown Block", "res/blocks/block_darkbrown.png", 5, 1);
    public static Block reefgrass = new SeaPlant("DangerZone:Reef Grass", "res/blocks/reefgrass.png");
    public static Block redreefgrass = new SeaPlant("DangerZone:Red Reef Grass", "res/blocks/redreefgrass.png");
    public static Block redcoral = new SeaPlant("DangerZone:Red Coral", "res/blocks/redcoral.png");
    public static Block yellowcoral = new SeaPlant("DangerZone:Yellow Coral", "res/blocks/yellowcoral.png");
    public static Block bluecoral = new SeaPlant("DangerZone:Blue Coral", "res/blocks/bluecoral.png");
    public static Block firecoral = new SeaPlant("DangerZone:Fire Coral", "res/blocks/firecoral.png");
    public static Block redfancoral = new SeaPlant("DangerZone:Red Fan Coral", "res/blocks/redfan.png");
    public static Block blackfancoral = new SeaPlant("DangerZone:Black Fan Coral", "res/blocks/blackfan.png");
    public static Block seaweed = new SeaPlant("DangerZone:Seaweed", "res/blocks/seaweed.png");
    public static Block tallseaweed = new TallSeaPlant("DangerZone:Tall Seaweed", "res/blocks/tallseaweed.png");
    public static Block brownseaweed = new SeaPlant("DangerZone:Brown Seaweed", "res/blocks/brownseaweed.png");
    public static Block browntallseaweed = new TallSeaPlant("DangerZone:Tall Brown Seaweed", "res/blocks/browntallseaweed.png");
    public static Block yellowseaweed = new SeaPlant("DangerZone:Yellow Seaweed", "res/blocks/yellowseaweed.png");
    public static Block yellowtallseaweed = new TallSeaPlant("DangerZone:Tall Yellow Seaweed", "res/blocks/tallyellowseaweed.png");
    public static Block kelp = new SeaPlant("DangerZone:Kelp", "res/blocks/kelp.png");
    public static Block tallkelp = new TallSeaPlant("DangerZone:Tall Kelp", "res/blocks/tallkelp.png");
    public static Block[] BlockArray;
    public static final int blocksMAX = 2048;
    public static Properties prop;

    static {
        prop = null;
    }

    public Blocks() {
        BlockArray = new Block[2048];
        int i = 0;
        while (i < 2048) {
            Blocks.BlockArray[i] = null;
            ++i;
        }
    }

    public static int registerBlock(Block b) {
        int i = 0;
        i = 1;
        while (i < 2048) {
            if (BlockArray[i] != null && Blocks.BlockArray[i].uniquename.equals(b.uniquename)) {
                return 0;
            }
            ++i;
        }
        i = 1;
        while (i < 2048) {
            if (BlockArray[i] == null) break;
            ++i;
        }
        if (i >= 2047) {
            return 0;
        }
        if (prop != null) {
            i = Utils.getPropertyInt(prop, b.uniquename, 1, 2047, i);
        }
        if (BlockArray[i] == null) {
            Blocks.BlockArray[i] = b;
            b.blockID = i;
            if (prop != null) {
                prop.setProperty(b.uniquename, String.format("%d", i));
            }
            return i;
        }
        Block intruder = BlockArray[i];
        int isave = i;
        Blocks.BlockArray[i] = b;
        b.blockID = i;
        i = 1;
        while (i < 2048) {
            if (BlockArray[i] == null) {
                Blocks.BlockArray[i] = intruder;
                intruder.blockID = i;
                if (prop != null) {
                    prop.setProperty(intruder.uniquename, String.format("%d", i));
                }
                return isave;
            }
            ++i;
        }
        return 0;
    }

    public static int lookup(String name) {
        int ret = Utils.getPropertyInt(prop, name, 1, 2047, 0);
        return ret;
    }

    public static void addthis(String name, int i) {
        prop.setProperty(name, String.format("%d", i));
    }

    public static void reRegisterBlockAt(String s, int loc) {
        if (loc <= 0 || loc >= 2048) {
            return;
        }
        if (s == null || s.equals("")) {
            return;
        }
        if (BlockArray[loc] != null) {
            if (s.equals(Blocks.BlockArray[loc].uniquename)) {
                return;
            }
            int i = 1;
            while (i < 2048) {
                if (BlockArray[i] != null && s.equals(Blocks.BlockArray[i].uniquename)) {
                    Block me = BlockArray[i];
                    Block intruder = BlockArray[loc];
                    Blocks.BlockArray[loc] = me;
                    Blocks.BlockArray[loc].blockID = loc;
                    Blocks.BlockArray[i] = intruder;
                    Blocks.BlockArray[i].blockID = i;
                    return;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < 2048) {
                if (BlockArray[i] != null && s.equals(Blocks.BlockArray[i].uniquename)) {
                    Blocks.BlockArray[loc] = BlockArray[i];
                    Blocks.BlockArray[loc].blockID = loc;
                    Blocks.BlockArray[i] = null;
                    return;
                }
                ++i;
            }
        }
    }

    public static void load() {
        FileInputStream input = null;
        prop = new Properties();
        String filepath = new String();
        filepath = String.format("worlds/%s/blockIDs.dat", DangerZone.worldname);
        try {
            input = new FileInputStream(filepath);
            prop.load(input);
        }
        catch (IOException ex) {
            input = null;
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        FileOutputStream output = null;
        String filepath = new String();
        filepath = String.format("worlds/%s/blockIDs.dat", DangerZone.worldname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        try {
            output = new FileOutputStream(filepath);
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isSolid(int blockid, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return BlockArray[blockid].getIsSolid(w, d, x, y, z);
    }

    public static boolean isSolidThisSide(int blockid, World w, int d, int x, int y, int z, int side) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return BlockArray[blockid].isSolidThisSide(w, d, x, y, z, side);
    }

    public static void bumpedBlock(int blockid, Entity e, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].bumpedBlock(e, w, d, x, y, z);
    }

    public static boolean isSolid(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isSolid;
    }

    public static boolean isLiquid(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isLiquid;
    }

    public static boolean isValid(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        return BlockArray[blockid] != null;
    }

    public static boolean isSquishy(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isSquishy;
    }

    public static boolean showTop(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].showTop;
    }

    public static boolean isSolidForRender(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isSolidForRendering;
    }

    public static boolean renderAllSides(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].renderAllSides;
    }

    public static boolean renderSmaller(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].renderSmaller;
    }

    public static boolean shouldShow(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].showInInventory;
    }

    public static boolean isTranslucentForRender(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isTranslucent;
    }

    public static boolean hasOwnRenderer(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].hasOwnRenderer;
    }

    public static boolean shouldAlwaysRender(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].alwaysRender;
    }

    public static boolean alwaystick(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].alwaystick;
    }

    public static boolean randomtick(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].randomtick;
    }

    public static boolean isWood(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isWood;
    }

    public static boolean isStone(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isStone;
    }

    public static boolean isDirt(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isDirt;
    }

    public static boolean isLeaves(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isLeaves;
    }

    public static boolean isWaterPlant(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isWaterPlant;
    }

    public static boolean canLeavesGrow(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].canLeavesGrow;
    }

    public static void doblocktick(World w, int d, int x, int y, int z, int blockid) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].tickMe(w, d, x, y, z);
    }

    public static void dofastblocktick(World w, int d, int x, int y, int z, int blockid) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].tickMeFast(w, d, x, y, z);
    }

    public static void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int blockid, int meta, int sides, boolean focused) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].renderMe(wr, w, d, x, y, z, blockid, meta, sides, focused);
    }

    public static void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int blockid, int meta, int sides, boolean focused, int xo, int yo, int zo, VBODataBuilderThread builder) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].renderMeToVBO(chunkvbos, wr, w, d, x, y, z, blockid, meta, sides, focused, xo, yo, zo, builder);
    }

    public static String getBreakSound(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getBreakSound();
    }

    public static String getPlaceSound(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getPlaceSound();
    }

    public static String getHitSound(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getHitSound();
    }

    public static String getParticleName(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getParticleName();
    }

    public static int getMaxStack(int blockid) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return Blocks.BlockArray[blockid].maxstack;
    }

    public static int getMinDamage(int blockid) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return Blocks.BlockArray[blockid].mindamage;
    }

    public static Texture getTexture(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getTexture(1);
    }

    public static int getActiveBlockid(int blockid) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        if (Blocks.BlockArray[blockid].active_partner == null) {
            return 0;
        }
        return Blocks.BlockArray[blockid].active_partner.blockID;
    }

    public static int getStaticBlockid(int blockid) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        if (Blocks.BlockArray[blockid].static_partner == null) {
            return 0;
        }
        return Blocks.BlockArray[blockid].static_partner.blockID;
    }

    public static Texture getTextureForSide(int blockid, int side) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getTexture(side);
    }

    public static void notifyNeighborChanged(int blockid, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].notifyNeighborChanged(w, d, x, y, z);
    }

    public static String getUniqueName(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return Blocks.BlockArray[blockid].uniquename;
    }

    public static int findByName(String name) {
        if (name == null) {
            return 0;
        }
        int i = 1;
        while (i < 2048) {
            if (BlockArray[i] != null && Blocks.BlockArray[i].uniquename != null && name.equals(Blocks.BlockArray[i].uniquename)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static void entityInLiquid(int blockid, Entity e) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].entityInLiquid(e);
    }

    public static boolean rightClickOnBlock(int blockid, Player p, int d, int x, int y, int z, int s) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return BlockArray[blockid].rightClickOnBlock(p, d, x, y, z, s);
    }

    public static boolean leftClickOnBlock(int blockid, Player p, int d, int x, int y, int z, int s) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return BlockArray[blockid].leftClickOnBlock(p, d, x, y, z, s);
    }

    public static void onBlockBroken(int blockid, Player p, int d, int x, int y, int z, int s) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].onBlockBroken(p, d, x, y, z, s);
    }

    public static int getMaxDamage(int blockid) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return Blocks.BlockArray[blockid].maxdamage;
    }

    public static int getBlockDrop(int blockid, Player p, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return BlockArray[blockid].getBlockDrop(p, w, d, x, y, z);
    }

    public static int getItemDrop(int blockid, Player p, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return BlockArray[blockid].getItemDrop(p, w, d, x, y, z);
    }

    public static int getDropCount(int blockid, Player p, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return BlockArray[blockid].getDropCount(p, w, d, x, y, z);
    }

    public static float getFriction(int blockid) {
        if (blockid <= 0) {
            return 0.0f;
        }
        if (blockid >= 2048) {
            return 0.0f;
        }
        if (BlockArray[blockid] == null) {
            return 0.0f;
        }
        return Blocks.BlockArray[blockid].friction;
    }

    public static float getLightLevel(int blockid, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return 0.0f;
        }
        if (blockid >= 2048) {
            return 0.0f;
        }
        if (BlockArray[blockid] == null) {
            return 0.0f;
        }
        return BlockArray[blockid].getBrightness(w, d, x, y, z);
    }

    public static void doSteppedOn(int blockid, Entity e, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].doSteppedOn(e, w, d, x, y, z);
    }

    public static void doIsIn(int blockid, Entity e, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].doIsIn(e, w, d, x, y, z);
    }

    public static void doEntered(int blockid, Entity e, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].doEntered(e, w, d, x, y, z);
    }

    public static boolean doPlaceBlock(int blockid, int focusbid, Player p, World w, int d, int x, int y, int z, int side) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return BlockArray[blockid].doPlaceBlock(focusbid, p, w, d, x, y, z, side);
    }

    public static void doBreakBlock(int blockid, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        int bid = BlockArray[blockid].getBlockDrop(null, w, d, x, y, z);
        int iid = BlockArray[blockid].getItemDrop(null, w, d, x, y, z);
        int count = BlockArray[blockid].getDropCount(null, w, d, x, y, z);
        int i = 0;
        while (i < count) {
            if (bid != 0 || iid != 0) {
                EntityBlockItem eb;
                if (bid != 0 && (eb = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
                    eb.setBID(bid);
                    eb.fill(bid, 0, BlockArray[blockid].getDropCount(null, w, d, x, y, z));
                    w.spawnEntityInWorld(eb);
                }
                if (iid != 0 && (eb = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
                    eb.setIID(iid);
                    eb.fill(0, iid, BlockArray[blockid].getDropCount(null, w, d, x, y, z));
                    w.spawnEntityInWorld(eb);
                }
            }
            ++i;
        }
    }

    public static int getBurnTime(int blockid) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return Blocks.BlockArray[blockid].burntime;
    }

    public static int getMenu(int blockid) {
        if (blockid <= 0) {
            return InventoryMenus.GENERIC;
        }
        if (blockid >= 2048) {
            return InventoryMenus.GENERIC;
        }
        if (BlockArray[blockid] == null) {
            return InventoryMenus.GENERIC;
        }
        return Blocks.BlockArray[blockid].menu;
    }

    public static Block getBlock(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        return BlockArray[blockid];
    }

    public static String getStepSound(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getStepSound();
    }

    public static void renderMeHeld(WorldRenderer wr, Entity e, int blockid, boolean isdisplay) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].renderMeHeld(wr, e, blockid, isdisplay);
    }
}

