/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.blocks.Block;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityChest;
import dangerzone.rendering.StitchedTexture;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class BlockChest
extends Block {
    Texture ttop = null;
    Texture tbottom = null;
    Texture tleft = null;
    Texture tright = null;
    Texture tfront = null;
    Texture tback = null;
    String topname = "res/blocks/chest_top.png";
    String bottomname = "res/blocks/chest_bottom.png";
    String leftname = "res/blocks/chest_left.png";
    String rightname = "res/blocks/chest_right.png";
    String frontname = "res/blocks/chest_front.png";
    String backname = "res/blocks/chest_back.png";
    StitchedTexture sttop = new StitchedTexture();
    StitchedTexture stbottom = new StitchedTexture();
    StitchedTexture stleft = new StitchedTexture();
    StitchedTexture stright = new StitchedTexture();
    StitchedTexture stfront = new StitchedTexture();
    StitchedTexture stback = new StitchedTexture();

    public BlockChest(String n) {
        super(n, "");
        this.maxstack = 8;
        this.isWood = true;
        this.hasFront = true;
        this.burntime = 100;
    }

    @Override
    public String getStepSound() {
        int i = DangerZone.rand.nextInt(4);
        if (i == 0) {
            return "DangerZone:wood1";
        }
        if (i == 1) {
            return "DangerZone:wood2";
        }
        if (i == 2) {
            return "DangerZone:wood3";
        }
        return "DangerZone:wood4";
    }

    @Override
    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int s) {
        if (p == null) {
            return false;
        }
        if (p.world.isServer) {
            Entity eb;
            if (p.world.rand.nextInt(100) == 1 && (eb = p.world.createEntityByName("DangerZone:Cockroach", dimension, (double)x + 0.5, (double)y + (double)1.05f, (double)z + 0.5)) != null) {
                eb.init();
                p.world.spawnEntityInWorld(eb);
            }
            if (p.world.rand.nextInt(500) == 1 && (eb = p.world.createEntityByName("DangerZone:Rat", dimension, (double)x + 0.5, (double)y + (double)1.05f, (double)z + 0.5)) != null) {
                eb.init();
                p.world.spawnEntityInWorld(eb);
            }
            return false;
        }
        List<Entity> nearby_list = null;
        EntityChest ec = null;
        nearby_list = DangerZone.clientEntityManager.findEntitiesInRange(2.0f, dimension, x, y, z);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!(e instanceof EntityChest)) continue;
                if ((int)e.posx == x && (int)e.posy == y && (int)e.posz == z) {
                    ec = (EntityChest)e;
                    break;
                }
                ec = null;
            }
        }
        if (ec == null) {
            return false;
        }
        DangerZone.chestgui.ec = ec;
        DangerZone.setActiveGui(DangerZone.chestgui);
        p.world.playSound("DangerZone:chest_open", dimension, x, y, z, 0.75f, 1.0f);
        return false;
    }

    @Override
    public void onBlockPlaced(World w, int dimension, int x, int y, int z) {
        Entity eb;
        if (w.isServer && (eb = w.createEntityByName("DangerZone:EntityChest", dimension, (double)x + 0.5, (double)y + (double)0.05f, (double)z + 0.5)) != null) {
            eb.init();
            w.spawnEntityInWorld(eb);
        }
    }

    @Override
    public Texture getTexture(int side) {
        if (this.ttop == null) {
            this.ttop = this.initBlockTexture(this.topname);
        }
        if (this.tbottom == null) {
            this.tbottom = this.initBlockTexture(this.bottomname);
        }
        if (this.tleft == null) {
            this.tleft = this.initBlockTexture(this.leftname);
        }
        if (this.tright == null) {
            this.tright = this.initBlockTexture(this.rightname);
        }
        if (this.tfront == null) {
            this.tfront = this.initBlockTexture(this.frontname);
        }
        if (this.tback == null) {
            this.tback = this.initBlockTexture(this.backname);
        }
        if (side == 0) {
            return this.ttop;
        }
        if (side == 5) {
            return this.tbottom;
        }
        if (side == 3) {
            return this.tleft;
        }
        if (side == 4) {
            return this.tright;
        }
        if (side == 1) {
            return this.tfront;
        }
        if (side == 2) {
            return this.tback;
        }
        return null;
    }

    @Override
    public StitchedTexture getStitchedTexture(int side) {
        if (side == 0) {
            return this.sttop;
        }
        if (side == 5) {
            return this.stbottom;
        }
        if (side == 3) {
            return this.stleft;
        }
        if (side == 4) {
            return this.stright;
        }
        if (side == 1) {
            return this.stfront;
        }
        return this.stback;
    }

    @Override
    public String getStitchedTextureName(int side) {
        if (side == 0) {
            return this.topname;
        }
        if (side == 5) {
            return this.bottomname;
        }
        if (side == 3) {
            return this.leftname;
        }
        if (side == 4) {
            return this.rightname;
        }
        if (side == 1) {
            return this.frontname;
        }
        return this.backname;
    }
}

