/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.biomes;

import dangerzone.DangerZone;
import dangerzone.biomes.Biome;
import dangerzone.biomes.Trees;
import dangerzone.blocks.Blocks;
import dangerzone.rendering.Fastmath;
import dangerzone.world.Chunk;
import dangerzone.world.Ores;
import dangerzone.world.World;
import java.util.Random;

public class WindsweptBiome
extends Biome {
    Trees tr = new Trees();
    float[] biomefloats = new float[this.biolen];
    float[] biomeoffs = new float[this.biolen];
    float[] biomescalex = new float[this.biolen];
    float[] biomescalez = new float[this.biolen];
    int[] biomepwrs = new int[this.biolen];
    int[] biomept = new int[this.biolen];
    int biolen = 20;
    public float hilliness = 7.5f;
    public float roughness = 0.75f;

    public WindsweptBiome(String n) {
        super(n);
        int i = this.biomefloats.length;
        Random myrand = DangerZone.server_world != null ? new Random(DangerZone.server_world.worldseed + this.bioRand) : new Random(this.bioRand);
        int j = 0;
        while (j < i) {
            if (myrand.nextInt(3) == 0) {
                this.biomefloats[j] = this.hilliness / 2.0f + myrand.nextFloat() * this.hilliness;
                this.biomescalex[j] = (0.1f + myrand.nextFloat()) * 10.0f;
                this.biomescalez[j] = (0.1f + myrand.nextFloat()) * 10.0f;
            } else {
                this.biomefloats[j] = (0.1f + myrand.nextFloat()) * this.roughness;
                this.biomescalex[j] = (0.1f + myrand.nextFloat()) * 15.0f;
                this.biomescalez[j] = (0.1f + myrand.nextFloat()) * 15.0f;
            }
            this.biomeoffs[j] = myrand.nextFloat() * 3.1415f;
            this.biomepwrs[j] = 1 + myrand.nextInt(6);
            this.biomept[j] = myrand.nextInt(2);
            ++j;
        }
    }

    public float genvalue(int dx, int dz) {
        int iters = this.biomefloats.length;
        float fval = 1.0f;
        int i = 0;
        while (i < iters) {
            fval = this.biomept[i] == 0 ? (fval += this.getoneval(i, dx, dz)) : (fval -= this.getoneval(i, dx, dz));
            ++i;
        }
        return fval;
    }

    public float getoneval(int index, int dx, int dz) {
        float fval = 0.0f;
        float tval = fval = (float)Fastmath.sin((double)this.biomeoffs[index] + Math.toRadians((float)dx * this.biomescalex[index] + (float)dz * this.biomescalez[index]));
        int i = 0;
        while (i < this.biomepwrs[index]) {
            fval *= tval;
            ++i;
        }
        return fval *= this.biomefloats[index];
    }

    @Override
    public void generateheightmaps(World w, int d, Chunk c, int cx, int cz, int[][] dirtheight, int[][] stoneheight, int[][] baseheight) {
    }

    @Override
    public void generate(World w, int d, Chunk c, int cx, int cz, int[][] dirtheight, int[][] stoneheight, int[][] lm3) {
        int dx = (cx << 4) + (int)(w.worldseed & 0xFFFFL);
        int dz = (cz << 4) + (int)(w.worldseed >> 16 & 0xFFFFL);
        dx %= 1080000;
        dz %= 1080000;
        int j = 0;
        while (j < 63) {
            int i = 0;
            while (i < 16) {
                int k = 0;
                while (k < 16) {
                    if (j < 40) {
                        c.setblock(i, j, k, Blocks.greystone.blockID);
                    } else {
                        if (j == 40) {
                            c.setblock(i, j, k, Blocks.grassblock.blockID);
                            c.setblockmeta(i, j, k, Fastmath.nextInt(4) << 12);
                        }
                        float tval = this.genvalue(dx + i, dz + k);
                        if (j < 50) {
                            tval += 1.1f * (float)(50 - j);
                        }
                        if (tval > 0.0f) {
                            float fval = this.genvalue(dx + i + j, dz + k + j) - this.genvalue(dx + i - j, dz + k - j);
                            if (j > 60) {
                                fval -= 10.1f * (float)(j - 60);
                            }
                            if (j < 50) {
                                fval += 10.1f * (float)(50 - j);
                            }
                            if (fval > 0.0f) {
                                if (j > 60) {
                                    if (j > 61) {
                                        c.setblock(i, j, k, Blocks.grassblock.blockID);
                                        c.setblockmeta(i, j, k, Fastmath.nextInt(4) << 12);
                                    } else {
                                        c.setblock(i, j, k, Blocks.dirt.blockID);
                                    }
                                } else {
                                    c.setblock(i, j, k, Blocks.stone.blockID);
                                }
                            }
                        }
                    }
                    if (j == 0) {
                        c.setblock(i, j, k, Blocks.stopblock.blockID);
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        Ores.generate(w, d, this, c, cx, cz);
    }

    @Override
    public void decorate(World world, int d, Chunk c, int chunkx, int chunkz) {
        this.tr.addGenericTrees(world, d, chunkx << 4, chunkz << 4);
        this.tr.addGrass(world, d, chunkx << 4, chunkz << 4, c);
    }
}

