/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.KVPair;
import dangerzone.Player;
import dangerzone.StuffList;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityChest;
import dangerzone.entities.EntityExp;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.EntityNoob;
import dangerzone.items.Item;
import dangerzone.items.Items;
import dangerzone.particles.Particle;
import dangerzone.rendering.Fastmath;
import dangerzone.world.Dimensions;
import dangerzone.world.World;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import slick.ResourceLoader;
import slick.Texture;
import slick.TextureLoader;

public class Utils {
    public static void add_chest(World w, int dimension, int x, int y, int z, StuffList[] stuff) {
        int nthings = w.rand.nextInt(25) + 20;
        Utils.add_chest(w, dimension, x, y, z, stuff, nthings);
    }

    public static void add_chest(World w, int dimension, int x, int y, int z, StuffList[] stuff, int chances) {
        if (!w.isServer) {
            return;
        }
        int meta = 0;
        if (w.getblock(dimension, x, y, z + 1) != 0) {
            meta = 8192;
            if (w.getblock(dimension, x, y, z - 1) != 0) {
                meta = 12288;
                if (w.getblock(dimension, x - 1, y, z) != 0) {
                    meta = 4096;
                    if (w.getblock(dimension, x + 1, y, z) != 0) {
                        meta = 0;
                    }
                }
            }
        }
        w.setblockandmeta(dimension, x, y, z, Blocks.chest.blockID, meta);
        Entity eb = w.createEntityByName("DangerZone:EntityChest", dimension, (double)x + 0.5, (double)y + (double)0.05f, (double)z + 0.5);
        if (eb != null) {
            eb.init();
            EntityChest ec = (EntityChest)eb;
            if (stuff != null && stuff.length > 0 && chances > 0) {
                int i = 0;
                while (i < chances) {
                    int where = w.rand.nextInt(50);
                    int val = w.rand.nextInt(100);
                    int which = stuff.length < 2 ? 0 : w.rand.nextInt(stuff.length);
                    if (val <= stuff[which].chance) {
                        int howmany = stuff[which].min;
                        if (stuff[which].max - stuff[which].min > 0) {
                            howmany += w.rand.nextInt(stuff[which].max - stuff[which].min + 1);
                        }
                        int bid = stuff[which].getbid();
                        int iid = stuff[which].getiid();
                        if (bid != 0 && howmany > Blocks.getMaxStack(bid)) {
                            howmany = Blocks.getMaxStack(bid);
                        }
                        if (iid != 0 && howmany > Items.getMaxStack(iid)) {
                            howmany = Items.getMaxStack(iid);
                        }
                        if (!(bid != 0 && iid != 0 || bid == 0 && iid == 0 || bid < 0 || iid < 0 || howmany <= 0)) {
                            ec.setInventory(where, new InventoryContainer(bid, iid, howmany, 0));
                        }
                    }
                    ++i;
                }
            }
            w.spawnEntityInWorld(eb);
        }
    }

    public static EntityChest add_empty_chest(World w, int dimension, int x, int y, int z) {
        int meta = 0;
        if (w.getblock(dimension, x, y, z + 1) != 0) {
            meta = 8192;
            if (w.getblock(dimension, x, y, z - 1) != 0) {
                meta = 12288;
                if (w.getblock(dimension, x - 1, y, z) != 0) {
                    meta = 4096;
                    if (w.getblock(dimension, x + 1, y, z) != 0) {
                        meta = 0;
                    }
                }
            }
        }
        w.setblockandmeta(dimension, x, y, z, Blocks.chest.blockID, meta);
        Entity eb = w.createEntityByName("DangerZone:EntityChest", dimension, (double)x + 0.5, (double)y + (double)0.05f, (double)z + 0.5);
        if (eb != null) {
            eb.init();
            w.spawnEntityInWorld(eb);
            return (EntityChest)eb;
        }
        return null;
    }

    public static void add_to_chest(EntityChest ec, int bid, int iid, int howmany, int slot) {
        if (howmany == 0) {
            ec.setInventory(slot, null);
            return;
        }
        if (bid != 0 && howmany > Blocks.getMaxStack(bid)) {
            howmany = Blocks.getMaxStack(bid);
        }
        if (iid != 0 && howmany > Items.getMaxStack(iid)) {
            howmany = Items.getMaxStack(iid);
        }
        if (howmany > 0) {
            ec.setInventory(slot, new InventoryContainer(bid, iid, howmany, 0));
        } else {
            ec.setInventory(slot, null);
        }
    }

    public static void screenshot(int width, int height) {
        GL11.glReadBuffer((int)1028);
        int bpp = 4;
        ByteBuffer buffer = BufferUtils.createByteBuffer(width * height * bpp);
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)buffer);
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HHmmss");
        String filepath = new String();
        filepath = String.format("screenshots/DZimage_%s.png", df.format(date));
        File file = new File(filepath);
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
        }
        catch (IOException e1) {
            return;
        }
        String format = "PNG";
        BufferedImage image = new BufferedImage(width, height, 1);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int i = (x + width * y) * bpp;
                int r = buffer.get(i) & 0xFF;
                int g = buffer.get(i + 1) & 0xFF;
                int b = buffer.get(i + 2) & 0xFF;
                image.setRGB(x, height - (y + 1), 0xFF000000 | r << 16 | g << 8 | b);
                ++y;
            }
            ++x;
        }
        try {
            ImageIO.write((RenderedImage)image, format, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        image.flush();
    }

    public static double getDistanceBetweenEntities(Entity e, Entity p) {
        double d1 = p.posx - e.posx;
        double d2 = p.posy - e.posy;
        double d3 = p.posz - e.posz;
        return Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }

    public static double getHorizontalDistanceBetweenEntities(Entity e, Entity p) {
        double d1 = p.posx - e.posx;
        double d3 = p.posz - e.posz;
        return Math.sqrt(d1 * d1 + d3 * d3);
    }

    public static int getPropertyInt(Properties prop, String propname, int min, int max, int dflt) {
        int retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            try {
                retval = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                retval = dflt;
            }
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static long getPropertyLong(Properties prop, String propname, long min, long max, long dflt) {
        long retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            try {
                retval = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                retval = dflt;
            }
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static float getPropertyFloat(Properties prop, String propname, float min, float max, float dflt) {
        float retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            try {
                retval = Float.parseFloat(s);
            }
            catch (NumberFormatException e) {
                retval = dflt;
            }
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static double getPropertyDouble(Properties prop, String propname, double min, double max, double dflt) {
        double retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            try {
                retval = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                retval = dflt;
            }
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static boolean getPropertyBoolean(Properties prop, String propname, boolean dflt) {
        boolean retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            if (s.equalsIgnoreCase("true")) {
                return true;
            }
            if (s.equalsIgnoreCase("false")) {
                return false;
            }
            retval = Boolean.parseBoolean(s);
        }
        return retval;
    }

    public static String getPropertyString(Properties prop, String propname, String dflt) {
        String retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = s;
        }
        return retval;
    }

    public static void spawnParticlesFromServer(World w, String name, int howmany, int d, double x, double y, double z) {
        if (w.isServer) {
            DangerZone.server.sendSpawnParticleToAllExcept(null, name, howmany, d, x, y, z);
        }
    }

    public static void spawnParticlesFromServer(World w, String name, int howmany, int d, double x, double y, double z, int bid) {
        if (w.isServer) {
            DangerZone.server.sendSpawnParticleToAllExcept(null, name, howmany, d, x, y, z, bid);
        }
    }

    public static void spawnParticlesFromServerScaled(World w, String name, int howmany, int d, double x, double y, double z, int bid, float scale) {
        if (w.isServer) {
            DangerZone.server.sendSpawnParticleScaledToAllExcept(null, name, howmany, d, x, y, z, bid, scale);
        }
    }

    public static void spawnParticlesFromServerScaledWithDirection(World w, String name, int howmany, int d, double x, double y, double z, float mx, float my, float mz, int bid, float scale, float vel, float randness) {
        if (w.isServer) {
            DangerZone.server.sendSpawnParticleScaledWithDirectionToAllExcept(null, name, howmany, d, x, y, z, mx, my, mz, bid, scale, vel, randness);
        }
    }

    public static void spawnParticles(World w, String name, int howmany, int d, double x, double y, double z, boolean forwardtoserver) {
        if (w.isServer) {
            if (forwardtoserver) {
                DangerZone.server.sendSpawnParticleToAllExcept(null, name, howmany, d, x, y, z, 0);
            }
        } else {
            Utils.spawnParticles(w, name, howmany, d, x, y, z, 0, forwardtoserver);
        }
    }

    public static void spawnParticles(World w, String name, int howmany, int d, double x, double y, double z, int bid, boolean forwardtoserver) {
        if (!w.isServer) {
            boolean isItem = name.equals("DangerZone:ParticleItem");
            int i = 0;
            while (i < howmany) {
                Particle eb = w.createParticleByName(name, d, x, y, z);
                if (eb != null) {
                    if (!isItem) {
                        int ibid;
                        eb.bid = ibid = bid;
                    } else {
                        eb.iid = bid;
                    }
                    w.spawnParticleInWorld(eb);
                }
                ++i;
            }
        }
        if (forwardtoserver && !w.isServer) {
            DangerZone.player.server_connection.sendSpawnParticles(name, howmany, d, x, y, z, bid);
        }
        if (w.isServer) {
            DangerZone.server.sendSpawnParticleToAllExcept(null, name, howmany, d, x, y, z, bid);
        }
    }

    public static void spawnParticlesScaled(World w, String name, int howmany, int d, double x, double y, double z, int bid, float scale, boolean forwardtoserver) {
        if (!w.isServer) {
            boolean isItem = name.equals("DangerZone:ParticleItem");
            int i = 0;
            while (i < howmany) {
                Particle eb = w.createParticleByName(name, d, x, y, z);
                if (eb != null) {
                    if (!isItem) {
                        eb.bid = bid;
                    } else {
                        eb.iid = bid;
                    }
                    eb.maxrenderdist = (int)((float)eb.maxrenderdist * (5.0f * scale));
                    if (eb.maxrenderdist < 16) {
                        eb.maxrenderdist = 16;
                    }
                    if (eb.maxrenderdist > 128) {
                        eb.maxrenderdist = 128;
                    }
                    if (scale < 0.05f) {
                        scale = 0.05f;
                    }
                    if (scale > 3.0f) {
                        scale = 3.0f;
                    }
                    eb.scale = scale;
                    eb.motionx *= scale;
                    eb.motiony *= scale;
                    eb.motionz *= scale;
                    w.spawnParticleInWorld(eb);
                }
                ++i;
            }
        }
        if (forwardtoserver && !w.isServer) {
            DangerZone.player.server_connection.sendSpawnParticlesScaled(name, howmany, d, x, y, z, bid, scale);
        }
        if (w.isServer) {
            DangerZone.server.sendSpawnParticleScaledToAllExcept(null, name, howmany, d, x, y, z, bid, scale);
        }
    }

    public static void spawnParticlesScaledWithDirection(World w, String name, int howmany, int d, double x, double y, double z, float mx, float my, float mz, int bid, float scale, float vel, float randness, boolean forwardtoserver) {
        if (!w.isServer) {
            boolean isItem = name.equals("DangerZone:ParticleItem");
            if (scale < 0.05f) {
                scale = 0.05f;
            }
            if (scale > 3.0f) {
                scale = 3.0f;
            }
            int i = 0;
            while (i < howmany) {
                Particle eb = w.createParticleByName(name, d, x, y, z);
                if (eb != null) {
                    if (!isItem) {
                        eb.bid = bid;
                    } else {
                        eb.iid = bid;
                    }
                    eb.maxrenderdist = (int)((float)eb.maxrenderdist * (5.0f * scale));
                    if (eb.maxrenderdist < 16) {
                        eb.maxrenderdist = 16;
                    }
                    if (eb.maxrenderdist > 128) {
                        eb.maxrenderdist = 128;
                    }
                    eb.scale = scale;
                    eb.motionx = mx * scale * vel;
                    float rf = Fastmath.nextFloat() - Fastmath.nextFloat();
                    eb.motionx += scale * vel * (rf *= randness);
                    eb.motionx *= Math.abs(randness) - Math.abs(rf);
                    eb.motiony = my * scale * vel;
                    rf = Fastmath.nextFloat() - Fastmath.nextFloat();
                    eb.motiony += scale * vel * (rf *= randness);
                    eb.motiony *= Math.abs(randness) - Math.abs(rf);
                    eb.motionz = mz * scale * vel;
                    rf = Fastmath.nextFloat() - Fastmath.nextFloat();
                    eb.motionz += scale * vel * (rf *= randness);
                    eb.motionz *= Math.abs(randness) - Math.abs(rf);
                    w.spawnParticleInWorld(eb);
                }
                ++i;
            }
        }
        if (forwardtoserver && !w.isServer) {
            DangerZone.player.server_connection.sendSpawnParticlesScaledWithDirection(name, howmany, d, x, y, z, mx, my, mz, bid, scale, vel, randness);
        }
        if (w.isServer) {
            DangerZone.server.sendSpawnParticleScaledWithDirectionToAllExcept(null, name, howmany, d, x, y, z, mx, my, mz, bid, scale, vel, randness);
        }
    }

    public static void spawnDeathParticles(World w, int d, double x, double y, double z, float width, float height) {
        if (!w.isServer) {
            float mf;
            int howmany = (int)(20.0f * (width + height));
            if (howmany < 20) {
                howmany = 20;
            }
            if (howmany > 500) {
                howmany = 500;
            }
            if ((mf = (width + height) / 3.5f) < 0.125f) {
                mf = 0.125f;
            }
            if (mf > 10.0f) {
                mf = 10.0f;
            }
            int i = 0;
            while (i < howmany) {
                Particle eb = w.createParticleByName("DangerZone:ParticleDeath", d, x + (double)((Fastmath.nextFloat() - Fastmath.nextFloat()) * width / 2.0f), y + (double)(Fastmath.nextFloat() * height), z + (double)((Fastmath.nextFloat() - Fastmath.nextFloat()) * width / 2.0f));
                if (eb != null) {
                    eb.motionx *= mf;
                    eb.motiony *= mf;
                    eb.motionz *= mf;
                    eb.scale *= mf;
                    w.spawnParticleInWorld(eb);
                }
                ++i;
            }
        }
    }

    public static void spitInventoryOut(InventoryContainer ic) {
        EntityBlockItem e;
        if (ic != null && (e = (EntityBlockItem)DangerZone.player.world.createEntityByName(DangerZone.blockitemname, DangerZone.player.dimension, DangerZone.player.posx + Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)), DangerZone.player.posy + (double)(DangerZone.player.getHeight() * 7.0f / 8.0f) - Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head)), DangerZone.player.posz + Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)))) != null) {
            e.init();
            e.fill(ic);
            e.rotation_pitch = DangerZone.world.rand.nextInt(360);
            e.rotation_yaw = DangerZone.world.rand.nextInt(360);
            e.rotation_roll = DangerZone.world.rand.nextInt(360);
            e.motionx = 0.0f;
            e.motiony = 0.0f;
            e.motionz = 0.0f;
            DangerZone.player.world.spawnEntityInWorld(e);
        }
    }

    public static void spawnExperience(int exp, World world, int d, double x, double y, double z) {
        Utils.spawnExperience(exp, world, d, x, y, z, true);
    }

    /*
     * Unable to fully structure code
     */
    public static void spawnExperience(int exp, World world, int d, double x, double y, double z, boolean popsound) {
        iexp = exp;
        popper = 0;
        if (!popsound) {
            popper = 1;
        }
        if (exp >= 0) ** GOTO lbl21
        Utils.spawnNoob(exp, world, d, x, y, z, popsound);
        return;
lbl-1000:
        // 1 sources

        {
            e = (EntityExp)world.createEntityByName("DangerZone:Experience", d, x, y, z);
            if (e != null) {
                e.setBID(popper);
                e.setIID(0);
                e.setExperience(1000);
                e.rotation_pitch = 0.0f;
                e.rotation_yaw = world.rand.nextInt(360);
                e.rotation_roll = 0.0f;
                e.motionx = Fastmath.nextFloat() - Fastmath.nextFloat();
                e.motiony = Fastmath.nextFloat() / 4.0f;
                e.motionz = Fastmath.nextFloat() - Fastmath.nextFloat();
                world.spawnEntityInWorld(e);
            }
            iexp -= 1000;
lbl21:
            // 2 sources

            ** while (iexp >= 1000)
        }
lbl22:
        // 2 sources

        while (iexp >= 100) {
            e = (EntityExp)world.createEntityByName("DangerZone:Experience", d, x, y, z);
            if (e != null) {
                e.setBID(popper);
                e.setIID(0);
                e.setExperience(100);
                e.rotation_pitch = 0.0f;
                e.rotation_yaw = world.rand.nextInt(360);
                e.rotation_roll = 0.0f;
                e.motionx = Fastmath.nextFloat() - Fastmath.nextFloat();
                e.motiony = Fastmath.nextFloat() / 4.0f;
                e.motionz = Fastmath.nextFloat() - Fastmath.nextFloat();
                world.spawnEntityInWorld(e);
            }
            iexp -= 100;
        }
        while (iexp >= 10) {
            e = (EntityExp)world.createEntityByName("DangerZone:Experience", d, x, y, z);
            if (e != null) {
                e.setBID(popper);
                e.setIID(0);
                e.setExperience(10);
                e.rotation_pitch = 0.0f;
                e.rotation_yaw = world.rand.nextInt(360);
                e.rotation_roll = 0.0f;
                e.motionx = Fastmath.nextFloat() - Fastmath.nextFloat();
                e.motiony = Fastmath.nextFloat() / 4.0f;
                e.motionz = Fastmath.nextFloat() - Fastmath.nextFloat();
                world.spawnEntityInWorld(e);
            }
            iexp -= 10;
        }
        while (iexp >= 1) {
            e = (EntityExp)world.createEntityByName("DangerZone:Experience", d, x, y, z);
            if (e != null) {
                e.setBID(popper);
                e.setIID(0);
                e.setExperience(1);
                e.rotation_pitch = 0.0f;
                e.rotation_yaw = world.rand.nextInt(360);
                e.rotation_roll = 0.0f;
                e.motionx = Fastmath.nextFloat() - Fastmath.nextFloat();
                e.motiony = Fastmath.nextFloat() / 4.0f;
                e.motionz = Fastmath.nextFloat() - Fastmath.nextFloat();
                world.spawnEntityInWorld(e);
            }
            --iexp;
        }
    }

    public static void spawnNoob(int exp, World world, int d, double x, double y, double z, boolean popsound) {
        EntityNoob e;
        int iexp = -exp;
        int popper = 0;
        if (!popsound) {
            popper = 1;
        }
        while (iexp >= 1000) {
            e = (EntityNoob)world.createEntityByName("DangerZone:Noob", d, x, y, z);
            if (e != null) {
                e.setBID(popper);
                e.setIID(0);
                e.setExperience(1000);
                e.rotation_pitch = 0.0f;
                e.rotation_yaw = world.rand.nextInt(360);
                e.rotation_roll = 0.0f;
                e.motionx = Fastmath.nextFloat() - Fastmath.nextFloat();
                e.motiony = Fastmath.nextFloat() / 4.0f;
                e.motionz = Fastmath.nextFloat() - Fastmath.nextFloat();
                world.spawnEntityInWorld(e);
            }
            iexp -= 1000;
        }
        while (iexp >= 100) {
            e = (EntityNoob)world.createEntityByName("DangerZone:Noob", d, x, y, z);
            if (e != null) {
                e.setBID(popper);
                e.setIID(0);
                e.setExperience(100);
                e.rotation_pitch = 0.0f;
                e.rotation_yaw = world.rand.nextInt(360);
                e.rotation_roll = 0.0f;
                e.motionx = Fastmath.nextFloat() - Fastmath.nextFloat();
                e.motiony = Fastmath.nextFloat() / 4.0f;
                e.motionz = Fastmath.nextFloat() - Fastmath.nextFloat();
                world.spawnEntityInWorld(e);
            }
            iexp -= 100;
        }
        while (iexp >= 10) {
            e = (EntityNoob)world.createEntityByName("DangerZone:Noob", d, x, y, z);
            if (e != null) {
                e.setBID(popper);
                e.setIID(0);
                e.setExperience(10);
                e.rotation_pitch = 0.0f;
                e.rotation_yaw = world.rand.nextInt(360);
                e.rotation_roll = 0.0f;
                e.motionx = Fastmath.nextFloat() - Fastmath.nextFloat();
                e.motiony = Fastmath.nextFloat() / 4.0f;
                e.motionz = Fastmath.nextFloat() - Fastmath.nextFloat();
                world.spawnEntityInWorld(e);
            }
            iexp -= 10;
        }
        while (iexp >= 1) {
            e = (EntityNoob)world.createEntityByName("DangerZone:Noob", d, x, y, z);
            if (e != null) {
                e.setBID(popper);
                e.setIID(0);
                e.setExperience(1);
                e.rotation_pitch = 0.0f;
                e.rotation_yaw = world.rand.nextInt(360);
                e.rotation_roll = 0.0f;
                e.motionx = Fastmath.nextFloat() - Fastmath.nextFloat();
                e.motiony = Fastmath.nextFloat() / 4.0f;
                e.motionz = Fastmath.nextFloat() - Fastmath.nextFloat();
                world.spawnEntityInWorld(e);
            }
            --iexp;
        }
    }

    public static void doDropRand(World w, Object obj, float dist, int d, double x, double y, double z) {
        if (obj == null) {
            return;
        }
        int iid = 0;
        int bid = 0;
        if (obj instanceof Item) {
            iid = ((Item)obj).itemID;
        }
        if (obj instanceof Block) {
            bid = ((Block)obj).blockID;
        }
        if (iid == 0 && bid == 0) {
            return;
        }
        EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, x, y, z);
        if (e != null) {
            e.init();
            e.fill(bid, iid, 1);
            e.rotation_pitch = w.rand.nextInt(360);
            e.rotation_yaw = w.rand.nextInt(360);
            e.rotation_roll = w.rand.nextInt(360);
            e.motionx = dist * (Fastmath.nextFloat() - Fastmath.nextFloat());
            e.motiony = dist * Fastmath.nextFloat() / 4.0f;
            e.motionz = dist * (Fastmath.nextFloat() - Fastmath.nextFloat());
            w.spawnEntityInWorld(e);
        }
    }

    public static void doDropRand(World w, int blockid, int itemid, float dist, int d, double x, double y, double z) {
        if (blockid == itemid) {
            return;
        }
        if (blockid < 0 || itemid < 0) {
            return;
        }
        if (blockid != 0 && itemid != 0) {
            return;
        }
        EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, x, y, z);
        if (e != null) {
            e.init();
            e.fill(blockid, itemid, 1);
            e.rotation_pitch = w.rand.nextInt(360);
            e.rotation_yaw = w.rand.nextInt(360);
            e.rotation_roll = w.rand.nextInt(360);
            e.motionx = dist * (Fastmath.nextFloat() - Fastmath.nextFloat());
            e.motiony = dist * Fastmath.nextFloat() / 4.0f;
            e.motionz = dist * (Fastmath.nextFloat() - Fastmath.nextFloat());
            w.spawnEntityInWorld(e);
        }
    }

    public static void doDropRand(World w, InventoryContainer ic, float dist, int d, double x, double y, double z) {
        if (ic == null) {
            return;
        }
        if (ic.iid == ic.bid) {
            return;
        }
        if (ic.bid < 0 || ic.iid < 0) {
            return;
        }
        if (ic.bid != 0 && ic.iid != 0) {
            return;
        }
        EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, x, y, z);
        if (e != null) {
            e.init();
            e.fill(ic);
            e.rotation_pitch = w.rand.nextInt(360);
            e.rotation_yaw = w.rand.nextInt(360);
            e.rotation_roll = w.rand.nextInt(360);
            e.motionx = dist * (Fastmath.nextFloat() - Fastmath.nextFloat());
            e.motiony = dist * Fastmath.nextFloat() / 4.0f;
            e.motionz = dist * (Fastmath.nextFloat() - Fastmath.nextFloat());
            w.spawnEntityInWorld(e);
        }
    }

    public static Texture initTexture(String tp) {
        Texture ltexture = null;
        if (DangerZone.alt_texture_paths.size() > 0) {
            int i = 0;
            while (i < DangerZone.alt_texture_paths.size()) {
                try {
                    ltexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream(String.valueOf(DangerZone.alt_texture_paths.get(i)) + tp));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ltexture != null) break;
                ++i;
            }
        }
        if (ltexture == null) {
            try {
                ltexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream(tp));
            }
            catch (Exception e) {
                System.out.printf("--- Failed to load texture %s\n", tp);
                e.printStackTrace();
            }
        }
        return ltexture;
    }

    public static List<Integer> find_nearby_pets(Player p) {
        List<Entity> all_list = DangerZone.server.entityManager.findALLEntitiesInRange(128.0f, p.dimension, p.posx, p.posy, p.posz);
        ArrayList<Integer> pet_list = new ArrayList<Integer>();
        if (all_list != null) {
            Iterator<Entity> ii = all_list.iterator();
            Entity e = null;
            while (ii.hasNext()) {
                e = ii.next();
                if (!(e instanceof EntityLiving) || e == p || e.getOwnerName() == null || !e.getOwnerName().equals(p.myname) || e.getStaying()) continue;
                pet_list.add(e.entityID);
            }
        }
        return pet_list;
    }

    public static void doTeleport(Player p, int d, double x, double y, double z) {
        if (p == null) {
            return;
        }
        if (!p.world.isServer) {
            return;
        }
        int which = p.world.rand.nextInt(3);
        if (which == 0) {
            p.world.playSound("DangerZone:teleport1", p.dimension, p.posx, p.posy, p.posz, 0.75f, 1.0f);
        }
        if (which == 1) {
            p.world.playSound("DangerZone:teleport2", p.dimension, p.posx, p.posy, p.posz, 0.75f, 1.0f);
        }
        if (which == 2) {
            p.world.playSound("DangerZone:teleport3", p.dimension, p.posx, p.posy, p.posz, 0.75f, 1.0f);
        }
        if (d > 0 && d < 256 && Dimensions.DimensionArray[d] != null) {
            DangerZone.dimension_change_in_progress = true;
            List<Integer> entity_list = Utils.find_nearby_pets(p);
            Entity riding = p.getRiddenEntity();
            if (riding != null) {
                entity_list.add(riding.entityID);
            }
            Dimensions.DimensionArray[d].teleportToDimension(p, DangerZone.server_world, d, (int)x, (int)y, (int)z);
            p.server_thread.sendTeleportToPlayer(d, p.posx, p.posy, p.posz);
            DangerZone.server.sendPlayerUpdateToAllExcept(p, p, true);
            if (entity_list != null) {
                for (int ient : entity_list) {
                    Entity eent = DangerZone.server.entityManager.findEntityByID(ient);
                    if (eent == null) continue;
                    Dimensions.DimensionArray[d].teleportToDimension(eent, DangerZone.server_world, d, (int)x, (int)y, (int)z);
                    DangerZone.server.sendEntityUpdateToAll(eent, true);
                }
            }
            if (riding != null) {
                riding.Mount(p);
            }
            DangerZone.dimension_change_in_progress = false;
        }
    }

    public static void SpawnDustAlongPath(EntityLiving me) {
        if (me == null) {
            return;
        }
        if (DangerZone.graphics_mode < 2) {
            return;
        }
        float scale = 0.25f * (me.getHeight() / 2.0f);
        float hmf = scale * 7.0f;
        int howmany = 1 + (int)hmf;
        int i = 0;
        while (i < howmany) {
            float where = Fastmath.nextFloat() * me.getHeight() * 0.25f;
            Utils.spawnParticlesFromServerScaled(me.world, "DangerZone:ParticleDust", 1, me.dimension, me.posx - (double)(me.motionx * where), me.posy + (double)(me.getHeight() / 3.0f) - (double)(me.motiony * where), me.posz - (double)(me.motionz * where), 0, scale);
            ++i;
        }
    }

    public static void SpawnBubblesAlongPath(EntityLiving me) {
        if (me == null) {
            return;
        }
        if (DangerZone.graphics_mode < 2) {
            return;
        }
        float scale = 0.25f * (me.getHeight() / 2.0f);
        float hmf = scale * 7.0f;
        int howmany = 1 + (int)hmf;
        if (Fastmath.nextInt(3) != 1) {
            return;
        }
        int i = 0;
        while (i < howmany) {
            float where = Fastmath.nextFloat() * 1.5f;
            Utils.spawnParticlesFromServerScaled(me.world, "DangerZone:ParticleBubble", 1, me.dimension, me.posx + (double)(me.motionx * where), me.posy + (double)(me.getHeight() / 2.0f) + (double)(me.motiony * where), me.posz + (double)(me.motionz * where), 0, scale);
            ++i;
        }
        i = Fastmath.nextInt(250);
        if (i == 1) {
            me.world.playSound("DangerZone:bubbles_big", me.dimension, me.posx, me.posy, me.posz, 0.25f, 1.0f);
        }
        if ((i = Fastmath.nextInt(50)) == 1) {
            me.world.playSound("DangerZone:bubbles_small", me.dimension, me.posx, me.posy, me.posz, 0.25f, 1.0f);
        }
    }

    public static void writeKVPList(BufferedOutputStream bos, List<KVPair> prop) {
        try {
            int todo = 0;
            while (todo < prop.size()) {
                KVPair kvp = prop.get(todo);
                String foo = kvp.key;
                int ilen = foo.length();
                int iwr = 0;
                while (iwr < ilen) {
                    if (foo.charAt(iwr) == ':') {
                        bos.write(92);
                    }
                    bos.write(foo.charAt(iwr));
                    ++iwr;
                }
                bos.write(61);
                foo = kvp.value;
                if (foo == null) {
                    foo = "null";
                }
                ilen = foo.length();
                iwr = 0;
                while (iwr < ilen) {
                    if (foo.charAt(iwr) == ':') {
                        bos.write(92);
                    }
                    bos.write(foo.charAt(iwr));
                    ++iwr;
                }
                bos.write(10);
                ++todo;
            }
            bos.flush();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }
}

