/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.rendering.Matrix4f;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.HmdMatrix44;
import org.lwjgl.openvr.HmdQuaternion;
import org.lwjgl.openvr.HmdVector3;

public class UglyMath {
    public Matrix4f convertSteamVRMatrix4ToMatrix4f(HmdMatrix44 hmdMatrix, Matrix4f mat) {
        mat.set(hmdMatrix.m(0), hmdMatrix.m(1), hmdMatrix.m(2), hmdMatrix.m(3), hmdMatrix.m(4), hmdMatrix.m(5), hmdMatrix.m(6), hmdMatrix.m(7), hmdMatrix.m(8), hmdMatrix.m(9), hmdMatrix.m(10), hmdMatrix.m(11), hmdMatrix.m(12), hmdMatrix.m(13), hmdMatrix.m(14), hmdMatrix.m(15));
        return mat;
    }

    public void GetPosition(HmdMatrix34 matrix, HmdVector3 vector) {
        vector.v().put(0, matrix.m(3));
        vector.v().put(1, matrix.m(7));
        vector.v().put(2, matrix.m(11));
    }

    public float fmax(float f1, float f2) {
        if (f1 > f2) {
            return f1;
        }
        return f2;
    }

    public void GetRotation(HmdMatrix34 matrix, HmdQuaternion q) {
        q.w(Math.sqrt(this.fmax(0.0f, 1.0f + matrix.m(0) + matrix.m(5) + matrix.m(10))) / 2.0);
        q.x(Math.sqrt(this.fmax(0.0f, 1.0f + matrix.m(0) - matrix.m(5) - matrix.m(10))) / 2.0);
        q.y(Math.sqrt(this.fmax(0.0f, 1.0f - matrix.m(0) + matrix.m(5) - matrix.m(10))) / 2.0);
        q.z(Math.sqrt(this.fmax(0.0f, 1.0f - matrix.m(0) - matrix.m(5) + matrix.m(10))) / 2.0);
        q.x(Math.copySign(q.x(), (double)(matrix.m(9) - matrix.m(6))));
        q.y(Math.copySign(q.y(), (double)(matrix.m(2) - matrix.m(8))));
        q.z(Math.copySign(q.z(), (double)(matrix.m(4) - matrix.m(1))));
    }

    public void Quaternion_to_Euler(HmdQuaternion q1, HmdVector3 vector) {
        double q2sqr = q1.y() * q1.y();
        double t0 = -2.0 * (q2sqr + q1.z() * q1.z()) + 1.0;
        double t1 = 2.0 * (q1.x() * q1.y() + q1.w() * q1.z());
        double t2 = -2.0 * (q1.x() * q1.z() - q1.w() * q1.y());
        double t3 = 2.0 * (q1.y() * q1.z() + q1.w() * q1.x());
        double t4 = -2.0 * (q1.x() * q1.x() + q2sqr) + 1.0;
        t2 = t2 > 1.0 ? 1.0 : t2;
        t2 = t2 < -1.0 ? -1.0 : t2;
        vector.v().put(1, (float)(-Math.asin(t2)));
        vector.v().put(0, (float)(-Math.atan2(t3, t4)));
        vector.v().put(2, (float)(-Math.atan2(t1, t0)));
    }

    public boolean closeEnough(float a, float b) {
        return 1.0E-4f > Math.abs(a - b);
    }

    public void rot34_to_euler(HmdMatrix34 matrix, HmdVector3 vector) {
        if (this.closeEnough(matrix.m(8), -1.0f)) {
            float x = 0.0f;
            float y = 1.5707964f;
            float z = (float)((double)x + Math.atan2(matrix.m(1), matrix.m(2)));
            vector.v().put(1, -x);
            vector.v().put(0, -y);
            vector.v().put(2, -z);
        } else if (this.closeEnough(matrix.m(8), 1.0f)) {
            float x = 0.0f;
            float y = -1.5707964f;
            float z = (float)((double)(-x) + Math.atan2(-matrix.m(1), -matrix.m(2)));
            vector.v().put(1, -x);
            vector.v().put(0, -y);
            vector.v().put(2, -z);
        } else {
            float x1 = (float)(-Math.asin(matrix.m(8)));
            float x2 = (float)(Math.PI - (double)x1);
            float y1 = (float)Math.atan2((double)matrix.m(9) / Math.cos(x1), (double)matrix.m(10) / Math.cos(x1));
            float y2 = (float)Math.atan2((double)matrix.m(9) / Math.cos(x2), (double)matrix.m(10) / Math.cos(x2));
            float z1 = (float)Math.atan2((double)matrix.m(4) / Math.cos(x1), (double)matrix.m(0) / Math.cos(x1));
            float z2 = (float)Math.atan2((double)matrix.m(4) / Math.cos(x2), (double)matrix.m(0) / Math.cos(x2));
            if (Math.abs(x1) + Math.abs(y1) + Math.abs(z1) <= Math.abs(x2) + Math.abs(y2) + Math.abs(z2)) {
                vector.v().put(1, -x1);
                vector.v().put(0, -y1);
                vector.v().put(2, -z1);
            } else {
                vector.v().put(1, -x2);
                vector.v().put(0, -y2);
                vector.v().put(2, -z2);
            }
        }
    }

    public void Quaternion_to_Vector(HmdQuaternion q1, HmdVector3 vector) {
        vector.v().put(0, -((float)(2.0 * (q1.x() * q1.z() + q1.w() * q1.y()))));
        vector.v().put(1, -((float)(2.0 * (q1.y() * q1.z() - q1.w() * q1.x()))));
        vector.v().put(2, -((float)(1.0 - 2.0 * (q1.x() * q1.x() + q1.y() * q1.y()))));
    }
}

