/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import org.lwjgl.openvr.HmdQuaternion;
import org.lwjgl.openvr.HmdVector3;

public class TargetInfo {
    public double rel_posx;
    public double rel_posy;
    public double rel_posz;
    public double real_posx;
    public double real_posy;
    public double real_posz;
    public float display_pitch;
    public float display_yaw;
    public float display_roll;
    public float pitch;
    public float yaw;
    public float dx;
    public float dy;
    public float dz;
    public float ev_pitch;
    public float ev_yaw;
    public float ev_roll;
    public HmdVector3 angular_velocity = HmdVector3.create();
    public HmdVector3 velocity = HmdVector3.create();
    public HmdVector3 vec_50;
    public HmdQuaternion quat = HmdQuaternion.create();
    public HmdQuaternion rotq_50 = this.ToQuaternion(0.0, 0.0, Math.toRadians(-45.0));
    public HmdQuaternion quat_50 = HmdQuaternion.create();
    public float pitch_50;
    public float yaw_50;
    public float dx_50;
    public float dy_50;
    public float dz_50;
    public boolean calc_50_done = false;

    public TargetInfo() {
        this.vec_50 = HmdVector3.create();
    }

    public HmdQuaternion ToQuaternion(double yaw, double pitch, double roll) {
        double cy = Math.cos(yaw * 0.5);
        double sy = Math.sin(yaw * 0.5);
        double cp = Math.cos(pitch * 0.5);
        double sp = Math.sin(pitch * 0.5);
        double cr = Math.cos(roll * 0.5);
        double sr = Math.sin(roll * 0.5);
        HmdQuaternion q = HmdQuaternion.create();
        q.w(cr * cp * cy + sr * sp * sy);
        q.x(sr * cp * cy - cr * sp * sy);
        q.y(cr * sp * cy + sr * cp * sy);
        q.z(cr * cp * sy - sr * sp * cy);
        return q;
    }

    public void mult(HmdQuaternion a, HmdQuaternion b, HmdQuaternion res) {
        double qw = b.w();
        double qx = b.x();
        double qy = b.y();
        double qz = b.z();
        double iw = a.w();
        double ix = a.x();
        double iy = a.y();
        double iz = a.z();
        res.x(ix * qw + iy * qz - iz * qy + iw * qx);
        res.y(-ix * qz + iy * qw + iz * qx + iw * qy);
        res.z(ix * qy - iy * qx + iz * qw + iw * qz);
        res.w(-ix * qx - iy * qy - iz * qz + iw * qw);
    }

    public void copy(HmdQuaternion from, HmdQuaternion to) {
        to.x(from.x());
        to.y(from.y());
        to.z(from.z());
        to.w(from.w());
    }

    public void calc_50() {
        if (this.calc_50_done) {
            return;
        }
        this.mult(this.quat, this.rotq_50, this.quat_50);
        DangerZone.um.Quaternion_to_Vector(this.quat_50, this.vec_50);
        this.dx_50 = this.vec_50.v().get(0);
        this.dy_50 = this.vec_50.v().get(1);
        this.dz_50 = this.vec_50.v().get(2);
        float tdir = (float)Math.atan2(this.vec_50.v().get(0), this.vec_50.v().get(2));
        float ddx = (float)Math.sqrt(this.vec_50.v().get(0) * this.vec_50.v().get(0) + this.vec_50.v().get(2) * this.vec_50.v().get(2));
        float ddz = (float)Math.atan2(-this.vec_50.v().get(1), ddx);
        this.pitch_50 = DangerZone.smooth_degrees(this.pitch_50, (float)Math.toDegrees(ddz), 0);
        while (this.pitch_50 < 0.0f) {
            this.pitch_50 += 360.0f;
        }
        this.pitch_50 %= 360.0f;
        this.yaw_50 = DangerZone.smooth_degrees(this.yaw_50, 180.0f - (float)Math.toDegrees(tdir), 0);
        while (this.yaw_50 < 0.0f) {
            this.yaw_50 += 360.0f;
        }
        this.yaw_50 %= 360.0f;
        this.calc_50_done = true;
    }
}

