/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.ItemAttribute;
import dangerzone.KVPair;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.items.Item;
import dangerzone.items.ItemArmor;
import dangerzone.items.Items;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import slick.Texture;

public class InventoryContainer {
    public int count;
    public int bid;
    public int iid;
    public int currentuses = 0;
    public List<ItemAttribute> attributes;
    public String icmeta = null;
    public InventoryContainer[] moreInventory;
    public int tmpi;

    public InventoryContainer() {
        this.iid = 0;
        this.bid = 0;
        this.count = 0;
        this.attributes = null;
        this.moreInventory = null;
    }

    public InventoryContainer(String uniquename, int incount) {
        this.bid = Blocks.findByName(uniquename);
        if (this.bid == 0) {
            this.iid = Items.findByName(uniquename);
        }
        this.count = 0;
        if (this.bid != 0 || this.iid != 0) {
            this.count = incount;
        }
        this.attributes = null;
        this.moreInventory = null;
    }

    public InventoryContainer(int inbid, int iniid, int incount, int incurrentuses) {
        this.bid = inbid;
        this.iid = iniid;
        this.count = incount;
        this.currentuses = incurrentuses;
        this.attributes = null;
        this.moreInventory = null;
    }

    public InventoryContainer(Object inobj, int incount, int incurrentuses) {
        this.bid = 0;
        this.iid = 0;
        if (inobj instanceof Item) {
            this.iid = ((Item)inobj).itemID;
        }
        if (inobj instanceof Block) {
            this.bid = ((Block)inobj).blockID;
        }
        this.count = incount;
        this.currentuses = incurrentuses;
        this.attributes = null;
        this.moreInventory = null;
    }

    public InventoryContainer(int inbid, int iniid, int incount, int incurrentuses, List<ItemAttribute> inlist) {
        this.bid = inbid;
        this.iid = iniid;
        this.count = incount;
        this.currentuses = incurrentuses;
        if (inlist != null) {
            this.attributes = new ArrayList<ItemAttribute>();
            ListIterator<ItemAttribute> li = inlist.listIterator();
            while (li.hasNext()) {
                ItemAttribute ia = li.next();
                ItemAttribute ib = new ItemAttribute(ia.type, ia.value);
                this.attributes.add(ib);
            }
        } else {
            this.attributes = null;
        }
        this.moreInventory = null;
    }

    public InventoryContainer(int inbid, int iniid, int incount, int incurrentuses, List<ItemAttribute> inlist, String inicmeta) {
        this.bid = inbid;
        this.iid = iniid;
        this.count = incount;
        this.currentuses = incurrentuses;
        if (inlist != null) {
            this.attributes = new ArrayList<ItemAttribute>();
            ListIterator<ItemAttribute> li = inlist.listIterator();
            while (li.hasNext()) {
                ItemAttribute ia = li.next();
                ItemAttribute ib = new ItemAttribute(ia.type, ia.value);
                this.attributes.add(ib);
            }
        } else {
            this.attributes = null;
        }
        this.icmeta = inicmeta;
        this.moreInventory = null;
    }

    public InventoryContainer(int inbid, int iniid, int incount, int incurrentuses, List<ItemAttribute> inlist, String inicmeta, InventoryContainer[] inic) {
        this.bid = inbid;
        this.iid = iniid;
        this.count = incount;
        this.currentuses = incurrentuses;
        if (inlist != null) {
            this.attributes = new ArrayList<ItemAttribute>();
            ListIterator<ItemAttribute> li = inlist.listIterator();
            while (li.hasNext()) {
                ItemAttribute ia = li.next();
                ItemAttribute ib = new ItemAttribute(ia.type, ia.value);
                this.attributes.add(ib);
            }
        } else {
            this.attributes = null;
        }
        this.icmeta = inicmeta;
        this.moreInventory = inic;
    }

    public InventoryContainer(Object inobj, int incount, int incurrentuses, List<ItemAttribute> inlist) {
        this.bid = 0;
        this.iid = 0;
        if (inobj instanceof Item) {
            this.iid = ((Item)inobj).itemID;
        }
        if (inobj instanceof Block) {
            this.bid = ((Block)inobj).blockID;
        }
        this.count = incount;
        this.currentuses = incurrentuses;
        if (inlist != null) {
            this.attributes = new ArrayList<ItemAttribute>();
            ListIterator<ItemAttribute> li = inlist.listIterator();
            while (li.hasNext()) {
                ItemAttribute ia = li.next();
                ItemAttribute ib = new ItemAttribute(ia.type, ia.value);
                this.attributes.add(ib);
            }
        } else {
            this.attributes = null;
        }
        this.moreInventory = null;
    }

    public InventoryContainer(Object inobj, int incount, int incurrentuses, List<ItemAttribute> inlist, String inicmeta) {
        this.bid = 0;
        this.iid = 0;
        if (inobj instanceof Item) {
            this.iid = ((Item)inobj).itemID;
        }
        if (inobj instanceof Block) {
            this.bid = ((Block)inobj).blockID;
        }
        this.count = incount;
        this.currentuses = incurrentuses;
        if (inlist != null) {
            this.attributes = new ArrayList<ItemAttribute>();
            ListIterator<ItemAttribute> li = inlist.listIterator();
            while (li.hasNext()) {
                ItemAttribute ia = li.next();
                ItemAttribute ib = new ItemAttribute(ia.type, ia.value);
                this.attributes.add(ib);
            }
        } else {
            this.attributes = null;
        }
        this.icmeta = inicmeta;
        this.moreInventory = null;
    }

    public InventoryContainer(Object inobj, int incount, int incurrentuses, List<ItemAttribute> inlist, String inicmeta, InventoryContainer[] yetmore) {
        this.bid = 0;
        this.iid = 0;
        if (inobj instanceof Item) {
            this.iid = ((Item)inobj).itemID;
        }
        if (inobj instanceof Block) {
            this.bid = ((Block)inobj).blockID;
        }
        this.count = incount;
        this.currentuses = incurrentuses;
        if (inlist != null) {
            this.attributes = new ArrayList<ItemAttribute>();
            ListIterator<ItemAttribute> li = inlist.listIterator();
            while (li.hasNext()) {
                ItemAttribute ia = li.next();
                ItemAttribute ib = new ItemAttribute(ia.type, ia.value);
                this.attributes.add(ib);
            }
        } else {
            this.attributes = null;
        }
        this.icmeta = inicmeta;
        this.moreInventory = yetmore;
    }

    public void writeSelf(List<KVPair> prop, String tag) {
        this.writeSelfRecursive(this, prop, tag, 0);
    }

    public void writeSelfRecursive(InventoryContainer ic, List<KVPair> prop, String tag, int reclevel) {
        int i;
        if (reclevel > 5) {
            return;
        }
        prop.add(new KVPair(String.format("%s%s", tag, "BID"), String.format("%d", ic.bid)));
        prop.add(new KVPair(String.format("%s%s", tag, "IID"), String.format("%d", ic.iid)));
        prop.add(new KVPair(String.format("%s%s", tag, "count"), String.format("%d", ic.count)));
        prop.add(new KVPair(String.format("%s%s", tag, "currentuses"), String.format("%d", ic.currentuses)));
        prop.add(new KVPair(String.format("%s%s", tag, "icmeta"), ic.icmeta == null ? "null" : ic.icmeta));
        int listsize = 0;
        if (ic.attributes != null) {
            listsize = ic.attributes.size();
        }
        prop.add(new KVPair(String.format("%s%s", tag, "attrlistlen"), String.format("%d", listsize)));
        if (listsize > 0) {
            i = 0;
            while (i < listsize) {
                ItemAttribute ia = ic.attributes.get(i);
                prop.add(new KVPair(String.format("%s%s_%d", tag, "attrtype", i), String.format("%d", ia.type)));
                prop.add(new KVPair(String.format("%s%s_%d", tag, "attrval", i), String.format("%d", ia.value)));
                ++i;
            }
        }
        int moresize = 0;
        if (ic.moreInventory != null) {
            moresize = ic.moreInventory.length;
        }
        if (moresize < 0 || moresize > 200) {
            moresize = 0;
        }
        prop.add(new KVPair(String.format("%s%s", tag, "moresize"), String.format("%d", moresize)));
        if (moresize > 0) {
            i = 0;
            while (i < moresize) {
                String tt = String.format("%s%d_%d:", tag, reclevel + 1, i);
                if (ic.moreInventory[i] != null) {
                    prop.add(new KVPair(String.format("%s%s_%d", tt, "exists", i), String.format("%d", i)));
                    this.writeSelfRecursive(ic.moreInventory[i], prop, tt, reclevel + 1);
                } else {
                    prop.add(new KVPair(String.format("%s%s_%d", tt, "exists", i), String.format("%d", -1)));
                }
                ++i;
            }
        }
    }

    public void readSelf(Properties prop, String tag) {
        this.readSelfRecursive(this, prop, tag, 0);
    }

    public void readSelfRecursive(InventoryContainer ic, Properties prop, String tag, int reclevel) {
        int moresize;
        int listsize;
        if (reclevel > 5) {
            return;
        }
        ic.bid = Utils.getPropertyInt(prop, String.format("%s%s", tag, "BID"), 0, 2047, 0);
        ic.iid = Utils.getPropertyInt(prop, String.format("%s%s", tag, "IID"), 0, 2047, 0);
        ic.count = Utils.getPropertyInt(prop, String.format("%s%s", tag, "count"), 0, 128, 1);
        ic.currentuses = Utils.getPropertyInt(prop, String.format("%s%s", tag, "currentuses"), 0, Integer.MAX_VALUE, 0);
        ic.icmeta = Utils.getPropertyString(prop, String.format("%s%s", tag, "icmeta"), null);
        if (ic.icmeta != null && ic.icmeta.equals("null")) {
            ic.icmeta = null;
        }
        if ((listsize = Utils.getPropertyInt(prop, String.format("%s%s", tag, "attrlistlen"), 0, 100, 0)) > 0) {
            ic.attributes = new ArrayList<ItemAttribute>();
            int i = 0;
            while (i < listsize) {
                ItemAttribute ia = new ItemAttribute();
                ia.type = Utils.getPropertyInt(prop, String.format("%s%s_%d", tag, "attrtype", i), 0, 100, 0);
                ia.value = Utils.getPropertyInt(prop, String.format("%s%s_%d", tag, "attrval", i), Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
                ic.attributes.add(ia);
                ++i;
            }
        }
        if ((moresize = Utils.getPropertyInt(prop, String.format("%s%s", tag, "moresize"), 0, 200, 0)) > 0) {
            ic.moreInventory = new InventoryContainer[moresize];
            int exists = -1;
            int i = 0;
            while (i < moresize) {
                String tt = String.format("%s%d_%d:", tag, reclevel + 1, i);
                exists = Utils.getPropertyInt(prop, String.format("%s%s_%d", tt, "exists", i), -1, 200, -1);
                if (exists >= 0) {
                    ic.moreInventory[i] = new InventoryContainer();
                    this.readSelfRecursive(ic.moreInventory[i], prop, tt, reclevel + 1);
                }
                ++i;
            }
        }
    }

    public InventoryContainer validate() {
        return this.validateRecursive(this);
    }

    public InventoryContainer validateRecursive(InventoryContainer ic) {
        if (ic == null) {
            return null;
        }
        if (ic.iid == 0 && ic.bid == 0) {
            return null;
        }
        if (ic.iid != 0 && ic.bid != 0) {
            return null;
        }
        if (ic.iid < 0 || ic.bid < 0) {
            return null;
        }
        if (ic.iid != 0 && Items.ItemArray[ic.iid] == null) {
            return null;
        }
        if (ic.bid != 0 && Blocks.BlockArray[ic.bid] == null) {
            return null;
        }
        if (ic.count == 0) {
            return null;
        }
        if (ic.moreInventory != null) {
            int i = 0;
            while (i < ic.moreInventory.length) {
                ic.moreInventory[i] = this.validateRecursive(ic.moreInventory[i]);
                ++i;
            }
        }
        return ic;
    }

    public List<ItemAttribute> getAttributes() {
        if (this.bid != 0) {
            return null;
        }
        return this.attributes;
    }

    public int getAttribute(int type) {
        if (this.count <= 0) {
            return 0;
        }
        if (this.attributes == null) {
            return 0;
        }
        if (this.iid == 0) {
            return 0;
        }
        if (this.getMaxStack() != 1) {
            return 0;
        }
        ListIterator<ItemAttribute> li = this.attributes.listIterator();
        while (li.hasNext()) {
            ItemAttribute ia = li.next();
            if (ia.type != type) continue;
            return ia.value;
        }
        return 0;
    }

    public void setAttribute(int type, int value) {
        ItemAttribute ia;
        if (this.bid != 0) {
            return;
        }
        if (this.count != 1) {
            return;
        }
        if (this.getMaxStack() != 1) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList<ItemAttribute>();
        }
        ListIterator<ItemAttribute> li = this.attributes.listIterator();
        while (li.hasNext()) {
            ia = li.next();
            if (ia.type != type) continue;
            ia.value = value;
            return;
        }
        ia = new ItemAttribute(type, value);
        this.attributes.add(ia);
    }

    public void addAttribute(int type, int value) {
        ItemAttribute ia;
        if (this.bid != 0) {
            return;
        }
        if (this.count != 1) {
            return;
        }
        if (this.getMaxStack() != 1) {
            return;
        }
        int newval = value;
        if (newval > 10) {
            newval = 10;
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList<ItemAttribute>();
        }
        ListIterator<ItemAttribute> li = this.attributes.listIterator();
        while (li.hasNext()) {
            ia = li.next();
            if (ia.type != type) continue;
            ia.value += newval;
            if (ia.value > 10) {
                ia.value = 10;
            }
            return;
        }
        ia = new ItemAttribute(type, newval);
        this.attributes.add(ia);
    }

    public Texture getTexture() {
        if (this.count <= 0) {
            return null;
        }
        if (this.bid != 0) {
            if (Blocks.showTop(this.bid)) {
                return Blocks.getTextureForSide(this.bid, 0);
            }
            return Blocks.getTexture(this.bid);
        }
        if (this.iid != 0) {
            return Items.getTexture(this.iid);
        }
        return null;
    }

    public String getUniqueName() {
        if (this.count <= 0) {
            return null;
        }
        if (this.bid != 0) {
            return Blocks.getUniqueName(this.bid);
        }
        if (this.iid != 0) {
            return Items.getUniqueName(this.iid);
        }
        return null;
    }

    public int getMaxStack() {
        if (this.bid != 0) {
            return Blocks.getMaxStack(this.bid);
        }
        if (this.iid != 0) {
            return Items.getMaxStack(this.iid);
        }
        return 1;
    }

    public Item getItem() {
        if (this.bid != 0) {
            return null;
        }
        return Items.getItem(this.iid);
    }

    public Block getBlock() {
        if (this.iid != 0) {
            return null;
        }
        return Blocks.getBlock(this.bid);
    }

    public void inventoryTick(Entity e, int invindex) {
        Block bl;
        Item it;
        if (this.iid != 0 && (it = this.getItem()) != null) {
            it.inventoryTick(e, this, invindex);
        }
        if (this.bid != 0 && (bl = this.getBlock()) != null) {
            bl.inventoryTick(e, this, invindex);
        }
    }

    public void inUseTick(Entity e, int invindex) {
        Block bl;
        Item it;
        if (this.iid != 0 && (it = this.getItem()) != null) {
            it.inUseTick(e, this, invindex);
        }
        if (this.bid != 0 && (bl = this.getBlock()) != null) {
            bl.inUseTick(e, this, invindex);
        }
    }

    public void armorTick(Entity e, int armorindex) {
        Item it;
        if (this.iid != 0 && (it = this.getItem()) != null && it instanceof ItemArmor) {
            ItemArmor ia = (ItemArmor)it;
            ia.armorTick(e, this, armorindex);
        }
    }

    public void onCrafted(Player pl) {
        Block bl;
        Item it;
        if (this.iid != 0 && (it = this.getItem()) != null) {
            it.onCrafted(pl, this);
        }
        if (this.bid != 0 && (bl = this.getBlock()) != null) {
            bl.onCrafted(pl, this);
        }
    }
}

