/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.items;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityFire;
import dangerzone.entities.EntityLiving;
import dangerzone.items.ItemAxe;

public class ItemSunstoneAxe
extends ItemAxe {
    public ItemSunstoneAxe(String n, String txt, int uses, int attack, int strength, float light) {
        super(n, txt, uses, attack, strength);
        this.brightness = light;
    }

    @Override
    public boolean onLeftClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (holder != null && clickedon != null && holder.world.isServer && clickedon instanceof EntityLiving) {
            clickedon.doSetOnFire(100);
            clickedon.doAttackFrom(holder, 10, 25.0f);
        }
        return true;
    }

    @Override
    public boolean onRightClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (holder != null && clickedon != null && holder.world.isServer && clickedon instanceof EntityLiving) {
            clickedon.setOnFire(100);
            clickedon.doAttackFrom(holder, 10, 25.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int side) {
        if (p != null && p.world.isServer) {
            EntityFire eb = (EntityFire)p.world.createEntityByName("DangerZone:Fire", dimension, (double)x + 0.5, (double)y - 0.0625, (double)z + 0.5);
            if (eb != null) {
                eb.init();
                p.world.spawnEntityInWorld(eb);
            }
            return true;
        }
        return false;
    }
}

