/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.items;

import OreSpawn.items.ModelChainsaw;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.items.ItemSword;
import dangerzone.particles.Particle;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.TextureMapper;
import dangerzone.rendering.WorldRenderer;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class Chainsaw
extends ItemSword {
    Texture texturebig = null;
    ModelChainsaw ma = null;

    public Chainsaw(String n, String txt, int a, int b) {
        super(n, txt, a, b);
        this.burntime = 70;
        this.flipped = true;
        this.itemreach = 5.0f;
        this.itemwidth = 0.75f;
        this.xoff = 1.5f;
        this.yoff = -3.4999998f;
        this.zoff = -13.400001f;
        this.pitch_off = -12.599999f;
        this.yaw_off = 258.8f;
        this.roll_off = 259.1f;
    }

    @Override
    public void onCrafted(Player p, InventoryContainer ic) {
        ic.addAttribute(1, 5);
        ic.addAttribute(4, 3);
        ic.addAttribute(5, 2);
    }

    @Override
    public void renderMeHeld(WorldRenderer wr, Entity e, InventoryContainer ic, boolean isdisplay) {
        if (this.texturebig == null) {
            this.texturebig = TextureMapper.getTexture("orespawnres/items/Chainsawtexture.png");
        }
        DangerZone.wr.loadtexture(this.texturebig);
        if (this.ma == null) {
            this.ma = new ModelChainsaw();
        }
        MatrixStack.pushMatrix();
        if (isdisplay) {
            MatrixStack.translate(0.4f, -18.0f, -8.0f);
            MatrixStack.rotate(12.0f, 1.0f, 0.0f, 0.0f);
            MatrixStack.rotate(283.1f, 0.0f, 1.0f, 0.0f);
            MatrixStack.rotate(124.0f, 0.0f, 0.0f, 1.0f);
        } else {
            MatrixStack.translate(-2.1999998f, -18.9f, 0.1f);
            MatrixStack.rotate(12.0f, 1.0f, 0.0f, 0.0f);
            MatrixStack.rotate(283.1f, 0.0f, 1.0f, 0.0f);
            MatrixStack.rotate(78.7f, 0.0f, 0.0f, 1.0f);
        }
        MatrixStack.sendCurrentStack();
        if (this.ma != null) {
            this.ma.render();
        }
        MatrixStack.popMatrix();
    }

    @Override
    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int side) {
        this.doCutWood(p, p.world, dimension, x, y, z);
        return true;
    }

    @Override
    public void leftClickOnBlock(Player p, int dimension, int x, int y, int z, int side) {
        this.doCutWood(p, p.world, dimension, x, y, z);
    }

    @Override
    public boolean onLeftClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (holder != null) {
            if (holder.world.isServer) {
                holder.world.playSound("OreSpawn:chainsawshort", holder.dimension, holder.posx, holder.posy, holder.posz, 1.0f, 1.0f);
                if (clickedon != null) {
                    List<Entity> nearby_list = null;
                    nearby_list = DangerZone.server.entityManager.findEntitiesInRange(5.0f, clickedon.dimension, clickedon.posx, clickedon.posy, clickedon.posz);
                    if (nearby_list != null && !nearby_list.isEmpty()) {
                        Entity e = null;
                        ListIterator<Entity> li = nearby_list.listIterator();
                        while (li.hasNext()) {
                            e = li.next();
                            if (!(e instanceof EntityLiving) || e == holder || e.deadflag) continue;
                            e.doAttackFrom(holder, 1, this.attackstrength);
                        }
                    }
                }
            }
            if (ic.attributes == null && holder.world.isServer) {
                ic.addAttribute(1, 5);
                ic.addAttribute(4, 3);
                ic.addAttribute(5, 2);
                holder.setVarInventoryChanged(ic);
            }
        }
        return true;
    }

    @Override
    public boolean onRightClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (holder != null) {
            if (holder.world.isServer) {
                holder.world.playSound("OreSpawn:chainsawshort", holder.dimension, holder.posx, holder.posy, holder.posz, 1.0f, 1.0f);
            } else {
                DangerZone.long_rumble(150, 6, 900);
            }
            if (ic.attributes == null && holder.world.isServer) {
                ic.addAttribute(1, 5);
                ic.addAttribute(4, 3);
                ic.addAttribute(5, 2);
                holder.setVarInventoryChanged(ic);
            }
        }
        return false;
    }

    @Override
    public void inUseTick(Entity holder, InventoryContainer ic, int invindex) {
        if (holder instanceof Player) {
            Item it;
            InventoryContainer ih;
            Player p = (Player)holder;
            if (!p.world.isServer && (ih = p.getHotbar(p.gethotbarindex())) != null && (it = ih.getItem()) != null && it.itemID == this.itemID) {
                int which = p.world.rand.nextInt(3);
                Particle eb = null;
                float useyaw = p.rotation_yaw - 30.0f;
                if (!DangerZone.isVR) {
                    float dx = (float)(0.75 * Math.cos(Math.toRadians(useyaw)));
                    float dz = (float)(0.75 * Math.sin(Math.toRadians(useyaw)));
                    if (p != DangerZone.player) {
                        useyaw += 20.0f;
                        useyaw = 360.0f - (useyaw + 180.0f) % 360.0f;
                        dx = (float)(0.75 * Math.cos(Math.toRadians(useyaw)));
                        dz = (float)(0.75 * Math.sin(Math.toRadians(useyaw)));
                    }
                    dx += (p.world.rand.nextFloat() - p.world.rand.nextFloat()) * 0.25f;
                    dz += (p.world.rand.nextFloat() - p.world.rand.nextFloat()) * 0.25f;
                    if (which == 0) {
                        eb = p.world.createParticleByName("DangerZone:ParticleSparkle", p.dimension, p.posx + (double)dx, p.posy + 1.0, p.posz + (double)dz);
                    }
                    if (which == 1) {
                        eb = p.world.createParticleByName("DangerZone:ParticleSmoke", p.dimension, p.posx + (double)dx, p.posy + 1.0, p.posz + (double)dz);
                    }
                    if (which == 2) {
                        eb = p.world.createParticleByName("DangerZone:ParticleFire", p.dimension, p.posx + (double)dx, p.posy + 1.0, p.posz + (double)dz);
                    }
                    if (eb != null) {
                        eb.motiony += 0.0f;
                        dx = (float)Math.cos(Math.toRadians(useyaw));
                        dz = (float)Math.sin(Math.toRadians(useyaw));
                        eb.motionx += dx * 0.08f;
                        eb.motionz += dz * 0.08f;
                        eb.maxlifetime = 5 + p.world.rand.nextInt(5);
                        p.world.spawnParticleInWorld(eb);
                    }
                }
            }
        }
    }

    private void doCutWood(Entity e, World w, int d, int x, int y, int z) {
        if (!w.isServer) {
            return;
        }
        int bid = w.getblock(d, x, y, z);
        if (!Blocks.isLeaves(bid) && !Blocks.isWood(bid)) {
            return;
        }
        int i = -5;
        while (i <= 5) {
            int j = -5;
            while (j <= 10) {
                int k = -5;
                while (k <= 5) {
                    bid = w.getblock(d, x + i, y + j, z + k);
                    if (Blocks.isLeaves(bid) || Blocks.isWood(bid)) {
                        w.setblockWithPerm(e, d, x + i, y + j, z + k, 0);
                        Utils.doDropRand(w, bid, 0, 3.0f, d, x + i, y + j, z + k);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void vr_hit_something(Entity e, int bid) {
        if (bid != 0) {
            DangerZone.hit_pulse(2500);
            return;
        }
        if (e != null) {
            DangerZone.hit_pulse(1500);
        }
    }
}

