/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.DoomWorm;
import OreSpawn.entities.WormLarge;
import OreSpawn.entities.WormMedium;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class WormSmall
extends EntityLiving {
    public int upcount = 10;
    public int downcount = 0;
    public boolean oktoattack = false;

    public WormSmall(World w) {
        super(w);
        this.maxrenderdist = 100;
        this.height = 1.1f;
        this.width = 0.25f;
        this.uniquename = "OreSpawn:WormSmall";
        this.moveSpeed = 0.01f;
        this.setMaxHealth(4.0f);
        this.setHealth(4.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(1.0f);
        this.searchDistance = 7.0f;
        this.attackRange = 3.0f;
        this.movefrequency = 99999;
        this.setExperience(2);
        this.canSwim = false;
        this.takesFallDamage = false;
        this.ignoreCollisions = true;
        this.setCanDespawn(false);
        this.lifetimeticker = DangerZone.rand.nextInt(10000);
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = false;
    }

    @Override
    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        if (this.getAttacking() && this.timeForMe()) {
            this.takesFallDamage = true;
            this.ignoreCollisions = false;
            this.oktoattack = true;
        } else {
            this.oktoattack = false;
            this.takesFallDamage = false;
            this.ignoreCollisions = true;
            int bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + 1.75), (int)this.posz);
            this.motiony = bid == Blocks.stone.blockID || bid == Blocks.sand.blockID || bid == Blocks.dirt.blockID || bid == Blocks.grassblock.blockID ? 0.05f : (bid != 0 ? -0.05f : -0.25f);
            this.target = null;
            this.motionz = 0.0f;
            this.motionx = 0.0f;
            this.rotation_yaw_motion = 0.0f;
        }
    }

    private boolean timeForMe() {
        if (this.upcount > 0) {
            --this.upcount;
            if (this.upcount == 0) {
                this.downcount = 50 + this.world.rand.nextInt(75);
            }
        } else {
            if (this.downcount > 0) {
                --this.downcount;
                return false;
            }
            this.upcount = 12 + this.world.rand.nextInt(25);
        }
        return true;
    }

    @Override
    public void doAttack(Entity victim) {
        if (!this.oktoattack) {
            return;
        }
        if (this.world.rand.nextBoolean() && victim.has_inventory && victim instanceof Player) {
            Player p = (Player)victim;
            InventoryContainer ic = null;
            ic = p.getArmor(3);
            if (ic != null) {
                p.setArmor(3, null);
                this.spititout(ic);
            }
        }
        super.doAttack(victim);
    }

    private void spititout(InventoryContainer ic) {
        EntityBlockItem e = (EntityBlockItem)this.world.createEntityByName(DangerZone.blockitemname, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 2.0f), this.posy + 1.0, this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 2.0f));
        if (e != null) {
            e.fill(ic);
            e.rotation_pitch = this.world.rand.nextInt(360);
            e.rotation_yaw = this.world.rand.nextInt(360);
            e.rotation_roll = this.world.rand.nextInt(360);
            this.world.spawnEntityInWorld(e);
        }
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophywormsmall.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof DoomWorm) {
            return false;
        }
        if (e instanceof WormLarge) {
            return false;
        }
        if (e instanceof WormMedium) {
            return false;
        }
        if (e instanceof WormSmall) {
            return false;
        }
        return e instanceof Player;
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/WormSmalltexture.png");
        }
        return this.texture;
    }
}

