/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Weasel
extends EntityLiving {
    public Texture texture2 = null;
    public Texture texture3 = null;

    public Weasel(World w) {
        super(w);
        this.maxrenderdist = 130;
        this.height = 1.9f;
        this.width = 0.8f;
        this.uniquename = "OreSpawn:Weasel";
        this.moveSpeed = 0.32f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 30;
        this.setExperience(5);
        this.canSwim = true;
        this.enable_avoid = true;
        this.avoiddistance = 25;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 8;
        if (w != null && w.isServer) {
            this.setBID(-1);
            this.setBID(DangerZone.rand.nextInt(3));
        }
    }

    @Override
    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.isBaby();
        super.doEntityAction(deltaT);
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof Weasel;
    }

    @Override
    public boolean isFoodItem(int iid) {
        return iid == Items.apple.itemID;
    }

    @Override
    public boolean isBreedingFoodForMe(int bid, int iid) {
        return iid == Items.peach.itemID;
    }

    @Override
    public boolean shouldAvoidEntity(Entity e) {
        return e instanceof Player;
    }

    @Override
    public String getLivingSound() {
        return "DangerZone:ratlive";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, 0, Items.ostrichmeat.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.furball.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyweasel.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        int which;
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/WeaseltextureWeasel.png");
            this.texture2 = TextureMapper.getTexture("orespawnres/skins/WeaseltextureFerret.png");
            this.texture3 = TextureMapper.getTexture("orespawnres/skins/WeaseltextureOtter.png");
        }
        if ((which = this.getBID()) == 1) {
            return this.texture2;
        }
        if (which == 2) {
            return this.texture3;
        }
        return this.texture;
    }
}

