/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Bee;
import OreSpawn.entities.Brutalfly;
import OreSpawn.entities.CloudShark;
import OreSpawn.entities.DungeonBeast;
import OreSpawn.entities.EmperorScorpion;
import OreSpawn.entities.Fairy;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.Irukandji;
import OreSpawn.entities.LurkingTerror;
import OreSpawn.entities.Mantis;
import OreSpawn.entities.Mothra;
import OreSpawn.entities.Rotator;
import OreSpawn.entities.Skate;
import OreSpawn.entities.TerribleTerror;
import OreSpawn.entities.Urchin;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.particles.Particle;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Vortex
extends EntityLiving {
    float myspeed = 0.0f;

    public Vortex(World w) {
        super(w);
        this.maxrenderdist = 170;
        this.uniquename = "OreSpawn:Vortex";
        if (w != null) {
            this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = false;
        this.setExperience(220);
        this.height = 2.75f;
        this.width = 3.75f;
        this.setMaxHealth(200.0f);
        this.setHealth(200.0f);
        this.setDefense(2.5f);
        this.setAttackDamage(20.0f);
        this.searchDistance = 40.0f;
        this.attackRange = 6.0f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.canFly = true;
        this.setFlying(true);
        this.tower_defense_enable = true;
    }

    @Override
    public void doEntityAction(float deltaT) {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(10) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom(this, dt, dmg);
            if (this.getDistanceFromEntity(this.targetentity) < 6.0) {
                this.targetentity.addKnockback(this, -2.0f, (float)(6.0 - this.getDistanceFromEntity(this.targetentity)) * 3.0f);
            }
        }
        if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            int bid;
            int keep_trying = 35;
            if (this.target == null) {
                this.target = new TargetHelper(this.posx, this.posy, this.posz);
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 3.0) {
                bid = 1;
                while (bid != 0 && keep_trying != 0) {
                    this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(35) - this.world.rand.nextInt(35)), this.posy + (double)(this.world.rand.nextInt(7) - 2), this.posz + (double)(this.world.rand.nextInt(35) - this.world.rand.nextInt(35)));
                    bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                    --keep_trying;
                }
                this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
                this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
            }
            double dy = this.target.targety - this.posy;
            this.motiony += 0.12f * deltaT;
            if ((dy /= 20.0) > (double)0.15f) {
                dy = 0.15f;
            }
            if (dy < (double)-0.2f) {
                dy = -0.2f;
            }
            this.motiony = (float)((double)this.motiony + dy);
            if (this.motiony > 1.0f) {
                this.motiony = 1.0f;
            }
            if (this.motiony < -1.0f) {
                this.motiony = -1.0f;
            }
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            float speedadjust = 1.0f;
            float effectspeed = this.getTotalEffect(1);
            if (effectspeed > 1.0f) {
                speedadjust *= effectspeed;
            }
            if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
                speedadjust /= effectspeed;
            }
            this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
            this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        } else {
            int i = 0;
            while (i < 20) {
                float d = this.world.rand.nextFloat() * 3.5f;
                d *= d;
                float dir = (float)((double)(this.world.rand.nextFloat() * 2.0f) * Math.PI);
                dir = (float)((double)dir - Math.PI);
                float dx = (float)(Math.cos(dir) * (double)d / 2.0);
                float dz = (float)(Math.sin(dir) * (double)d / 2.0);
                dir = (float)((double)dir + 1.5707963267948966);
                Particle eb = null;
                eb = this.world.createParticleByName("DangerZone:ParticleSmoke", this.dimension, this.posx + (double)dx, this.posy + 0.75 + (double)d, this.posz + (double)dz);
                if (eb != null) {
                    eb.motiony = 0.0f;
                    dx = (float)Math.sin(Math.toRadians(this.rotation_yaw + 180.0f));
                    dz = (float)Math.cos(Math.toRadians(this.rotation_yaw + 180.0f));
                    eb.motionx = (float)(Math.cos(dir) * (double)this.world.rand.nextFloat() / 4.0);
                    eb.motiony = this.world.rand.nextFloat() / 2.0f;
                    eb.motionz = (float)(Math.sin(dir) * (double)this.world.rand.nextFloat() / 4.0);
                    eb.maxlifetime = 15 + this.world.rand.nextInt(15);
                    this.world.spawnParticleInWorld(eb);
                }
                ++i;
            }
        }
        super.update(deltaT);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Urchin) {
            return false;
        }
        if (e instanceof TerribleTerror && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof EmperorScorpion && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof CloudShark && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof LurkingTerror && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Rotator) {
            return false;
        }
        if (e instanceof Bee && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Mantis && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Mothra && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Brutalfly && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Vortex) {
            return false;
        }
        if (e instanceof DungeonBeast) {
            return false;
        }
        if (e instanceof Skate) {
            return false;
        }
        if (e instanceof Irukandji) {
            return false;
        }
        if (e instanceof Fairy && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Girlfriend && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(4);
        howmany = 10 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.feather.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.tigerseye.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, OreSpawnMain.blocktigerseye.blockID, 0, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.tigerseyeboots.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.tigerseyeleggings.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.tigerseyechestplate.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.tigerseyehelmet.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.tigerseye_axe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.tigerseye_pickaxe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.tigerseye_shovel.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.tigerseye_sword.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.tigerseye_hoe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, OreSpawnMain.vortexeye.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyvortex.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Vortextexture.png");
        }
        return this.texture;
    }

    @Override
    public String getHurtSound() {
        return null;
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:vortexlive";
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(2) != 1) {
            return null;
        }
        return "OreSpawn:vortexlive";
    }

    @Override
    public boolean CanProbablySeeEntity(Entity e) {
        int nblks = (int)this.getDistanceFromEntity(e);
        if (nblks < 1) {
            return true;
        }
        double cx = this.posx;
        double cz = this.posz;
        double startx = cx;
        double starty = this.posy + 2.0;
        double startz = cz;
        double dx = (e.posx - startx) / (double)nblks;
        double dy = (e.posy + (double)(e.getHeight() * 7.0f / 8.0f) - starty) / (double)nblks;
        double dz = (e.posz - startz) / (double)nblks;
        if (Math.abs(dx) > 1.0) {
            dy /= Math.abs(dx);
            dz /= Math.abs(dx);
            nblks = (int)((double)nblks * Math.abs(dx));
            if (dx > 1.0) {
                dx = 1.0;
            }
            if (dx < -1.0) {
                dx = -1.0;
            }
        }
        if (Math.abs(dy) > 1.0) {
            dx /= Math.abs(dy);
            dz /= Math.abs(dy);
            nblks = (int)((double)nblks * Math.abs(dy));
            if (dy > 1.0) {
                dy = 1.0;
            }
            if (dy < -1.0) {
                dy = -1.0;
            }
        }
        if (Math.abs(dz) > 1.0) {
            dy /= Math.abs(dz);
            dx /= Math.abs(dz);
            nblks = (int)((double)nblks * Math.abs(dz));
            if (dz > 1.0) {
                dz = 1.0;
            }
            if (dz < -1.0) {
                dz = -1.0;
            }
        }
        int i = 0;
        while (i < nblks) {
            if (Blocks.isSolid(this.world.getblock(this.dimension, (int)(startx += dx), (int)(starty += dy), (int)(startz += dz)), this.world, this.dimension, (int)startx, (int)starty, (int)startz)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    public String getBossName() {
        return "Vortex!";
    }
}

