/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Effects;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class VelocityRaptor
extends EntityLiving {
    public VelocityRaptor(World w) {
        super(w);
        this.maxrenderdist = 100;
        this.height = 0.95f;
        this.width = 0.65f;
        this.uniquename = "OreSpawn:VelocityRaptor";
        this.moveSpeed = 0.65f;
        this.setMaxHealth(15.0f);
        this.setHealth(15.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 30;
        this.setExperience(10);
        this.enable_findfoodblock = true;
        this.foodblockfreq = 60;
        this.foodblockdistxz = 15;
        this.foodblockdisty = 4;
        this.foodblockheal = 2;
        this.foodblockdisteat = 12;
        this.fooddaytimeonly = true;
        this.canSwim = true;
        this.enable_taming = true;
        this.maxdisttoowner = 22.0f;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.enable_droppedfood = true;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 6;
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof VelocityRaptor;
    }

    @Override
    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == OreSpawnMain.crystalapple.itemID) {
            return true;
        }
        return this.isFoodForMe(bid, iid);
    }

    @Override
    public void doEntityAction(float deltaT) {
        float fl;
        Player p;
        this.enable_buddy = this.isBaby();
        if (!this.getStaying() && this.getOwnerName() != null && (p = (Player)DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null && (fl = p.getTotalEffect(1)) == 0.0f) {
            Effects ef = new Effects(1, 2.0f, 100);
            p.addEffectFromServer(ef);
        }
        super.doEntityAction(deltaT);
    }

    @Override
    public boolean isFoodBlock(int bid) {
        if (bid == Blocks.flower_red.blockID || bid == Blocks.flower_blue.blockID || bid == Blocks.flower_purple.blockID) {
            return true;
        }
        if (bid == Blocks.flower_yellow.blockID) {
            return true;
        }
        if (bid == Blocks.corn_plant.blockID || bid == Blocks.corn_plant1.blockID || bid == Blocks.corn_plant2.blockID) {
            return true;
        }
        if (bid == Blocks.corn_plant3.blockID || bid == Blocks.grass.blockID || bid == Blocks.radish_plant.blockID) {
            return true;
        }
        if (bid == Blocks.radish_plant1.blockID || bid == Blocks.radish_plant2.blockID || bid == Blocks.radish_plant3.blockID) {
            return true;
        }
        if (bid == Blocks.rice_plant.blockID || bid == Blocks.rice_plant1.blockID || bid == Blocks.rice_plant2.blockID) {
            return true;
        }
        return bid == Blocks.rice_plant3.blockID;
    }

    @Override
    public boolean isFoodItem(int iid) {
        return iid == Items.apple.itemID;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:cryo_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:cryo_death";
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, Blocks.flower_red.blockID, 0, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.goosemeat.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyvelocityraptor.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/VelocityRaptortexture.png");
        }
        return this.texture;
    }
}

