/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.entities.Butterfly;
import dangerzone.entities.Entity;
import dangerzone.entities.TargetHelper;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class VampireButterfly
extends Butterfly {
    int searchcounter = 0;
    Entity targetentity = null;
    Entity hurtMe = null;
    float attackRange = 1.5f;

    public VampireButterfly(World w) {
        super(w);
        this.setAttackDamage(1.0f);
        this.uniquename = "OreSpawn:VampireButterfly";
        this.searchDistance = 16.0f;
        this.canFly = true;
        this.setFlying(true);
        this.setExperience(-1);
        this.temperament = 1;
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/vbutterfly.png");
        }
        return this.texture;
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (e != this && !DangerZone.playnicely) {
            this.hurtMe = e;
        }
        super.doAttackFrom(e, dt, pain);
    }

    @Override
    public void doEntityAction(float deltaT) {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
                this.myspeed = 0.15f + this.world.rand.nextFloat() * 0.15f;
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(10) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom(this, dt, dmg);
        }
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (DangerZone.playnicely) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            Player p = (Player)e;
            return p.getGameMode() == 0;
        }
        return false;
    }
}

