/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.ThrownLaserball;
import OreSpawn.entities.UFO;
import OreSpawn.entities.UFOCarrier;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Martian;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.particles.Particle;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class UFOFighter
extends EntityLiving {
    public float myspeed = 0.0f;
    public float newangle = 0.0f;
    private int reloadticker = 0;

    public UFOFighter(World w) {
        super(w);
        this.maxrenderdist = 300;
        this.uniquename = "OreSpawn:UFO Fighter";
        if (w != null) {
            this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = false;
        this.setExperience(150);
        this.height = 2.1f;
        this.width = 2.5f;
        this.setMaxHealth(50.0f);
        this.setHealth(50.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(10.0f);
        this.searchDistance = 128.0f;
        this.attackRange = 3.5f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.canFly = true;
        this.setFlying(true);
        this.setCanDespawn(false);
        this.tower_defense_enable = false;
        this.enable_lookaround = true;
    }

    public float getNewangle() {
        this.newangle += 11.1f;
        while (this.newangle > 360.0f) {
            this.newangle -= 360.0f;
        }
        return (float)Math.toRadians(this.newangle);
    }

    @Override
    public void update(float deltaT) {
        if (!this.world.isServer) {
            int howmany = 1 + this.world.rand.nextInt(4);
            int i = 0;
            while (i < howmany) {
                int which = this.world.rand.nextInt(3);
                Particle eb = null;
                float leftright = -18.0f;
                if (this.world.rand.nextBoolean()) {
                    leftright = 18.0f;
                }
                float dx = (float)(4.75 * Math.sin(Math.toRadians(this.rotation_yaw + 180.0f + leftright)));
                float dz = (float)(4.75 * Math.cos(Math.toRadians(this.rotation_yaw + 180.0f + leftright)));
                dx += (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f;
                dz += (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f;
                if (which == 0) {
                    eb = this.world.createParticleByName("DangerZone:ParticleSparkle", this.dimension, this.posx + (double)dx, this.posy + (double)3.65f, this.posz + (double)dz);
                }
                if (which == 1) {
                    eb = this.world.createParticleByName("DangerZone:ParticleSmoke", this.dimension, this.posx + (double)dx, this.posy + (double)3.65f, this.posz + (double)dz);
                }
                if (which == 2) {
                    eb = this.world.createParticleByName("DangerZone:ParticleFire", this.dimension, this.posx + (double)dx, this.posy + (double)3.65f, this.posz + (double)dz);
                }
                if (eb != null) {
                    eb.motiony = 0.0f;
                    dx = (float)Math.sin(Math.toRadians(this.rotation_yaw + 180.0f));
                    dz = (float)Math.cos(Math.toRadians(this.rotation_yaw + 180.0f));
                    eb.motionx = dx * 0.18f;
                    eb.motionz = dz * 0.18f;
                    eb.maxlifetime = 35 + DangerZone.rand.nextInt(10);
                    this.world.spawnParticleInWorld(eb);
                }
                ++i;
            }
        }
        super.update(deltaT);
    }

    @Override
    public void doDistanceAttack(Entity victim) {
        double startz;
        double starty;
        if (this.reloadticker > 0) {
            return;
        }
        double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * 0.55f);
        ThrownLaserball e = (ThrownLaserball)this.world.createEntityByName("OreSpawn:ThrownLaserball", this.dimension, startx, starty = this.posy - 0.5, startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * 0.55f));
        if (e != null) {
            e.init();
            e.setBID(0);
            e.setIID(OreSpawnMain.laserball.itemID);
            e.thrower = this;
            float hdist = (float)Math.sqrt((victim.posx - startx) * (victim.posx - startx) + (victim.posz - startz) * (victim.posz - startz));
            float tdirxz = (float)Math.atan2(victim.posx - startx, victim.posz - startz);
            float tdiry = (float)Math.atan2(starty - (victim.posy + (double)(victim.getHeight() / 2.0f)), hdist);
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 15.0f, 0.05f);
            this.world.spawnEntityInWorld(e);
        }
        int which = this.world.rand.nextInt(6);
        String s = null;
        if (which == 0) {
            s = "OreSpawn:laser1";
        }
        if (which == 1) {
            s = "OreSpawn:laser2";
        }
        if (which == 2) {
            s = "OreSpawn:laser3";
        }
        if (which == 3) {
            s = "OreSpawn:laser4";
        }
        if (which == 4) {
            s = "OreSpawn:laser5";
        }
        if (which == 5) {
            s = "OreSpawn:laser6";
        }
        this.world.playSound(s, this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        this.reloadticker = 10;
    }

    public Entity findHome() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(250.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!(e instanceof UFO)) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public void doEntityAction(float deltaT) {
        int bid;
        if (this.reloadticker > 0) {
            --this.reloadticker;
        }
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            if (this.hurtMe != null && !this.isSuitableTarget(this.hurtMe)) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + 10.0, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
                Entity e = this.findHome();
                if (e != null && !e.getAttacking()) {
                    this.target = new TargetHelper(e, e.posx, e.posy, e.posz);
                    if (Utils.getDistanceBetweenEntities(this, e) < 7.0) {
                        this.deadflag = true;
                    }
                }
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(10) == 1) {
            if (this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                float dmg = this.getAttackDamage();
                int dt = 4;
                this.targetentity.doAttackFrom(this, dt, dmg);
            } else {
                this.doDistanceAttack(this.targetentity);
            }
        }
        if (!this.isHurt() && !this.deadflag && this.world.rand.nextInt(100) == 1) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        int keep_trying = 35;
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy + 1.0, this.posz);
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) == 0) {
            int i = 0;
            while (i < 4) {
                if (this.wouldBump(this.posx + (double)(this.motionx * deltaT), this.posy + (double)(this.motiony * deltaT) + (double)i, this.posz + (double)(this.motionz * deltaT), this.getWidth())) {
                    bid = 1;
                }
                ++i;
            }
        }
        if (bid != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 3.0) {
            int updown = 5;
            int k = 1;
            while (k < 13) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - k, (int)this.posz);
                if (bid != 0) {
                    updown = -1;
                    break;
                }
                ++k;
            }
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                if (this.isSwarming()) {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(25), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(25));
                } else {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(35) - (double)this.world.rand.nextInt(35), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(35) - (double)this.world.rand.nextInt(35));
                }
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                if (bid == 0 && !this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((this.posx - this.target.targetx) * (this.posx - this.target.targetx) + (this.posz - this.target.targetz) * (this.posz - this.target.targetz) + (this.posy - this.target.targety) * (this.posy - this.target.targety)))) {
                    bid = 1;
                }
                --keep_trying;
                this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
            }
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
            this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.12f * deltaT;
        if ((dy /= 20.0) > (double)0.2f) {
            dy = 0.2f;
        }
        if (dy < (double)-0.2f) {
            dy = -0.2f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        if (this.enable_lookaround) {
            this.doLookAction();
        }
        double dist = 0.0;
        Player p = DangerZone.server.findNearestPlayer(this);
        if (p == null) {
            this.deadflag = true;
        } else {
            dist = Utils.getHorizontalDistanceBetweenEntities(this, p);
            if (dist > (double)DangerZone.entityupdatedist) {
                this.deadflag = true;
            } else if (dist > (double)(DangerZone.entityupdatedist / 2)) {
                if (this.world.rand.nextInt(500) == 0) {
                    this.deadflag = true;
                }
            } else if (dist > (double)(DangerZone.entityupdatedist / 4)) {
                if (this.world.rand.nextInt(1250) == 0) {
                    this.deadflag = true;
                }
            } else if (dist > (double)(DangerZone.entityupdatedist / 8) && this.world.rand.nextInt(2500) == 0) {
                this.deadflag = true;
            }
        }
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Martian) {
            return false;
        }
        if (e instanceof UFOFighter) {
            return false;
        }
        if (e instanceof UFO) {
            return false;
        }
        if (e instanceof UFOCarrier) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public void doDeathDrops() {
        int i = 0;
        while (i < 5) {
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand(this.world, 0, Items.dark.itemID, 16.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand(this.world, 0, Items.light.itemID, 16.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand(this.world, 0, Items.instability.itemID, 16.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand(this.world, 0, Items.lumpcopper.itemID, 16.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand(this.world, 0, Items.lumptin.itemID, 16.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand(this.world, 0, Items.lumpsilver.itemID, 16.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand(this.world, 0, Items.lumpplatinum.itemID, 16.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand(this.world, 0, OreSpawnMain.laserball.itemID, 16.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand(this.world, 0, OreSpawnMain.raygun.itemID, 16.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand(this.world, Blocks.blockcopper.blockID, 0, 8.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand(this.world, Blocks.blocktin.blockID, 0, 8.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand(this.world, Blocks.blocksilver.blockID, 0, 8.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand(this.world, Blocks.blockplatinum.blockID, 0, 8.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            ++i;
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/UFO_Fightertexture.png");
        }
        return this.texture;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:dragonfly_hurt";
    }

    @Override
    public String getDeathSound() {
        int which = this.world.rand.nextInt(3);
        if (which == 0) {
            return "DangerZone:small_explosion1";
        }
        if (which == 1) {
            return "DangerZone:small_explosion2";
        }
        return "DangerZone:small_explosion3";
    }

    @Override
    public String getLivingSound() {
        int which = this.world.rand.nextInt(17);
        if (which == 0) {
            return "OreSpawn:hover1";
        }
        if (which == 1) {
            return "OreSpawn:hover2";
        }
        if (which == 2) {
            return "OreSpawn:hover3";
        }
        if (which == 3) {
            return "OreSpawn:hover4";
        }
        if (which == 4) {
            return "OreSpawn:hover5";
        }
        if (which == 5) {
            return "OreSpawn:hover6";
        }
        if (which == 6) {
            return "OreSpawn:robotspider1";
        }
        if (which == 7) {
            return "OreSpawn:robotspider2";
        }
        if (which == 8) {
            return "OreSpawn:robotspider3";
        }
        if (which == 9) {
            return "OreSpawn:robotspider4";
        }
        if (which == 10) {
            return "OreSpawn:robotspider5";
        }
        if (which == 11) {
            return "OreSpawn:robotspider6";
        }
        if (which == 12) {
            return "OreSpawn:robotspider7";
        }
        if (which == 13) {
            return "OreSpawn:robotspider8";
        }
        if (which == 14) {
            return "OreSpawn:robotspider9";
        }
        if (which == 15) {
            return "OreSpawn:robotspider10";
        }
        if (which == 16) {
            return "OreSpawn:robotspider11";
        }
        return null;
    }

    @Override
    public void setBaby(boolean tf) {
    }
}

