/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.entities.ElementDragon;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.ThrownBlockItem;
import dangerzone.particles.Particle;
import dangerzone.world.World;

public class ThrownWind
extends ThrownBlockItem {
    public ThrownWind(World w) {
        super(w);
        this.uniquename = "OreSpawn:ThrownWind";
        this.setAttackDamage(25.0f);
    }

    @Override
    public void doSpecialEffects(double x, double y, double z) {
        if (this.world.rand.nextInt(4) == 1) {
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 1, this.dimension, x, y, z);
        }
    }

    @Override
    public void doHitSomething(boolean hb, double x, double y, double z, boolean he, Entity ent) {
        if (ent != null) {
            if (ent instanceof ElementDragon) {
                return;
            }
            ent.doAttackFrom(this.thrower, 4, this.getAttackDamage());
            if (this.getDistanceFromEntity(ent) < 6.0) {
                ent.addKnockback(this, -1.5f, (float)(6.0 - this.getDistanceFromEntity(ent)) * 2.5f);
            }
            int i = 0;
            while (i < 200) {
                float d = this.world.rand.nextFloat() * 3.0f;
                d *= d;
                float dir = (float)((double)(this.world.rand.nextFloat() * 2.0f) * Math.PI);
                dir = (float)((double)dir - Math.PI);
                float dx = (float)(Math.cos(dir) * (double)d / 2.0);
                float dz = (float)(Math.sin(dir) * (double)d / 2.0);
                dir = (float)((double)dir + 1.5707963267948966);
                Particle eb = null;
                eb = this.world.createParticleByName("DangerZone:ParticleSmoke", this.dimension, ent.posx + (double)dx, ent.posy + 0.75 + (double)d, ent.posz + (double)dz);
                if (eb != null) {
                    eb.motiony = 0.0f;
                    dx = (float)Math.sin(Math.toRadians(this.rotation_yaw + 180.0f));
                    dz = (float)Math.cos(Math.toRadians(this.rotation_yaw + 180.0f));
                    eb.motionx = (float)(Math.cos(dir) * (double)this.world.rand.nextFloat() / 4.0);
                    eb.motiony = this.world.rand.nextFloat() / 2.0f;
                    eb.motionz = (float)(Math.sin(dir) * (double)this.world.rand.nextFloat() / 4.0);
                    eb.maxlifetime = 15 + this.world.rand.nextInt(15);
                    this.world.spawnParticleInWorld(eb);
                }
                ++i;
            }
            return;
        }
        int i = 0;
        while (i < 100) {
            float d = this.world.rand.nextFloat() * 2.0f;
            d *= d;
            float dir = (float)((double)(this.world.rand.nextFloat() * 2.0f) * Math.PI);
            dir = (float)((double)dir - Math.PI);
            float dx = (float)(Math.cos(dir) * (double)d / 2.0);
            float dz = (float)(Math.sin(dir) * (double)d / 2.0);
            dir = (float)((double)dir + 1.5707963267948966);
            Particle eb = null;
            eb = this.world.createParticleByName("DangerZone:ParticleSmoke", this.dimension, x + (double)dx, y + 0.75 + (double)d, z + (double)dz);
            if (eb != null) {
                eb.motiony = 0.0f;
                dx = (float)Math.sin(Math.toRadians(this.rotation_yaw + 180.0f));
                dz = (float)Math.cos(Math.toRadians(this.rotation_yaw + 180.0f));
                eb.motionx = (float)(Math.cos(dir) * (double)this.world.rand.nextFloat() / 4.0);
                eb.motiony = this.world.rand.nextFloat() / 2.0f;
                eb.motionz = (float)(Math.sin(dir) * (double)this.world.rand.nextFloat() / 4.0);
                eb.maxlifetime = 15 + this.world.rand.nextInt(15);
                this.world.spawnParticleInWorld(eb);
            }
            ++i;
        }
    }
}

