/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.entities.AntRobot;
import OreSpawn.entities.Jeffery;
import OreSpawn.entities.RoboBomb;
import OreSpawn.entities.RoboGunner;
import OreSpawn.entities.RoboPounder;
import OreSpawn.entities.RoboSniper;
import OreSpawn.entities.RoboWarrior;
import OreSpawn.entities.SpiderRobot;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.ThrownBlockItem;
import dangerzone.world.World;

public class ThrownLaserball
extends ThrownBlockItem {
    int toggle = 0;

    public ThrownLaserball(World w) {
        super(w);
        this.uniquename = "OreSpawn:ThrownLaserball";
        this.maxrenderdist = 256;
        this.deathtimer = 30;
        this.movement_friction = false;
        this.gravity = false;
    }

    @Override
    public void doSpecialEffects(double x, double y, double z) {
        if (this.toggle > 0) {
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSparkle", 1, this.dimension, x, y, z);
            this.toggle = 0;
        } else {
            ++this.toggle;
        }
    }

    @Override
    public void doHitSomething(boolean hb, double x, double y, double z, boolean he, Entity ent) {
        if (he && ent != null) {
            int which;
            if (ent instanceof Jeffery || ent instanceof AntRobot || ent instanceof SpiderRobot || ent instanceof RoboBomb || ent instanceof RoboGunner || ent instanceof RoboPounder || ent instanceof RoboWarrior || ent instanceof RoboSniper || ent instanceof AntRobot) {
                this.deadflag = true;
                return;
            }
            ent.doAttackFrom(this.thrower, 9, 15.0f);
            Utils.spawnParticlesFromServerScaled(this.world, "DangerZone:ParticleHurt", 25, this.dimension, x, y, z, 0, 0.25f * (ent.getWidth() + ent.getHeight()) / 4.0f);
            float dir = (float)Math.atan2(ent.posz - z, ent.posx - x);
            float hdist = (float)Math.sqrt((ent.posx - x) * (ent.posx - x) + (ent.posz - z) * (ent.posz - z));
            float ydir = (float)Math.atan2(ent.posy + (double)(ent.getHeight() / 2.0f) - y, hdist);
            ent.motionx = (float)((double)ent.motionx + Math.cos(dir) * 1.25 * Math.cos(ydir));
            ent.motionz = (float)((double)ent.motionz + Math.sin(dir) * 1.25 * Math.cos(ydir));
            ent.motiony = (float)((double)ent.motiony + (double)0.35f * Math.sin(ydir));
            if (ent instanceof Player) {
                Player pl = (Player)ent;
                pl.server_thread.sendVelocityUpdateToPlayer(ent.motionx, ent.motiony, ent.motionz);
            }
            if ((which = this.world.rand.nextInt(5)) == 0) {
                this.world.playSound("DangerZone:small_explosion1", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
            if (which == 1) {
                this.world.playSound("DangerZone:small_explosion2", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
            if (which == 2) {
                this.world.playSound("DangerZone:small_explosion3", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
            if (which == 3) {
                this.world.playSound("DangerZone:small_explosion4", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
            if (which == 4) {
                this.world.playSound("DangerZone:small_explosion5", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
        } else {
            Utils.spawnParticlesFromServerScaled(this.world, "DangerZone:ParticleBreak", 25, this.dimension, x, y, z, 0, 0.5f);
        }
        this.deadflag = true;
    }
}

