/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.EntityLivingDragon;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.ThePrince;
import OreSpawn.entities.ThePrinceYoungAdult;
import OreSpawn.entities.ThrownThunder;
import OreSpawn.entities.ThrownWaterball;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.TargetHelper;
import dangerzone.entities.ThrownBlockItem;
import dangerzone.entities.ThrownFireball;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class ThePrinceTeen
extends EntityLivingDragon {
    private int soundcount = 0;
    Entity targetentity = null;
    Entity hurtMe = null;
    float attackRange = 4.5f;
    int searchcounter = 0;
    float myspeed = 0.25f;
    private int fireballticker = 0;
    public int head1ext = 0;
    public int head2ext = 0;
    public int head3ext = 0;
    private int head1dir = 1;
    private int head2dir = 1;
    private int head3dir = 1;

    public ThePrinceTeen(World w) {
        super(w);
        this.maxrenderdist = 200;
        this.height = 3.75f;
        this.width = 3.25f;
        this.uniquename = "OreSpawn:ThePrinceTeen";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(1600.0f);
        this.setHealth(1600.0f);
        this.setDefense(3.0f);
        this.setAttackDamage(45.0f);
        this.movefrequency = 55;
        this.setExperience(199);
        this.sit_when_riding = true;
        this.takesFallDamage = false;
        this.isImmuneToFire = true;
        this.searchDistance = 30.0f;
        this.canSwim = true;
        this.canBreateUnderWater = true;
        this.enable_taming = true;
        this.maxdisttoowner = 24.0f;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.enable_droppedfood = true;
        this.canFly = true;
        this.setCanDespawn(false);
        this.tower_defense_enable = false;
        this.setGroundFactor(1.55f);
        this.setAirFactor(2.5f);
    }

    @Override
    public void onKill(Entity e) {
        if (e.getWidth() * e.getHeight() > 1.0f) {
            this.setVarInt(22, this.getVarInt(22) + 1);
        }
        if (this.getVarInt(22) >= 25) {
            ThePrinceTeen sc = (ThePrinceTeen)this.world.createEntityByName("OreSpawn:ThePrinceYoungAdult", this.dimension, this.posx, this.posy, this.posz);
            if (sc != null) {
                sc.init();
                sc.setOwnerName(this.getOwnerName());
                sc.setCanDespawn(false);
                this.world.spawnEntityInWorld(sc);
                this.deadflag = true;
            }
            this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
    }

    public int getHead1Ext() {
        return this.head1ext;
    }

    public int getHead2Ext() {
        return this.head2ext;
    }

    public int getHead3Ext() {
        return this.head3ext;
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/ThePrinceTeentexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer) {
            if (ic == null && this.getOwnerName() != null && p.getPetName().equals(this.getOwnerName())) {
                if (this.isMountedBy(p)) {
                    this.unMount(p);
                } else {
                    this.Mount(p);
                    this.setSitting(false);
                    this.setStaying(false);
                }
                return false;
            }
            if (ic != null && ic.iid == Items.diamond.itemID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
                ThePrince sc = (ThePrince)this.world.createEntityByName("OreSpawn:ThePrince", this.dimension, this.posx, this.posy, this.posz);
                if (sc != null) {
                    sc.init();
                    sc.setOwnerName(this.getOwnerName());
                    sc.setCanDespawn(false);
                    this.world.spawnEntityInWorld(sc);
                    this.deadflag = true;
                }
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                return true;
            }
            if (ic != null && ic.bid == Blocks.blockdiamond.blockID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
                ThePrinceYoungAdult sc = (ThePrinceYoungAdult)this.world.createEntityByName("OreSpawn:ThePrinceYoungAdult", this.dimension, this.posx, this.posy, this.posz);
                if (sc != null) {
                    sc.init();
                    sc.setOwnerName(this.getOwnerName());
                    sc.setCanDespawn(false);
                    this.world.spawnEntityInWorld(sc);
                    this.deadflag = true;
                }
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                return true;
            }
        }
        return super.rightClickedByPlayer(p, ic);
    }

    @Override
    public boolean isFoodItem(int iid) {
        return iid == Items.moosemeat.itemID;
    }

    @Override
    public float getRiderYoffset() {
        return 2.25f;
    }

    @Override
    public float getRiderXZoffset() {
        return 0.15f;
    }

    private void doFlyingAttack() {
        ++this.searchcounter;
        if (this.searchcounter >= 6) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(8) == 1) {
            if (this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange * 2.0f + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                float dmg = this.getAttackDamage();
                int dt = 4;
                this.targetentity.doAttackFrom(this, dt, dmg);
            } else if (this.getRiderEntity() == null && this.world.rand.nextBoolean()) {
                this.do_a_distance_attack(this.targetentity);
            }
        }
    }

    private void doNormalAttack() {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(10) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(8) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom(this, dt, dmg);
        }
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof EntityLivingDragon) {
            return false;
        }
        if (this.getDistanceFromEntity(e) > (double)(this.maxdisttoowner * 2.0f)) {
            return false;
        }
        if (e instanceof Player) {
            return false;
        }
        if (e instanceof Girlfriend) {
            return false;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(5) != 1) {
            return null;
        }
        int which = this.world.rand.nextInt(6);
        if (which == 0) {
            return "OreSpawn:roar1";
        }
        if (which == 1) {
            return "OreSpawn:roar2";
        }
        if (which == 2) {
            return "OreSpawn:roar3";
        }
        if (which == 3) {
            return "OreSpawn:roar4";
        }
        if (which == 4) {
            return "OreSpawn:roar5";
        }
        return "OreSpawn:roar6";
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        this.setFlying(true);
        this.setStaying(false);
        if (e != null && this.isSuitableTarget(e)) {
            this.hurtMe = e;
        }
        if (dt == 9) {
            return;
        }
        if (dt == 10) {
            return;
        }
        if (dt == 12) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
    }

    @Override
    public void doEntityAction(float deltaT) {
        Entity rider = this.getRiderEntity();
        if (this.world.rand.nextInt(20) == 1) {
            this.heal(3.0f);
        }
        if (this.isFlying()) {
            this.ignoreCollisions = rider == null;
            ++this.soundcount;
            if (this.soundcount > 12) {
                this.soundcount = 0;
                int which = this.world.rand.nextInt(3);
                if (which == 0) {
                    this.world.playSound("OreSpawn:MothraWings1", this.dimension, this.posx, this.posy, this.posz, 0.5f, 1.0f);
                }
                if (which == 1) {
                    this.world.playSound("OreSpawn:MothraWings2", this.dimension, this.posx, this.posy, this.posz, 0.5f, 1.0f);
                }
                if (which == 2) {
                    this.world.playSound("OreSpawn:MothraWings3", this.dimension, this.posx, this.posy, this.posz, 0.5f, 1.0f);
                }
            }
        } else {
            this.ignoreCollisions = false;
        }
        if (rider == null) {
            if (!this.isFlying()) {
                if (!this.getStaying()) {
                    this.doNormalAttack();
                    if (this.getOwnerName() != null) {
                        double dist = 0.0;
                        Entity e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName());
                        if (e != null) {
                            dist = this.getDistanceFromEntity(e);
                        }
                        if (dist > (double)(this.maxdisttoowner + 8.0f)) {
                            this.setFlying(true);
                        }
                    }
                    if (this.world.rand.nextInt(750) == 1) {
                        this.setFlying(true);
                    }
                }
                super.doEntityAction(deltaT);
                return;
            }
            this.doFlyingAttack();
            this.doSoloFlying(deltaT);
            this.doLookAction();
            if (this.world.rand.nextInt(250) == 1) {
                this.setFlying(false);
            }
            if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
                this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
            }
            return;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.toRadians(rider.rotation_yaw);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        if (ddiff > 0.2f) {
            ddiff = 0.2f;
        }
        if (ddiff < -0.2f) {
            ddiff = -0.2f;
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 6.0);
        cdir = (float)Math.toRadians(this.rotation_yaw_head);
        tdir = (float)Math.toRadians(rider.rotation_yaw_head);
        ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 5.0);
        if (this.getOnGround()) {
            this.setFlying(false);
        } else {
            this.setFlying(true);
            Utils.SpawnDustAlongPath(this);
        }
        this.doFlyingAttack();
        ++this.fireballticker;
        if (this.fireballticker > 5) {
            this.fireballticker = 6;
        }
        if (rider.getLeft() && this.fireballticker > 5) {
            this.fireballticker = 0;
            this.doriderfireball();
        }
        if (rider.getRight() && this.fireballticker > 5) {
            this.fireballticker = 0;
            this.doriderfireball();
        }
    }

    public void doSoloFlying(float deltaT) {
        int bid;
        Entity e;
        int keep_trying = 35;
        double px = this.posx;
        double py = this.posy;
        double pz = this.posz;
        double dist = 0.0;
        int dxz = 25;
        float speedadjust = 1.0f;
        if (this.getOwnerName() != null && (e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null) {
            px = e.posx;
            py = e.posy + (double)(e.getHeight() / 2.0f);
            pz = e.posz;
            dxz = 25;
            dist = this.getDistanceFromEntity(e);
            if (dist > (double)this.maxdisttoowner) {
                speedadjust = 1.75f;
            }
            if (dist > (double)(this.maxdisttoowner * 1.5f)) {
                speedadjust = 2.75f;
            }
        }
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                this.target.setTarget(px + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)), py + (double)(this.world.rand.nextInt(7) - 2), pz + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)));
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                --keep_trying;
            }
            this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.3f;
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.12f * deltaT;
        if ((dy /= 20.0) > (double)0.2f) {
            dy = 0.2f;
        }
        if (dy < (double)-0.2f) {
            dy = -0.2f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 8.0);
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        Utils.SpawnDustAlongPath(this);
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, 0, OreSpawnMain.trophytheprinceteen.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, OreSpawnMain.eggtheprince.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        super.doDeathDrops();
    }

    private void doriderfireball() {
        ThrownBlockItem e;
        Entity rider = this.getRiderEntity();
        double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() * 3.0f / 2.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)));
        double starty = this.posy + (double)this.getJustMyHeight();
        double startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() * 3.0f / 2.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)));
        float tdirxz = (float)Math.toRadians(rider.rotation_yaw_head);
        float tdiry = (float)Math.toRadians(rider.rotation_pitch_head);
        int which = this.world.rand.nextInt(3);
        if (which == 0 && (e = (ThrownFireball)this.world.createEntityByName("DangerZone:ThrownFireball", this.dimension, startx, starty, startz)) != null) {
            e.init();
            e.setBID(0);
            e.setIID(Items.fireball.itemID);
            ((ThrownFireball)e).thrower = this;
            ((ThrownFireball)e).explosive_power = 5.0f;
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 6.5f, 0.2f);
            this.world.spawnEntityInWorld(e);
        }
        if (which == 1 && (e = (ThrownWaterball)this.world.createEntityByName("OreSpawn:ThrownWaterball", this.dimension, startx, starty, startz)) != null) {
            e.init();
            e.setBID(0);
            e.setIID(OreSpawnMain.waterball.itemID);
            e.setAttackDamage(10.0f);
            ((ThrownWaterball)e).thrower = this;
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 6.5f, 0.2f);
            this.world.spawnEntityInWorld(e);
        }
        if (which == 2 && (e = (ThrownThunder)this.world.createEntityByName("OreSpawn:ThrownThunder", this.dimension, startx, starty, startz)) != null) {
            e.init();
            e.setBID(0);
            e.setIID(0);
            ((ThrownThunder)e).thrower = this;
            e.setAttackDamage(10.0f);
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 16.5f, 0.1f);
            this.world.spawnEntityInWorld(e);
        }
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 0.6f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }

    @Override
    public void update(float deltaT) {
        if (!this.world.isServer) {
            int i;
            if (this.world.rand.nextInt(10) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head1dir = 2;
                }
                if (i == 1) {
                    this.head1dir = -2;
                }
                if (i == 2) {
                    this.head1dir = 0;
                }
            }
            if (this.world.rand.nextInt(10) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head2dir = 2;
                }
                if (i == 1) {
                    this.head2dir = -2;
                }
                if (i == 2) {
                    this.head2dir = 0;
                }
            }
            if (this.world.rand.nextInt(10) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head3dir = 2;
                }
                if (i == 1) {
                    this.head3dir = -2;
                }
                if (i == 2) {
                    this.head3dir = 0;
                }
            }
            this.head1ext += this.head1dir;
            if (this.head1ext < 0) {
                this.head1ext = 0;
            }
            if (this.head1ext > 60) {
                this.head1ext = 60;
            }
            this.head2ext += this.head2dir;
            if (this.head2ext < 0) {
                this.head2ext = 0;
            }
            if (this.head2ext > 60) {
                this.head2ext = 60;
            }
            this.head3ext += this.head3dir;
            if (this.head3ext < 0) {
                this.head3ext = 0;
            }
            if (this.head3ext > 60) {
                this.head3ext = 60;
            }
        }
        super.update(deltaT);
    }

    private void do_a_distance_attack(Entity victim) {
        ThrownBlockItem e;
        double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() * 3.0f / 2.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)));
        double starty = this.posy + (double)this.getHeight();
        double startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() * 3.0f / 2.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)));
        float hdist = (float)Math.sqrt((victim.posx - startx) * (victim.posx - startx) + (victim.posz - startz) * (victim.posz - startz));
        float tdirxz = (float)Math.atan2(victim.posx - startx, victim.posz - startz);
        float tdiry = (float)Math.atan2(starty - (victim.posy + (double)(victim.getHeight() / 2.0f)), hdist);
        int which = this.world.rand.nextInt(3);
        if (which == 0 && (e = (ThrownFireball)this.world.createEntityByName("DangerZone:ThrownFireball", this.dimension, startx, starty, startz)) != null) {
            e.init();
            e.setBID(0);
            e.setIID(Items.fireball.itemID);
            ((ThrownFireball)e).thrower = this;
            ((ThrownFireball)e).explosive_power = 3.0f;
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 5.5f, 0.2f);
            this.world.spawnEntityInWorld(e);
        }
        if (which == 1 && (e = (ThrownWaterball)this.world.createEntityByName("OreSpawn:ThrownWaterball", this.dimension, startx, starty, startz)) != null) {
            e.init();
            e.setBID(0);
            e.setIID(OreSpawnMain.waterball.itemID);
            ((ThrownWaterball)e).thrower = this;
            e.setAttackDamage(15.0f);
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 5.5f, 0.2f);
            this.world.spawnEntityInWorld(e);
        }
        if (which == 2 && (e = (ThrownThunder)this.world.createEntityByName("OreSpawn:ThrownThunder", this.dimension, startx, starty, startz)) != null) {
            e.init();
            e.setBID(0);
            e.setIID(0);
            ((ThrownThunder)e).thrower = this;
            e.setAttackDamage(10.0f);
            tdiry = (float)Math.atan2(starty - victim.posy, hdist);
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 16.5f, 0.1f);
            this.world.spawnEntityInWorld(e);
        }
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }

    @Override
    public void setBaby(boolean tf) {
    }

    @Override
    public boolean isBoss() {
        return this.getOwnerName() != null && this.getOwnerName().equals(DangerZone.player.myname);
    }

    @Override
    public String getBossName() {
        return "The Teen Prince";
    }
}

