/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.EntityLivingDragon;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.Mosquito;
import OreSpawn.entities.ThePrinceTeen;
import OreSpawn.entities.ThrownThunder;
import OreSpawn.entities.ThrownWaterball;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.ToDoList;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.TargetHelper;
import dangerzone.entities.ThrownBlockItem;
import dangerzone.entities.ThrownFireball;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class ThePrince
extends EntityLivingDragon {
    float myspeed = 0.0f;
    float attackRange;
    int searchcounter;
    Entity hurtMe = null;
    Entity targetentity = null;
    private int head1ext = 0;
    private int head2ext = 0;
    private int head3ext = 0;
    private int head1dir = 1;
    private int head2dir = 1;
    private int head3dir = 1;

    public ThePrince(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.uniquename = "OreSpawn:ThePrince";
        if (w != null) {
            this.myspeed = 0.25f + this.world.rand.nextFloat() * 0.25f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.setExperience(50);
        this.height = 0.95f;
        this.width = 0.95f;
        this.setMaxHealth(400.0f);
        this.setHealth(400.0f);
        this.setDefense(2.0f);
        this.setAttackDamage(15.0f);
        this.searchDistance = 20.0f;
        this.attackRange = 2.5f;
        this.isImmuneToFire = true;
        this.setCanDespawn(false);
        this.canSwim = true;
        this.enable_taming = true;
        this.maxdisttoowner = 24.0f;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.enable_droppedfood = true;
        this.canFly = true;
        this.tower_defense_enable = false;
    }

    @Override
    public void onKill(Entity e) {
        if (e.getWidth() * e.getHeight() > 0.25f) {
            this.setVarInt(22, this.getVarInt(22) + 1);
        }
        if (this.getVarInt(22) >= 25) {
            ThePrinceTeen sc = (ThePrinceTeen)this.world.createEntityByName("OreSpawn:ThePrinceTeen", this.dimension, this.posx, this.posy, this.posz);
            if (sc != null) {
                sc.init();
                sc.setOwnerName(this.getOwnerName());
                sc.setCanDespawn(false);
                this.world.spawnEntityInWorld(sc);
                this.deadflag = true;
            }
            this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer && ic != null && ic.bid == Blocks.blockdiamond.blockID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
            ThePrinceTeen sc = (ThePrinceTeen)this.world.createEntityByName("OreSpawn:ThePrinceTeen", this.dimension, this.posx, this.posy, this.posz);
            if (sc != null) {
                sc.init();
                sc.setOwnerName(this.getOwnerName());
                sc.setCanDespawn(false);
                this.world.spawnEntityInWorld(sc);
                this.deadflag = true;
            }
            this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            return true;
        }
        return super.rightClickedByPlayer(p, ic);
    }

    public int getHead1Ext() {
        return this.head1ext;
    }

    public int getHead2Ext() {
        return this.head2ext;
    }

    public int getHead3Ext() {
        return this.head3ext;
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        this.setFlying(true);
        this.setStaying(false);
        if (e != null && this.isSuitableTarget(e)) {
            this.hurtMe = e;
        }
        if (dt == 10) {
            return;
        }
        if (dt == 12) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
    }

    @Override
    public boolean isFoodItem(int iid) {
        return iid == Items.moosemeat.itemID;
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (!this.isFlying()) {
            this.ignoreCollisions = false;
            super.doEntityAction(deltaT);
            if (!this.getStaying() && this.world.rand.nextInt(15) == 1 && this.findSomethingToAttack() != null) {
                this.setFlying(true);
            }
        } else {
            this.ignoreCollisions = true;
            if (this.getOwnerName() != null) {
                ++this.searchcounter;
                if (this.searchcounter >= 10) {
                    this.searchcounter = this.world.rand.nextInt(4);
                    if (this.hurtMe != null && this.hurtMe.deadflag) {
                        this.hurtMe = null;
                    }
                    if (this.world.rand.nextInt(20) == 1) {
                        this.hurtMe = null;
                    }
                    this.targetentity = this.hurtMe;
                    if (this.targetentity == null) {
                        this.targetentity = this.findSomethingToAttack();
                    }
                    if (this.targetentity != null) {
                        this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                        this.setAttacking(true);
                    } else {
                        this.setAttacking(false);
                    }
                }
                if (this.targetentity != null && this.world.rand.nextInt(10) == 1) {
                    if (this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                        float dmg = this.getAttackDamage();
                        int dt = 4;
                        this.targetentity.doAttackFrom(this, dt, dmg);
                    } else if (this.world.rand.nextInt(5) == 1) {
                        this.do_a_distance_attack(this.targetentity);
                    }
                }
            }
            this.doLookAction();
            if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
                this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
            }
        }
    }

    @Override
    public void update(float deltaT) {
        block43: {
            int i;
            block40: {
                Entity e;
                float speedadjust;
                int dxz;
                double dist;
                double pz;
                double py;
                double px;
                int keep_trying;
                block42: {
                    block41: {
                        if (!this.world.isServer) break block40;
                        keep_trying = 35;
                        px = this.posx;
                        py = this.posy;
                        pz = this.posz;
                        dist = 0.0;
                        dxz = 25;
                        speedadjust = 1.0f;
                        if (this.getOwnerName() == null) break block41;
                        e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName());
                        if (e == null) break block42;
                        px = e.posx;
                        py = e.posy + (double)(e.getHeight() / 2.0f);
                        pz = e.posz;
                        dxz = 20;
                        dist = this.getDistanceFromEntity(e);
                        if (dist > (double)this.maxdisttoowner) {
                            speedadjust = 1.75f;
                        }
                        if (!(dist > (double)(this.maxdisttoowner * 1.5f))) break block42;
                        speedadjust = 2.75f;
                        break block42;
                    }
                    List<Entity> nearby_list = null;
                    nearby_list = DangerZone.server.entityManager.findEntitiesInRange(8.0f, this.dimension, this.posx, this.posy, this.posz);
                    if (nearby_list != null && !nearby_list.isEmpty()) {
                        Entity e2 = null;
                        ListIterator<Entity> li = nearby_list.listIterator();
                        while (li.hasNext()) {
                            e2 = li.next();
                            if (!(e2 instanceof Player)) continue;
                            Player p = (Player)e2;
                            this.setOwnerName(p.myname);
                            ToDoList.onTamed(p, this);
                        }
                    }
                }
                if (this.getStaying() && this.isFlying()) {
                    this.setFlying(false);
                }
                if (this.isFlying()) {
                    int bid;
                    if (this.target == null) {
                        this.target = new TargetHelper(this.posx, this.posy, this.posz);
                    }
                    if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
                        bid = 1;
                        while (bid != 0 && keep_trying != 0) {
                            this.target.setTarget(px + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)), py + (double)(this.world.rand.nextInt(7) - 2), pz + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)));
                            bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                            --keep_trying;
                        }
                        this.myspeed = 0.25f + this.world.rand.nextFloat() * 0.25f;
                    }
                    if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
                        this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
                    }
                    double dy = this.target.targety - this.posy;
                    this.motiony += 0.12f * deltaT;
                    if ((dy /= 20.0) > (double)0.2f) {
                        dy = 0.2f;
                    }
                    if (dy < (double)-0.2f) {
                        dy = -0.2f;
                    }
                    this.motiony = (float)((double)this.motiony + dy);
                    if (this.motiony > 1.0f) {
                        this.motiony = 1.0f;
                    }
                    if (this.motiony < -1.0f) {
                        this.motiony = -1.0f;
                    }
                    float cdir = (float)Math.toRadians(this.rotation_yaw);
                    float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
                    float ddiff = tdir - cdir;
                    while ((double)ddiff > Math.PI) {
                        ddiff = (float)((double)ddiff - Math.PI * 2);
                    }
                    while ((double)ddiff < -Math.PI) {
                        ddiff = (float)((double)ddiff + Math.PI * 2);
                    }
                    this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
                    float effectspeed = this.getTotalEffect(1);
                    if (effectspeed > 1.0f) {
                        speedadjust *= effectspeed;
                    }
                    if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
                        speedadjust /= effectspeed;
                    }
                    this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
                    this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
                    Utils.SpawnDustAlongPath(this);
                    if (this.world.rand.nextInt(250) == 1) {
                        this.setFlying(false);
                    }
                } else if (!this.getStaying()) {
                    if (this.getOwnerName() != null && (e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null && (dist = this.getDistanceFromEntity(e)) > 32.0) {
                        this.setFlying(true);
                    }
                    if (this.world.rand.nextInt(750) == 1) {
                        this.setFlying(true);
                    }
                }
                break block43;
            }
            if (this.world.rand.nextInt(10) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head1dir = 2;
                }
                if (i == 1) {
                    this.head1dir = -2;
                }
                if (i == 2) {
                    this.head1dir = 0;
                }
            }
            if (this.world.rand.nextInt(10) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head2dir = 2;
                }
                if (i == 1) {
                    this.head2dir = -2;
                }
                if (i == 2) {
                    this.head2dir = 0;
                }
            }
            if (this.world.rand.nextInt(10) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head3dir = 2;
                }
                if (i == 1) {
                    this.head3dir = -2;
                }
                if (i == 2) {
                    this.head3dir = 0;
                }
            }
            this.head1ext += this.head1dir;
            if (this.head1ext < 0) {
                this.head1ext = 0;
            }
            if (this.head1ext > 60) {
                this.head1ext = 60;
            }
            this.head2ext += this.head2dir;
            if (this.head2ext < 0) {
                this.head2ext = 0;
            }
            if (this.head2ext > 60) {
                this.head2ext = 60;
            }
            this.head3ext += this.head3dir;
            if (this.head3ext < 0) {
                this.head3ext = 0;
            }
            if (this.head3ext > 60) {
                this.head3ext = 60;
            }
        }
        super.update(deltaT);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof EntityLivingDragon) {
            return false;
        }
        if (e instanceof Player) {
            return false;
        }
        if (e instanceof Girlfriend) {
            return false;
        }
        if (this.getDistanceFromEntity(e) > (double)(this.maxdisttoowner * 2.0f)) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Mosquito && this.CanProbablySeeEntity(e);
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, 0, OreSpawnMain.trophytheprince.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, OreSpawnMain.eggtheprince.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/ThePrincetexture.png");
        }
        return this.texture;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:duck_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:cryo_death";
    }

    @Override
    public String getLivingSound() {
        if (!this.getAttacking()) {
            return null;
        }
        int which = this.world.rand.nextInt(6);
        if (which == 0) {
            return "OreSpawn:roar1";
        }
        if (which == 1) {
            return "OreSpawn:roar2";
        }
        if (which == 2) {
            return "OreSpawn:roar3";
        }
        if (which == 3) {
            return "OreSpawn:roar4";
        }
        if (which == 4) {
            return "OreSpawn:roar5";
        }
        return "OreSpawn:roar6";
    }

    @Override
    public float getLivingSoundPitch() {
        return 1.7f + (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.3f;
    }

    private void do_a_distance_attack(Entity victim) {
        ThrownBlockItem e;
        double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * this.getWidth() * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)));
        double starty = this.posy + 0.5;
        double startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * this.getWidth() * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)));
        float hdist = (float)Math.sqrt((victim.posx - startx) * (victim.posx - startx) + (victim.posz - startz) * (victim.posz - startz));
        float tdirxz = (float)Math.atan2(victim.posx - startx, victim.posz - startz);
        float tdiry = (float)Math.atan2(starty - (victim.posy + (double)(victim.getHeight() / 2.0f)), hdist);
        int which = this.world.rand.nextInt(3);
        if (which == 0 && (e = (ThrownFireball)this.world.createEntityByName("DangerZone:ThrownFireball", this.dimension, startx, starty, startz)) != null) {
            e.init();
            e.setBID(0);
            e.setIID(Items.fireball.itemID);
            ((ThrownFireball)e).thrower = this;
            ((ThrownFireball)e).explosive_power = 1.0f;
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 5.5f, 0.2f);
            this.world.spawnEntityInWorld(e);
        }
        if (which == 1 && (e = (ThrownWaterball)this.world.createEntityByName("OreSpawn:ThrownWaterball", this.dimension, startx, starty, startz)) != null) {
            e.init();
            e.setBID(0);
            e.setIID(OreSpawnMain.waterball.itemID);
            ((ThrownWaterball)e).thrower = this;
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 5.5f, 0.2f);
            this.world.spawnEntityInWorld(e);
        }
        if (which == 2 && (e = (ThrownThunder)this.world.createEntityByName("OreSpawn:ThrownThunder", this.dimension, startx, starty, startz)) != null) {
            e.init();
            e.setBID(0);
            e.setIID(0);
            ((ThrownThunder)e).thrower = this;
            e.setAttackDamage(5.0f);
            tdiry = (float)Math.atan2(starty - victim.posy, hdist);
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 16.5f, 0.1f);
            this.world.spawnEntityInWorld(e);
        }
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }

    @Override
    public void setBaby(boolean tf) {
    }

    @Override
    public boolean isBoss() {
        return this.getOwnerName() != null && this.getOwnerName().equals(DangerZone.player.myname);
    }

    @Override
    public String getBossName() {
        return "The Prince";
    }
}

