/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.BabySitter;
import OreSpawn.entities.ChaosDemon;
import OreSpawn.entities.EntityLivingDragon;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.PowerOrb;
import OreSpawn.entities.TheKingHead;
import OreSpawn.entities.ThrownThunder;
import OreSpawn.entities.ThrownWaterball;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.TargetHelper;
import dangerzone.entities.ThrownBlockItem;
import dangerzone.entities.ThrownFireball;
import dangerzone.items.Item;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class TheKing
extends EntityLivingDragon {
    float myspeed = 0.0f;
    private int soundcount = 0;
    private int head1ext = 0;
    private int head2ext = 0;
    private int head3ext = 0;
    private int head1dir = 1;
    private int head2dir = 1;
    private int head3dir = 1;
    public TheKingHead myhead = null;
    int backoffmode = 0;
    int backoffcounter = 0;
    Entity runfrom = null;

    public TheKing(World w) {
        super(w);
        this.maxrenderdist = 380;
        this.uniquename = "OreSpawn:TheKing";
        if (w != null) {
            this.myspeed = 1.75f + this.world.rand.nextFloat() * 0.3f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = true;
        this.canBreateUnderWater = true;
        this.setExperience(20000);
        this.height = 24.75f;
        this.width = 22.75f;
        this.setMaxHealth(8000.0f);
        this.setHealth(8000.0f);
        this.setDefense(8.5f);
        this.setAttackDamage(320.0f);
        this.searchDistance = 120.0f;
        this.attackRange = 20.0f;
        this.isImmuneToFire = true;
        this.setCanDespawn(false);
        this.ignoreCollisions = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = false;
        this.canFly = true;
        if (w != null) {
            this.backoffcounter = 50 + w.rand.nextInt(100);
        }
        this.tower_defense_enable = false;
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (dt == 9) {
            return;
        }
        if (dt == 10) {
            return;
        }
        if (dt == 12) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
        if (this.hurtMe != null && this.hurtMe instanceof EntityLivingDragon) {
            this.hurtMe = null;
        }
        this.searchcounter = 10;
    }

    public void setGuardMode() {
        this.setVarInt(21, (int)this.posx);
        this.setVarInt(22, (int)this.posz);
        this.setBID(1);
    }

    public void setUltimateMode() {
        this.setIID(1);
        this.setMaxHealth(10000.0f);
        this.setHealth(10000.0f);
        this.setDefense(4.5f);
        this.setAttackDamage(300.0f);
        this.setExperience(50000);
    }

    @Override
    public void doEntityAction(float deltaT) {
        Entity e;
        if (this.world.rand.nextInt(10) == 1) {
            this.heal(5.0f);
        }
        if (this.getIID() != 0) {
            this.heal(1.0f);
        }
        int endCounter = this.getVarInt(22);
        if (this.getBID() != 1 && endCounter < 265) {
            this.setVarInt(22, endCounter + 1);
            if (endCounter == 5) {
                DangerZone.server.sendChatToAll("The King: Enough of this charade. I am done. You have shown me what I wanted to know.");
            }
            if (endCounter == 40) {
                DangerZone.server.sendChatToAll("The King: That's right my little pet. It has all been a game. You never killed me. You can't.");
            }
            if (endCounter == 80) {
                DangerZone.server.sendChatToAll("The King: I am the one. The only. The many. I exist within both space and time. Everywhere and always.");
            }
            if (endCounter == 120) {
                DangerZone.server.sendChatToAll("The King: I used you to learn your ways, and I have reached my conclusion on your species.");
            }
            if (endCounter == 150) {
                DangerZone.server.sendChatToAll("The King: You have 10 seconds to run...");
            }
            if (endCounter == 160) {
                DangerZone.server.sendChatToAll("9.");
            }
            if (endCounter == 170) {
                DangerZone.server.sendChatToAll("8.");
            }
            if (endCounter == 180) {
                DangerZone.server.sendChatToAll("7.");
            }
            if (endCounter == 190) {
                DangerZone.server.sendChatToAll("6.");
            }
            if (endCounter == 200) {
                DangerZone.server.sendChatToAll("5.");
            }
            if (endCounter == 210) {
                DangerZone.server.sendChatToAll("4.");
            }
            if (endCounter == 220) {
                DangerZone.server.sendChatToAll("3.");
            }
            if (endCounter == 230) {
                DangerZone.server.sendChatToAll("2.");
            }
            if (endCounter == 240) {
                DangerZone.server.sendChatToAll("1.");
            }
            if (endCounter == 250) {
                DangerZone.server.sendChatToAll("The King: Prepare to die!");
            }
            this.targetentity = null;
            this.target = null;
            this.setAttacking(false);
            this.myspeed = 0.0f;
            Player looktarget = DangerZone.server.findNearestPlayer(this);
            if (looktarget != null) {
                if (this.target == null) {
                    this.target = new TargetHelper(this.posx, this.posy, this.posz);
                }
                this.target.setTarget(looktarget.posx, looktarget.posy, looktarget.posz);
            }
        } else if (this.myspeed < 1.0f) {
            this.myspeed = 1.75f + this.world.rand.nextFloat() * 0.3f;
        }
        boolean found = false;
        List<Entity> nearby_list = null;
        this.runfrom = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(50.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (e instanceof TheKingHead) {
                    found = true;
                    this.myhead = (TheKingHead)e;
                }
                if (e instanceof ChaosDemon) {
                    this.runfrom = e;
                }
                if (!(e instanceof BabySitter)) continue;
                this.runfrom = e;
            }
        }
        if (!found && (e = this.world.createEntityByName("OreSpawn:TheKingHead", this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f)), this.posy + 15.0, this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f)))) != null) {
            e.init();
            this.world.spawnEntityInWorld(e);
            this.myhead = (TheKingHead)e;
        }
        if (this.runfrom != null) {
            this.targetentity = null;
            this.setAttacking(false);
            this.backoffmode = 1;
            this.backoffcounter = 40 + this.world.rand.nextInt(50);
            this.target = new TargetHelper(this.posx + (this.posx - this.runfrom.posx), this.posy + (this.posy - this.runfrom.posy), this.posz + (this.posz - this.runfrom.posz));
        }
        --this.backoffcounter;
        if (this.backoffcounter <= 0) {
            if (this.backoffmode == 0) {
                this.targetentity = null;
                this.target = null;
                this.setAttacking(false);
                this.backoffmode = 1;
                this.backoffcounter = 40 + this.world.rand.nextInt(50);
            } else {
                this.backoffmode = 0;
                this.backoffcounter = 50 + this.world.rand.nextInt(100);
            }
        }
        if (this.backoffmode == 0 && endCounter >= 260) {
            ++this.searchcounter;
            if (this.searchcounter >= 10) {
                this.searchcounter = this.world.rand.nextInt(4);
                if (this.hurtMe != null && this.hurtMe.deadflag) {
                    this.hurtMe = null;
                }
                if (this.hurtMe != null && this.hurtMe.posy > 300.0) {
                    this.hurtMe = null;
                }
                if (this.world.rand.nextInt(20) == 1) {
                    this.hurtMe = null;
                }
                this.targetentity = this.hurtMe;
                if (this.targetentity == null) {
                    this.targetentity = this.findSomethingToAttack();
                }
                if (this.getIID() != 0) {
                    this.targetentity = DangerZone.server.findNearestPlayer(this);
                }
                if (this.targetentity != null) {
                    this.target = this.targetentity.isFlying() ? new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz) : new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                    this.setAttacking(true);
                } else {
                    this.setAttacking(false);
                }
            }
            if (this.targetentity != null && this.world.rand.nextInt(4) == 1) {
                double cdir = Math.toRadians(this.rotation_yaw);
                double tdir = Math.atan2(this.targetentity.posx - this.posx, this.targetentity.posz - this.posz);
                double ddiff = tdir - cdir;
                while (ddiff > Math.PI) {
                    ddiff -= Math.PI * 2;
                }
                while (ddiff < -Math.PI) {
                    ddiff += Math.PI * 2;
                }
                if (Math.abs(ddiff) < 1.0471975511965976) {
                    if (this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                        float dmg = this.getAttackDamage();
                        int dt = 4;
                        if (this.getIID() != 0) {
                            this.targetentity.setHealth(this.targetentity.getHealth() * 9.0f / 10.0f);
                        }
                        this.targetentity.doAttackFrom(this, dt, dmg);
                    } else {
                        this.do_a_distance_attack(this.targetentity);
                    }
                }
            }
        }
        ++this.soundcount;
        if (this.soundcount > 18) {
            this.soundcount = 0;
            int which = this.world.rand.nextInt(3);
            if (which == 0) {
                this.world.playSound("OreSpawn:MothraWings1", this.dimension, this.posx, this.posy, this.posz, this.getLivingSoundVolume(), 1.0f);
            }
            if (which == 1) {
                this.world.playSound("OreSpawn:MothraWings2", this.dimension, this.posx, this.posy, this.posz, this.getLivingSoundVolume(), 1.0f);
            }
            if (which == 2) {
                this.world.playSound("OreSpawn:MothraWings3", this.dimension, this.posx, this.posy, this.posz, this.getLivingSoundVolume(), 1.0f);
            }
        }
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        double px = this.posx;
        double pz = this.posz;
        if (this.getBID() != 0) {
            px = this.getVarInt(21);
            pz = this.getVarInt(22);
        }
        if ((this.world.rand.nextInt(300) == 0 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 8.0) && endCounter > 265) {
            int down = 0;
            int i = -5;
            while (i <= 5) {
                int j = -5;
                while (j <= 5) {
                    int k = -20;
                    while (k <= 20) {
                        int bid = this.world.getblock(this.dimension, (int)this.posx + j, (int)(this.posy + (double)k) - 15, (int)this.posz + i);
                        down = bid != 0 ? ++down : --down;
                        k += 2;
                    }
                    j += 5;
                }
                i += 5;
            }
            if (down > 15) {
                down = 15;
            }
            if (down < -15) {
                down = -15;
            }
            int xdir = 1;
            int zdir = 1;
            if (this.world.rand.nextBoolean()) {
                xdir = -1;
            }
            if (this.world.rand.nextBoolean()) {
                zdir = -1;
            }
            int newz = this.world.rand.nextInt(200);
            int newx = this.world.rand.nextInt(200);
            this.target.setTarget(px + (double)(newx *= xdir), (int)this.posy + this.world.rand.nextInt(7) - 3 + down / 2, pz + (double)(newz *= zdir));
            this.myspeed = 1.75f + this.world.rand.nextFloat() * 0.75f;
        }
        if (this.target.targety > 250.0) {
            this.target.targety = 200.0;
        }
        if (this.target.targety < 0.0) {
            this.target.targety = 50.0;
        }
        double dy = this.target.targety - this.posy;
        if ((dy /= 10.0) > (double)0.2f) {
            dy = 0.2f;
        }
        if (dy < (double)-0.2f) {
            dy = -0.2f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        if (endCounter < 250) {
            this.motiony = 0.0f;
        }
        double cdir = Math.toRadians(this.rotation_yaw);
        double tdir = Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        double ddiff = tdir - cdir;
        while (ddiff > Math.PI) {
            ddiff -= Math.PI * 2;
        }
        while (ddiff < -Math.PI) {
            ddiff += Math.PI * 2;
        }
        this.rotation_yaw_motion = (float)(ddiff * 180.0 / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        float spd = (float)Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
        if (spd > this.myspeed) {
            this.motionx *= this.myspeed / spd;
            this.motionz *= this.myspeed / spd;
        }
        if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof EntityLivingDragon) {
            return false;
        }
        if (e instanceof ChaosDemon) {
            return false;
        }
        if (e instanceof BabySitter) {
            return false;
        }
        if (this.getBID() != 0 && e.getHorizontalDistanceFromEntity(this.getVarInt(21), this.getVarInt(22)) > 256.0) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Girlfriend && this.CanProbablySeeEntity(e);
    }

    @Override
    public void doDeathDrops() {
        int howmany = 225;
        int i = 0;
        while (i < howmany) {
            int iid = this.world.rand.nextInt(2048);
            Item it = Items.getItem(iid);
            if (it == null || !it.showInInventory) continue;
            iid = it.itemID;
            ++i;
            Utils.doDropRand(this.world, 0, iid, 20.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        i = 0;
        while (i < howmany) {
            int bid = this.world.rand.nextInt(2048);
            Block bl = Blocks.getBlock(bid);
            if (bl == null || !bl.showInInventory) continue;
            bid = bl.blockID;
            ++i;
            Utils.doDropRand(this.world, bid, 0, 20.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Entity e = this.world.createEntityByName("OreSpawn:ThePrince", this.dimension, this.posx, this.posy, this.posz);
        if (e != null) {
            e.init();
            this.world.spawnEntityInWorld(e);
        }
        Utils.doDropRand(this.world, 0, OreSpawnMain.royalboots.itemID, 19.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, OreSpawnMain.royalhelmet.itemID, 19.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, OreSpawnMain.royalchestplate.itemID, 19.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, OreSpawnMain.royalleggings.itemID, 19.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, OreSpawnMain.royalsword.itemID, 19.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, OreSpawnMain.trophytheking.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/TheKingtexture.png");
        }
        return this.texture;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:king_hit";
    }

    @Override
    public String getDeathSound() {
        int which = this.world.rand.nextInt(3);
        if (which == 0) {
            return "DangerZone:large_explosion1";
        }
        if (which == 1) {
            return "DangerZone:large_explosion2";
        }
        return "DangerZone:large_explosion3";
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(5) != 1) {
            return null;
        }
        return "OreSpawn:king_living";
    }

    public int getHead1Ext() {
        return this.head1ext;
    }

    public int getHead2Ext() {
        return this.head2ext;
    }

    public int getHead3Ext() {
        return this.head3ext;
    }

    @Override
    public void update(float deltaT) {
        if (!this.world.isServer) {
            int i;
            int howoften = 10;
            int howfar = 2;
            if (this.getAttacking()) {
                howoften = 5;
                howfar = 3;
            }
            if (this.world.rand.nextInt(howoften) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head1dir = howfar;
                }
                if (i == 1) {
                    this.head1dir = -howfar;
                }
                if (i == 2) {
                    this.head1dir = 0;
                }
            }
            if (this.world.rand.nextInt(howoften) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head2dir = howfar;
                }
                if (i == 1) {
                    this.head2dir = -howfar;
                }
                if (i == 2) {
                    this.head2dir = 0;
                }
            }
            if (this.world.rand.nextInt(howoften) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head3dir = howfar;
                }
                if (i == 1) {
                    this.head3dir = -howfar;
                }
                if (i == 2) {
                    this.head3dir = 0;
                }
            }
            this.head1ext += this.head1dir;
            if (this.head1ext < 0) {
                this.head1ext = 0;
            }
            if (this.head1ext > 60) {
                this.head1ext = 60;
            }
            this.head2ext += this.head2dir;
            if (this.head2ext < 0) {
                this.head2ext = 0;
            }
            if (this.head2ext > 60) {
                this.head2ext = 60;
            }
            this.head3ext += this.head3dir;
            if (this.head3ext < 0) {
                this.head3ext = 0;
            }
            if (this.head3ext > 60) {
                this.head3ext = 60;
            }
        }
        super.update(deltaT);
    }

    private void do_a_distance_attack(Entity victim) {
        Entity e;
        int i;
        int howmany;
        double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f));
        double starty = this.posy + (double)this.getHeight();
        double startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f));
        float hdist = (float)Math.sqrt((victim.posx - startx) * (victim.posx - startx) + (victim.posz - startz) * (victim.posz - startz));
        float tdirxz = (float)Math.atan2(victim.posx - startx, victim.posz - startz);
        float tdiry = (float)Math.atan2(starty - (victim.posy + (double)(victim.getHeight() / 2.0f)), hdist);
        int which = this.world.rand.nextInt(3);
        if (which == 0) {
            howmany = 3 + this.world.rand.nextInt(10);
            i = 0;
            while (i < howmany) {
                e = (ThrownFireball)this.world.createEntityByName("DangerZone:ThrownFireball", this.dimension, startx, starty, startz);
                if (e != null) {
                    e.init();
                    e.setBID(0);
                    e.setIID(Items.fireball.itemID);
                    ((ThrownFireball)e).thrower = this;
                    ((ThrownFireball)e).thrower2 = this.myhead;
                    ((ThrownFireball)e).explosive_power = 5.0f;
                    ((ThrownBlockItem)e).setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 9.5f, 0.2f);
                    this.world.spawnEntityInWorld(e);
                }
                ++i;
            }
        }
        if (which == 1) {
            howmany = 8 + this.world.rand.nextInt(12);
            i = 0;
            while (i < howmany) {
                e = (ThrownWaterball)this.world.createEntityByName("OreSpawn:ThrownWaterball", this.dimension, startx, starty, startz);
                if (e != null) {
                    e.init();
                    e.setBID(0);
                    e.setIID(OreSpawnMain.waterball.itemID);
                    ((ThrownWaterball)e).thrower = this;
                    ((ThrownWaterball)e).thrower2 = this.myhead;
                    e.setAttackDamage(30.0f);
                    ((ThrownBlockItem)e).setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 9.5f, 0.2f);
                    this.world.spawnEntityInWorld(e);
                }
                ++i;
            }
        }
        if (which == 2) {
            howmany = 3 + this.world.rand.nextInt(5);
            i = 0;
            while (i < howmany) {
                e = (ThrownThunder)this.world.createEntityByName("OreSpawn:ThrownThunder", this.dimension, startx, starty, startz);
                if (e != null) {
                    e.init();
                    e.setBID(0);
                    e.setIID(0);
                    ((ThrownThunder)e).thrower = this;
                    ((ThrownThunder)e).thrower2 = this.myhead;
                    e.setAttackDamage(25.0f);
                    tdiry = (float)Math.atan2(starty - victim.posy, hdist);
                    ((ThrownBlockItem)e).setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 16.5f, 0.1f);
                    this.world.spawnEntityInWorld(e);
                }
                ++i;
            }
        }
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        if (this.getIID() != 0) {
            howmany = 2 + this.world.rand.nextInt(5);
            i = 0;
            while (i < howmany) {
                e = (PowerOrb)this.world.createEntityByName("OreSpawn:PowerOrb", this.dimension, startx, starty, startz);
                if (e != null) {
                    ((PowerOrb)e).init();
                    e.setBID(0);
                    ((PowerOrb)e).rider = this;
                    if (i == 0) {
                        ((PowerOrb)e).hurtMe = victim;
                    }
                    this.world.spawnEntityInWorld(e);
                }
                ++i;
            }
        }
    }

    @Override
    public void setBaby(boolean tf) {
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    public String getBossName() {
        return "The King!";
    }
}

