/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Bee;
import OreSpawn.entities.Bird;
import OreSpawn.entities.CliffRacer;
import OreSpawn.entities.CloudShark;
import OreSpawn.entities.CreepingHorror;
import OreSpawn.entities.EmperorScorpion;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.GoldFish;
import OreSpawn.entities.LurkingTerror;
import OreSpawn.entities.Mantis;
import OreSpawn.entities.Mothra;
import OreSpawn.entities.Nightmare;
import OreSpawn.entities.Rotator;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Butterfly;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Flag;
import dangerzone.entities.RenderInfo;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class TerribleTerror
extends EntityLiving {
    float myspeed = 0.0f;
    public float attackRange = 1.5f;
    public int searchcounter = 0;
    public Entity hurtMe = null;
    public Entity targetentity = null;
    public RenderInfo renderdata = new RenderInfo();

    public TerribleTerror(World w) {
        super(w);
        this.maxrenderdist = 100;
        this.uniquename = "OreSpawn:TerribleTerror";
        if (w != null) {
            this.myspeed = 0.33f + this.world.rand.nextFloat() * 0.22f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = false;
        this.setExperience(35);
        this.height = 0.85f;
        this.width = 0.95f;
        this.setMaxHealth(30.0f);
        this.setHealth(30.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(10.0f);
        this.searchDistance = 30.0f;
        this.attackRange = 2.5f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.canFly = true;
        this.setFlying(true);
        this.tower_defense_enable = true;
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(8) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom(this, dt, dmg);
        }
        if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        int keep_trying = 25;
        this.do_swarm_despawn();
        int bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
        if (bid == 0 && this.wouldBump(this.posx + (double)(this.motionx * deltaT), this.posy + (double)(this.motiony * deltaT) + (double)(this.getHeight() / 2.0f), this.posz + (double)(this.motionz * deltaT), this.getWidth())) {
            bid = 1;
        }
        if (bid != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
            int updown = 5;
            int k = 1;
            while (k < 10) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - k, (int)this.posz);
                if (bid != 0) {
                    updown = -1;
                    break;
                }
                ++k;
            }
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                if (this.isSwarming()) {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(20), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(20));
                } else {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(20) - (double)this.world.rand.nextInt(20), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(20) - (double)this.world.rand.nextInt(20));
                }
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                if (bid == 0 && !this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((this.posx - this.target.targetx) * (this.posx - this.target.targetx) + (this.posz - this.target.targetz) * (this.posz - this.target.targetz) + (this.posy - this.target.targety) * (this.posy - this.target.targety)))) {
                    bid = 1;
                }
                --keep_trying;
                this.myspeed = 0.32f + this.world.rand.nextFloat() * 0.22f;
            }
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
            this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
        }
        float dy = (float)(this.target.targety - this.posy);
        this.motiony += 0.12f * deltaT;
        if ((dy /= 20.0f) > 0.2f) {
            dy = 0.2f;
        }
        if (dy < -0.2f) {
            dy = -0.2f;
        }
        this.motiony += dy;
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        Utils.SpawnDustAlongPath(this);
    }

    @Override
    public void onKill(Entity e) {
        this.heal(1.0f);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Nightmare) {
            return false;
        }
        if (e instanceof CreepingHorror) {
            return false;
        }
        if (e instanceof TerribleTerror) {
            return false;
        }
        if (e instanceof EmperorScorpion && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof CloudShark && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof LurkingTerror && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Rotator && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Bee && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Mantis && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Mothra && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (!this.CanProbablySeeEntity(e)) {
            return false;
        }
        if (e instanceof Bird) {
            return true;
        }
        if (e instanceof Butterfly) {
            return true;
        }
        if (e instanceof GoldFish) {
            return true;
        }
        if (e instanceof CliffRacer) {
            return true;
        }
        if (e instanceof Girlfriend) {
            return true;
        }
        if (e instanceof Player) {
            return true;
        }
        return e instanceof Flag;
    }

    @Override
    public void doDeathDrops() {
        int howmany = 2 + this.world.rand.nextInt(3);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.deadbug.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyterribleterror.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/TerribleTerrortexture.png");
        }
        return this.texture;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:terribleterror_hit";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:terribleterror_dead";
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(2) != 1) {
            return null;
        }
        return "OreSpawn:terribleterror_living";
    }
}

