/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.Dimensions;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class Termite
extends EntityLiving {
    public Termite(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.25f;
        this.width = 0.25f;
        this.uniquename = "OreSpawn:Termite";
        this.moveSpeed = 0.15f;
        this.setMaxHealth(1.0f);
        this.setHealth(1.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(0.15f);
        this.movefrequency = 25;
        this.setExperience(1);
        this.canSwim = false;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 10;
        this.foodblockdistxz = 9;
        this.foodblockdisty = 2;
        this.foodblockheal = 1;
        this.foodblockdisteat = 4;
        this.fooddaytimeonly = false;
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(1000) == 1 && this.getCanDespawn()) {
            this.deadflag = true;
        }
        super.update(deltaT);
    }

    @Override
    public boolean isFoodBlock(int bid) {
        if (bid == Blocks.plywood.blockID) {
            return true;
        }
        if (bid == Blocks.lightplywood.blockID) {
            return true;
        }
        if (bid == Blocks.darkplywood.blockID) {
            return true;
        }
        if (bid == Blocks.doortop.blockID) {
            return true;
        }
        return bid == Blocks.doorbottom.blockID;
    }

    @Override
    public void doEatFoodAction(int d, int x, int y, int z) {
        Entity enew;
        int tc = 0;
        List<Entity> nearby_list = null;
        if (this.world.rand.nextBoolean()) {
            this.world.setblockandmetaWithPerm(this, d, x, y, z, 0, 0);
        } else {
            this.world.setblockandmetaWithPerm(this, d, x, y, z, Blocks.dirt.blockID, 0);
        }
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(8.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!(e instanceof Termite)) continue;
                ++tc;
            }
        }
        if (tc < 25 && (enew = this.world.createEntityByName(this.uniquename, this.dimension, this.posx, this.posy, this.posz)) != null) {
            enew.init();
            this.world.spawnEntityInWorld(enew);
        }
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (ic != null && ic.count != 0) {
            return false;
        }
        if (p == null) {
            return false;
        }
        if (this.world.isServer && p != null) {
            int id = p.dimension;
            if (id == OreSpawnMain.crystaldimension.dimensionID) {
                id = Dimensions.overworlddimension.dimensionID;
            } else {
                int i = 0;
                while (i < 64) {
                    if (p.entity_inventory[i] != null && p.entity_inventory[i].count != 0) {
                        return false;
                    }
                    ++i;
                }
                id = OreSpawnMain.crystaldimension.dimensionID;
            }
            Utils.doTeleport(p, id, p.posx, p.posy, p.posz);
            this.world.playSound("DangerZone:big_splat", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
            this.world.playSound("DangerZone:big_splat", id, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
            Utils.spawnParticlesFromServer(p.world, "DangerZone:ParticleHurt", 10, this.dimension, this.posx, this.posy, this.posz);
            Utils.spawnParticlesFromServer(p.world, "DangerZone:ParticleHurt", 10, id, this.posx, this.posy, this.posz);
        }
        return false;
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophytermite.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.deadbug.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/termite.png");
        }
        return this.texture;
    }
}

