/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Effects;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class StinkBug
extends EntityLiving {
    public StinkBug(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 0.75f;
        this.width = 0.8f;
        this.uniquename = "OreSpawn:StinkBug";
        this.moveSpeed = 0.16f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 30;
        this.setExperience(5);
        this.canSwim = false;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 6;
        this.canridemaglevcart = true;
    }

    @Override
    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.enable_buddy_nearest = this.isBaby();
        super.doEntityAction(deltaT);
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof StinkBug && !e.isBaby();
    }

    @Override
    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == Items.corn.itemID) {
            return true;
        }
        return iid == OreSpawnMain.crystalapple.itemID;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:duck_hurt";
    }

    @Override
    public void onDeath() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(12.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.TargetSorter);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!(e instanceof EntityLiving) || e == this) continue;
                Effects ef = new Effects(6, 0.01f, 50);
                e.addEffectFromServer(ef);
                ef = new Effects(7, 2.0f, 150);
                e.addEffectFromServer(ef);
            }
        }
    }

    @Override
    public String getDeathSound() {
        int i = this.world.rand.nextInt(9);
        if (i == 0) {
            return "OreSpawn:fart1";
        }
        if (i == 1) {
            return "OreSpawn:fart2";
        }
        if (i == 2) {
            return "OreSpawn:fart3";
        }
        if (i == 3) {
            return "OreSpawn:fart4";
        }
        if (i == 4) {
            return "OreSpawn:fart5";
        }
        if (i == 5) {
            return "OreSpawn:fart6";
        }
        if (i == 6) {
            return "OreSpawn:fart7";
        }
        if (i == 7) {
            return "OreSpawn:fart8";
        }
        return "OreSpawn:fart9";
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, 0, OreSpawnMain.deadstinkbug.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophystinkbug.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/StinkBugtexture.png");
        }
        return this.texture;
    }
}

