/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Utils;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Snail
extends EntityLiving {
    public Snail(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 0.85f;
        this.width = 0.55f;
        this.uniquename = "OreSpawn:Snail";
        this.moveSpeed = 0.015f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(4.0f);
        this.setAttackDamage(1.0f);
        this.attackRange = 1.0f;
        this.movefrequency = 65;
        this.setExperience(5);
        this.setCanDespawn(false);
        this.canSwim = true;
        this.enableTaming(14);
        this.enableFollowHeldFood(14);
        this.enableDroppedFood(14);
        this.canridemaglevcart = true;
    }

    @Override
    public boolean isFoodItem(int foodid) {
        if (foodid == Items.corn.itemID) {
            return true;
        }
        if (foodid == Items.apple.itemID) {
            return true;
        }
        return foodid == Items.peach.itemID;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophysnail.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Snailtexture.png");
        }
        return this.texture;
    }
}

