/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Effects;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Skunk
extends EntityLiving {
    public Skunk(World w) {
        super(w);
        this.maxrenderdist = 90;
        this.height = 0.65f;
        this.width = 0.75f;
        this.uniquename = "OreSpawn:Skunk";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(15.0f);
        this.setHealth(15.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(1.0f);
        this.movefrequency = 40;
        this.setExperience(15);
        this.canSwim = true;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.searchDistance = 10.0f;
        this.attackRange = 1.5f;
        this.temperament = 1;
        this.enable_hostile = true;
    }

    @Override
    public void doDistanceAttack(Entity victim) {
        if (this.world.rand.nextInt(3) == 1) {
            return;
        }
        Effects ef = new Effects(7, 2.0f, 150);
        victim.addEffectFromServer(ef);
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:goose_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, 0, Items.ostrichmeat.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.furball.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyskunk.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Skunk) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Skunktexture.png");
        }
        return this.texture;
    }
}

