/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Skate
extends EntityLiving {
    public Skate(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.35f;
        this.width = 0.75f;
        this.uniquename = "OreSpawn:Skate";
        this.moveSpeed = 0.27f;
        this.setMaxHealth(5.0f);
        this.setHealth(5.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(2.0f);
        this.movefrequency = 25;
        this.setExperience(5);
        this.canSwim = true;
        this.swimoffset = -0.25f;
        this.takesFallDamage = true;
        this.canBreateUnderWater = true;
        this.searchDistance = 16.0f;
        this.attackRange = 1.5f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 5;
        this.foodblockdistxz = 16;
        this.foodblockdisty = 5;
        this.foodblockheal = 0;
        this.foodblockdisteat = 0;
        this.fooddaytimeonly = false;
        this.targetLiquidOnly = true;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public String getDeathSound() {
        int i = this.world.rand.nextInt(3);
        if (i == 0) {
            return "DangerZone:ratdead1";
        }
        if (i == 1) {
            return "DangerZone:ratdead2";
        }
        return "DangerZone:ratdead3";
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyskate.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, Blocks.stickyblock.blockID, 0, 1.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        this.enable_findfoodblock = !this.getInLiquid();
        if (this.getInLiquid()) {
            Utils.SpawnBubblesAlongPath(this);
        }
    }

    @Override
    public boolean isFoodBlock(int bid) {
        return bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID;
    }

    @Override
    public void doEatFoodAction(int d, int x, int y, int z) {
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Skatetexture.png");
        }
        return this.texture;
    }
}

