/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class SeaTurtle
extends EntityLiving {
    public SeaTurtle(World w) {
        super(w);
        this.maxrenderdist = 160;
        this.height = 0.55f;
        this.width = 1.25f;
        this.uniquename = "OreSpawn:Sea Turtle";
        this.moveSpeed = 0.245f;
        this.setMaxHealth(20.0f);
        this.setHealth(20.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 25;
        this.setExperience(10);
        this.canSwim = true;
        this.takesFallDamage = true;
        this.canBreateUnderWater = true;
        this.targetLiquidOnly = true;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 5;
        this.foodblockdistxz = 16;
        this.foodblockdisty = 5;
        this.foodblockheal = 0;
        this.foodblockdisteat = 0;
        this.fooddaytimeonly = false;
    }

    @Override
    public boolean isFoodBlock(int bid) {
        return bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID;
    }

    @Override
    public void doEatFoodAction(int d, int x, int y, int z) {
    }

    @Override
    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        if (this.getInLiquid()) {
            Utils.SpawnBubblesAlongPath(this);
        }
        this.enable_findfoodblock = !this.getInLiquid();
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "DangerZone:little_splash";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyseaturtle.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        int howmany = 1 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.fishmeat.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/SeaTurtletexture.png");
        }
        return this.texture;
    }
}

