/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Fish;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Platypus
extends EntityLiving {
    public Platypus(World w) {
        super(w);
        this.maxrenderdist = 100;
        this.height = 0.75f;
        this.width = 0.55f;
        this.uniquename = "OreSpawn:Platypus";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(2.0f);
        this.movefrequency = 65;
        this.setExperience(5);
        this.canSwim = true;
        this.enableHostility(14.0f, 2.5f);
        this.temperament = 2;
        this.enableTaming(14);
        this.enableFollowHeldFood(12);
        this.enableDroppedFood(12);
    }

    @Override
    public boolean isFoodItem(int foodid) {
        return foodid == Items.fishmeat.itemID;
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (!(e instanceof Fish)) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyplatypus.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Platypustexture.png");
        }
        return this.texture;
    }
}

