/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Peacock
extends EntityLiving {
    public boolean blinkstate = false;
    public Texture texture2 = null;

    public Peacock(World w) {
        super(w);
        this.maxrenderdist = 130;
        this.height = 1.9f;
        this.width = 0.8f;
        this.uniquename = "OreSpawn:Peacock";
        this.moveSpeed = 0.95f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 30;
        this.setExperience(5);
        this.canSwim = true;
        this.enable_avoid = true;
        this.avoiddistance = 32;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 6;
        this.canridemaglevcart = true;
        this.takesFallDamage = false;
    }

    @Override
    public void init() {
        if (this.getBID() == 0 && this.world != null && this.world.isServer) {
            this.setBID(1);
            if (this.world.rand.nextInt(100) == 1) {
                this.setBID(2);
            }
        }
        super.init();
    }

    @Override
    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.isBaby();
        super.doEntityAction(deltaT);
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof Peacock;
    }

    @Override
    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == Items.corn.itemID) {
            return true;
        }
        return iid == OreSpawnMain.crystalapple.itemID;
    }

    @Override
    public boolean shouldAvoidEntity(Entity e) {
        return e instanceof Player;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(4) != 2) {
            return null;
        }
        return "OreSpawn:peacock_living";
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:peacock_hit";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:peacock_dead";
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(5000) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.eggpeacock.itemID, 0.1f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.update(deltaT);
    }

    public boolean getBlink() {
        if (this.blinkstate) {
            if (DangerZone.rand.nextInt(60) == 1) {
                this.blinkstate = false;
            }
        } else if (DangerZone.rand.nextInt(180) == 1) {
            this.blinkstate = true;
        }
        return this.blinkstate;
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, 0, OreSpawnMain.peacockmeat.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
        int howmany = 2 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.peacockfeather.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophypeacock.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.getBID() == 2) {
            howmany = 40 + this.world.rand.nextInt(10);
            i = 0;
            while (i < howmany) {
                Utils.doDropRand(this.world, 0, Items.coingold.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
                ++i;
            }
            howmany = 20 + this.world.rand.nextInt(8);
            i = 0;
            while (i < howmany) {
                Utils.doDropRand(this.world, 0, OreSpawnMain.egggoldcow.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
                ++i;
            }
            howmany = 20 + this.world.rand.nextInt(8);
            i = 0;
            while (i < howmany) {
                Utils.doDropRand(this.world, 0, OreSpawnMain.yellowapple.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
                ++i;
            }
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Peacocktexture.png");
            this.texture2 = TextureMapper.getTexture("orespawnres/skins/PeacockGoldentexture.png");
        }
        if (this.getBID() == 2) {
            return this.texture2;
        }
        return this.texture;
    }
}

