/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.LavaLizard;
import OreSpawn.entities.LazerLizard;
import OreSpawn.entities.LightningLizard;
import OreSpawn.entities.Lizard;
import OreSpawn.entities.Nastysaurus;
import OreSpawn.entities.Needlenose;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.RenderInfo;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class NastysaurusPrime
extends EntityLiving {
    public RenderInfo renderdata = new RenderInfo();

    public NastysaurusPrime(World w) {
        super(w);
        this.maxrenderdist = 220;
        this.height = 4.95f;
        this.width = 2.55f;
        this.uniquename = "OreSpawn:Nastysaurus Prime";
        this.moveSpeed = 0.36f;
        this.setMaxHealth(800.0f);
        this.setHealth(800.0f);
        this.setDefense(3.5f);
        this.setAttackDamage(85.0f);
        this.searchDistance = 30.0f;
        this.attackRange = 5.0f;
        this.movefrequency = 65;
        this.setExperience(699);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    @Override
    public void doAttack(Entity victim) {
        super.doAttack(victim);
        if (this.world.rand.nextInt(3) == 1) {
            this.doDistanceAttack(victim);
        }
    }

    @Override
    public void doDistanceAttack(Entity victim) {
        if (this.world.rand.nextInt(3) != 1) {
            return;
        }
        double px = (this.posx + victim.posx) / 2.0;
        double py = (this.posy + victim.posy) / 2.0;
        double pz = (this.posz + victim.posz) / 2.0;
        px += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 5.0f);
        pz += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 5.0f);
        int i = -5;
        while (i <= 5) {
            Needlenose sc;
            int bid = this.world.getblock(this.dimension, (int)px, (int)py + i, (int)pz);
            if (bid == 0 && (bid = this.world.getblock(this.dimension, (int)px, (int)py + i - 1, (int)pz)) != 0 && Blocks.isSolid(bid) && (sc = (Needlenose)this.world.createEntityByName("OreSpawn:Needlenose", this.dimension, px, py + (double)i, pz)) != null) {
                sc.init();
                sc.hurtMe = victim;
                this.world.spawnEntityInWorld(sc);
                break;
            }
            ++i;
        }
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "OreSpawn:alo_living";
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 7 + this.world.rand.nextInt(9);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 6.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 6 + this.world.rand.nextInt(15);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.bloodstone.itemID, 6.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophynastysaurusprime.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Nastysaurus) {
            return false;
        }
        if (e instanceof NastysaurusPrime) {
            return false;
        }
        if (e instanceof Needlenose) {
            return false;
        }
        if (e instanceof LightningLizard) {
            return false;
        }
        if (e instanceof LavaLizard) {
            return false;
        }
        if (e instanceof LazerLizard) {
            return false;
        }
        if (e instanceof Lizard) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/NastysaurusPrimetexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isBoss() {
        return true;
    }
}

