/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Molenoid
extends EntityLiving {
    public Molenoid(World w) {
        super(w);
        this.maxrenderdist = 180;
        this.height = 2.33f;
        this.width = 3.75f;
        this.uniquename = "OreSpawn:Molenoid";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(200.0f);
        this.setHealth(200.0f);
        this.setDefense(2.0f);
        this.setAttackDamage(20.0f);
        this.searchDistance = 25.0f;
        this.attackRange = 4.0f;
        this.movefrequency = 45;
        this.setExperience(199);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    @Override
    public String getLivingSound() {
        int which = this.world.rand.nextInt(3);
        if (which == 0) {
            return "OreSpawn:molenoid_living1";
        }
        if (which == 1) {
            return "OreSpawn:molenoid_living2";
        }
        return "OreSpawn:molenoid_living3";
    }

    @Override
    public String getHurtSound() {
        int which = this.world.rand.nextInt(6);
        if (which == 0) {
            return "OreSpawn:molenoid_hit1";
        }
        if (which == 1) {
            return "OreSpawn:molenoid_hit2";
        }
        if (which == 2) {
            return "OreSpawn:molenoid_hit3";
        }
        if (which == 3) {
            return "OreSpawn:molenoid_hit4";
        }
        if (which == 4) {
            return "OreSpawn:molenoid_hit5";
        }
        return "OreSpawn:molenoid_hit6";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:molenoid_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(6) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophymolenoid.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, OreSpawnMain.molenoidnose.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Molenoid) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public void doAttack(Entity victim) {
        int m = 0;
        while (m < 5) {
            int px = (int)victim.posx + (this.world.rand.nextInt(3) - this.world.rand.nextInt(3));
            int py = (int)victim.posy;
            int pz = (int)victim.posz + (this.world.rand.nextInt(3) - this.world.rand.nextInt(3));
            int i = -5;
            while (i < 4) {
                int bid = this.world.getblock(this.dimension, px, py + i, pz);
                if (bid != 0 && (bid = this.world.getblock(this.dimension, px, py + i + 1, pz)) == 0) {
                    this.world.setblockWithPerm(this, this.dimension, px, py + i + 1, pz, OreSpawnMain.molenoiddirt.blockID);
                    break;
                }
                ++i;
            }
            ++m;
        }
        super.doAttack(victim);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Molenoidtexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean CanProbablySeeEntity(Entity e) {
        double xzoff = this.getWidth() / 2.0f;
        int nblks = (int)this.getDistanceFromEntity(e);
        if (nblks < 1) {
            return true;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(e.posx - this.posx, e.posz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        if ((double)ddiff > 2.356194490192345) {
            return false;
        }
        if ((double)ddiff < -2.356194490192345) {
            return false;
        }
        double cx = this.posx + xzoff * Math.cos(Math.toRadians(this.rotation_yaw));
        double cz = this.posz + xzoff * Math.sin(Math.toRadians(this.rotation_yaw));
        double startx = cx;
        double starty = this.posy + (double)(this.getHeight() * 7.0f / 8.0f);
        double startz = cz;
        double dx = (e.posx - startx) / (double)nblks;
        double dy = (e.posy + (double)(e.getHeight() * 7.0f / 8.0f) - starty) / (double)nblks;
        double dz = (e.posz - startz) / (double)nblks;
        if (Math.abs(dx) > 1.0) {
            dy /= Math.abs(dx);
            dz /= Math.abs(dx);
            nblks = (int)((double)nblks * Math.abs(dx));
            if (dx > 1.0) {
                dx = 1.0;
            }
            if (dx < -1.0) {
                dx = -1.0;
            }
        }
        if (Math.abs(dy) > 1.0) {
            dx /= Math.abs(dy);
            dz /= Math.abs(dy);
            nblks = (int)((double)nblks * Math.abs(dy));
            if (dy > 1.0) {
                dy = 1.0;
            }
            if (dy < -1.0) {
                dy = -1.0;
            }
        }
        if (Math.abs(dz) > 1.0) {
            dy /= Math.abs(dz);
            dx /= Math.abs(dz);
            nblks = (int)((double)nblks * Math.abs(dz));
            if (dz > 1.0) {
                dz = 1.0;
            }
            if (dz < -1.0) {
                dz = -1.0;
            }
        }
        int i = 0;
        while (i < nblks) {
            int bid = this.world.getblock(this.dimension, (int)(startx += dx), (int)(starty += dy), (int)(startz += dz));
            if (Blocks.isSolid(bid) && bid != Blocks.dirt.blockID && bid != Blocks.grassblock.blockID && bid != OreSpawnMain.molenoiddirt.blockID) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isBoss() {
        return true;
    }
}

