/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.BabySitter;
import OreSpawn.entities.ChaosDemon;
import OreSpawn.entities.ThrownThunder;
import dangerzone.DangerZone;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.RenderInfo;
import dangerzone.entities.ThrownBlockItem;
import dangerzone.entities.ThrownFireball;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class Mobzilla
extends EntityLiving {
    public RenderInfo renderdata = new RenderInfo();
    int ticker = 0;
    int jumped = 0;

    public Mobzilla(World w) {
        super(w);
        this.maxrenderdist = 340;
        this.height = 25.0f;
        this.width = 12.0f;
        this.uniquename = "OreSpawn:Mobzilla";
        this.moveSpeed = 0.31f;
        this.setMaxHealth(5000.0f);
        this.setHealth(5000.0f);
        this.setDefense(7.5f);
        this.setAttackDamage(120.0f);
        this.searchDistance = 100.0f;
        this.attackRange = 16.0f;
        this.movefrequency = 65;
        this.setExperience(3999);
        this.canSwim = true;
        this.takesFallDamage = false;
        this.isImmuneToFire = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.setCanDespawn(false);
        this.tower_defense_enable = true;
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (dt == 12) {
            return;
        }
        if (dt == 10) {
            return;
        }
        if (e instanceof Mobzilla) {
            return;
        }
        if (pain < 5.0f) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
    }

    @Override
    public void doEntityAction(float deltaT) {
        int bid;
        int j;
        int i;
        ++this.ticker;
        if (this.world.rand.nextInt(200) == 1 && this.getNearGround()) {
            this.jumpAround();
        }
        int xzrange = 12;
        if (this.getAttacking()) {
            xzrange = 16;
        }
        int k = -3 + this.ticker % 30;
        if (!DangerZone.playnicely) {
            i = -xzrange;
            while (i <= xzrange) {
                j = -xzrange;
                while (j <= xzrange) {
                    bid = this.world.getblock(this.dimension, (int)(this.posx + (double)i), (int)this.posy + k, (int)(this.posz + (double)j));
                    if (this.isCrushable(bid)) {
                        this.world.setblockWithPerm(this, this.dimension, (int)(this.posx + (double)i), (int)this.posy + k, (int)(this.posz + (double)j), 0);
                        if (this.world.rand.nextInt(15) == 0) {
                            Utils.doDropRand(this.world, bid, 0, 3.0f, this.dimension, (int)(this.posx + (double)i), (int)this.posy + k, (int)(this.posz + (double)j));
                        }
                    } else if (bid == Blocks.grassblock.blockID) {
                        this.world.setblockWithPerm(this, this.dimension, (int)(this.posx + (double)i), (int)this.posy + k, (int)(this.posz + (double)j), Blocks.dirt.blockID);
                    }
                    ++j;
                }
                ++i;
            }
        }
        double dx = this.posx - (double)((float)(16.0 * Math.sin(Math.toRadians(this.rotation_yaw))));
        double dz = this.posz - (double)((float)(16.0 * Math.cos(Math.toRadians(this.rotation_yaw))));
        k = -3 + this.ticker % 12;
        if (!DangerZone.playnicely) {
            i = -xzrange;
            while (i <= xzrange) {
                j = -xzrange;
                while (j <= xzrange) {
                    bid = this.world.getblock(this.dimension, (int)(dx + (double)i), (int)this.posy + k, (int)(dz + (double)j));
                    if (this.isCrushable(bid)) {
                        this.world.setblockWithPerm(this, this.dimension, (int)(dx + (double)i), (int)this.posy + k, (int)(dz + (double)j), 0);
                        if (this.world.rand.nextInt(15) == 0) {
                            Utils.doDropRand(this.world, bid, 0, 3.0f, this.dimension, (int)(dx + (double)i), (int)this.posy + k, (int)(dz + (double)j));
                        }
                    } else if (bid == Blocks.grassblock.blockID) {
                        this.world.setblockWithPerm(this, this.dimension, (int)(dx + (double)i), (int)this.posy + k, (int)(dz + (double)j), Blocks.dirt.blockID);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.world.rand.nextInt(12) == 1) {
            this.doJumpDamage(dx, this.posy, dz, xzrange, 45.0f, true);
        }
        if ((double)this.motiony < -0.5) {
            this.jumped = 1;
        }
        if ((double)this.motiony < -1.0) {
            this.jumped = 2;
        }
        if (this.jumped != 0 && (double)this.motiony > -0.1) {
            float df = 1.0f;
            if (this.jumped == 2) {
                df = 1.5f;
            }
            this.doJumpDamage(this.posx, this.posy, this.posz, 10.0f, 75.0f * df, false);
            this.doJumpDamage(this.posx, this.posy, this.posz, 15.0f, 37.0f * df, false);
            this.doJumpDamage(this.posx, this.posy, this.posz, 25.0f, 18.0f * df, false);
            this.jumped = 0;
            int which = this.world.rand.nextInt(5);
            if (which == 0) {
                this.world.playSound("DangerZone:small_explosion1", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 0.55f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
            if (which == 1) {
                this.world.playSound("DangerZone:small_explosion2", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 0.55f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
            if (which == 2) {
                this.world.playSound("DangerZone:small_explosion3", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 0.55f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
            if (which == 3) {
                this.world.playSound("DangerZone:small_explosion4", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 0.55f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
            if (which == 4) {
                this.world.playSound("DangerZone:small_explosion5", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 0.55f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
        }
        super.doEntityAction(deltaT);
    }

    private void doJumpDamage(double px, double py, double pz, float range, float damage, boolean tail) {
        List<Entity> critters = this.findSomethingToHit(range, px, py, pz);
        if (critters != null) {
            Entity e = null;
            ListIterator<Entity> li = critters.listIterator();
            while (li.hasNext()) {
                e = li.next();
                e.doAttackFrom(this, 0, damage);
                if (!tail) continue;
                e.addKnockback(this, 4.5f, 2.0f);
            }
        }
    }

    public List<Entity> findSomethingToHit(float range, double px, double py, double pz) {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(range, this.dimension, px, py, pz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                double dist = e.getDistanceFromEntityCenter(px, py, pz);
                if (!(dist > (double)range) && this.isSuitableTarget(e)) continue;
                li.remove();
            }
        }
        return nearby_list;
    }

    @Override
    public void doDistanceAttack(Entity victim) {
        float tdiry;
        float tdirxz;
        float hdist;
        ThrownBlockItem e;
        double startz;
        double starty;
        double startx;
        int i;
        int howmany;
        if (this.world.rand.nextInt(3) == 0) {
            howmany = 3 + this.world.rand.nextInt(8);
            i = 0;
            while (i < howmany) {
                startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * 15.0f);
                e = (ThrownFireball)this.world.createEntityByName("DangerZone:ThrownFireball", this.dimension, startx, starty = this.posy + 22.0, startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * 15.0f));
                if (e != null) {
                    e.init();
                    e.setBID(0);
                    e.setIID(Items.fireball.itemID);
                    ((ThrownFireball)e).thrower = this;
                    ((ThrownFireball)e).explosive_power = 1 + this.world.rand.nextInt(3);
                    hdist = (float)Math.sqrt((victim.posx - startx) * (victim.posx - startx) + (victim.posz - startz) * (victim.posz - startz));
                    tdirxz = (float)Math.atan2(victim.posx - startx, victim.posz - startz);
                    tdiry = (float)Math.atan2(starty - (victim.posy + (double)(victim.getHeight() / 2.0f)), hdist);
                    e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 6.5f, 0.45f);
                    this.world.spawnEntityInWorld(e);
                }
                this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                ++i;
            }
        }
        if (this.world.rand.nextInt(6) == 0) {
            howmany = 1 + this.world.rand.nextInt(5);
            i = 0;
            while (i < howmany) {
                startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * 15.0f);
                e = (ThrownThunder)this.world.createEntityByName("OreSpawn:ThrownThunder", this.dimension, startx, starty = this.posy + 22.0, startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * 15.0f));
                if (e != null) {
                    e.init();
                    e.setBID(0);
                    e.setIID(0);
                    ((ThrownThunder)e).thrower = this;
                    hdist = (float)Math.sqrt((victim.posx - startx) * (victim.posx - startx) + (victim.posz - startz) * (victim.posz - startz));
                    tdirxz = (float)Math.atan2(victim.posx - startx, victim.posz - startz);
                    tdiry = (float)Math.atan2(starty - (victim.posy + (double)(victim.getHeight() / 2.0f)), hdist);
                    e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 6.5f, 0.45f);
                    this.world.spawnEntityInWorld(e);
                }
                this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                ++i;
            }
        }
        if (this.world.rand.nextInt(8) == 0 && this.getNearGround()) {
            this.jumpAtEntity(victim);
        }
    }

    private void jumpAtEntity(Entity victim) {
        this.target = null;
        this.motiony += 1.25f + Math.abs(this.world.rand.nextFloat() * 0.75f);
        double f = this.getHorizontalDistanceFromEntity(victim) / 20.0;
        float tdir = (float)Math.atan2(victim.posx - this.posx, victim.posz - this.posz);
        this.motionx = (float)((double)this.motionx + f * Math.sin(tdir));
        this.motionz = (float)((double)this.motionz + f * Math.cos(tdir));
    }

    private boolean isCrushable(int bid) {
        if (Blocks.isLeaves(bid)) {
            return true;
        }
        if (Blocks.isWood(bid)) {
            return true;
        }
        if (Blocks.isStone(bid)) {
            return false;
        }
        if (Blocks.isLiquid(bid)) {
            return false;
        }
        if (bid == Blocks.sand.blockID) {
            return false;
        }
        if (bid == Blocks.stone.blockID) {
            return false;
        }
        if (bid == Blocks.greystone.blockID) {
            return false;
        }
        if (bid == Blocks.dirt.blockID) {
            return false;
        }
        if (bid == Blocks.grassblock.blockID) {
            return false;
        }
        if (bid == Blocks.stopblock.blockID) {
            return false;
        }
        if (bid == OreSpawnMain.crystalgrass.blockID) {
            return false;
        }
        return bid != OreSpawnMain.crystalstone.blockID;
    }

    private void jumpAround() {
        this.target = null;
        this.motiony += 1.1f + Math.abs(this.world.rand.nextFloat() * 0.75f);
        float f = 1.6f + Math.abs(this.world.rand.nextFloat() * 2.75f);
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        this.motionx = (float)((double)this.motionx + (double)f * Math.sin(cdir));
        this.motionz = (float)((double)this.motionz + (double)f * Math.cos(cdir));
    }

    private boolean getNearGround() {
        int solidcount = 0;
        int k = 0;
        while (k < 5 && solidcount < 5) {
            int j = 0;
            while (j >= -5 && solidcount < 5) {
                int bid = this.world.getblock(this.dimension, (int)(this.posx + (double)k), (int)this.posy + j, (int)(this.posz + (double)k));
                if (bid != 0 && Blocks.isSolid(bid)) {
                    ++solidcount;
                }
                if ((bid = this.world.getblock(this.dimension, (int)(this.posx - (double)k), (int)this.posy + j, (int)(this.posz + (double)k))) != 0 && Blocks.isSolid(bid)) {
                    ++solidcount;
                }
                if ((bid = this.world.getblock(this.dimension, (int)(this.posx + (double)k), (int)this.posy + j, (int)(this.posz - (double)k))) != 0 && Blocks.isSolid(bid)) {
                    ++solidcount;
                }
                if ((bid = this.world.getblock(this.dimension, (int)(this.posx - (double)k), (int)this.posy + j, (int)(this.posz - (double)k))) != 0 && Blocks.isSolid(bid)) {
                    ++solidcount;
                }
                --j;
            }
            ++k;
        }
        return solidcount >= 5;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(3) != 1) {
            return null;
        }
        return "OreSpawn:mobzilla_living";
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:mobzilla_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 100 + this.world.rand.nextInt(50);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 20.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 75 + this.world.rand.nextInt(50);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 18.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 54;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.mobzillascale.itemID, 16.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        Utils.doDropRand(this.world, 0, OreSpawnMain.trophymobzilla.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Mobzilla) {
            return false;
        }
        if (e instanceof ChaosDemon) {
            return false;
        }
        if (e instanceof BabySitter) {
            return false;
        }
        if (e.getWidth() * e.getHeight() < 0.75f) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Mobzillatexture.png");
        }
        return this.texture;
    }

    @Override
    public void setBaby(boolean tf) {
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    public String getBossName() {
        return "Mobzilla!!!";
    }
}

