/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Bee;
import OreSpawn.entities.Brutalfly;
import OreSpawn.entities.CloudShark;
import OreSpawn.entities.EmperorScorpion;
import OreSpawn.entities.LurkingTerror;
import OreSpawn.entities.Mothra;
import OreSpawn.entities.Rotator;
import OreSpawn.entities.TerribleTerror;
import OreSpawn.entities.Vortex;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Mantis
extends EntityLiving {
    float myspeed = 0.0f;

    public Mantis(World w) {
        super(w);
        this.maxrenderdist = 160;
        this.uniquename = "OreSpawn:Mantis";
        if (w != null) {
            this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = false;
        this.setExperience(150);
        this.height = 3.75f;
        this.width = 2.75f;
        this.setMaxHealth(75.0f);
        this.setHealth(75.0f);
        this.setDefense(2.0f);
        this.setAttackDamage(15.0f);
        this.searchDistance = 20.0f;
        this.attackRange = 4.0f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = true;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = true;
        this.canFly = true;
        this.setFlying(true);
        this.tower_defense_enable = true;
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(10) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom(this, dt, dmg);
        }
        if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        int keep_trying = 35;
        this.do_swarm_despawn();
        int bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
        if (bid == 0 && this.wouldBump(this.posx + (double)(this.motionx * deltaT), this.posy + (double)(this.motiony * deltaT) + (double)(this.getHeight() / 2.0f), this.posz + (double)(this.motionz * deltaT), this.getWidth())) {
            bid = 1;
        }
        if (bid != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 3.0) {
            int updown = 5;
            int k = 1;
            while (k < 10) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - k, (int)this.posz);
                if (bid != 0) {
                    updown = -1;
                    break;
                }
                ++k;
            }
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                if (this.isSwarming()) {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(25), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(25));
                } else {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(35) - (double)this.world.rand.nextInt(35), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(35) - (double)this.world.rand.nextInt(35));
                }
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                if (bid == 0 && !this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((this.posx - this.target.targetx) * (this.posx - this.target.targetx) + (this.posz - this.target.targetz) * (this.posz - this.target.targetz) + (this.posy - this.target.targety) * (this.posy - this.target.targety)))) {
                    bid = 1;
                }
                --keep_trying;
                this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
            }
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
            this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
        }
        float dy = (float)(this.target.targety - this.posy);
        this.motiony += 0.12f * deltaT;
        if ((dy /= 20.0f) > 0.2f) {
            dy = 0.2f;
        }
        if (dy < -0.2f) {
            dy = -0.2f;
        }
        this.motiony += dy;
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        Utils.SpawnDustAlongPath(this);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof TerribleTerror && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof EmperorScorpion && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof CloudShark && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof LurkingTerror && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Rotator && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Bee && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Mantis) {
            return false;
        }
        if (e instanceof Mothra && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Brutalfly && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Vortex && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.goosemeat.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.feather.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 2;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.mantisclaw.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophymantis.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Mantistexture.png");
        }
        return this.texture;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:dragonfly_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(2) != 1) {
            return null;
        }
        return "OreSpawn:beebuzz";
    }

    @Override
    public boolean isBoss() {
        return true;
    }
}

