/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Kraken;
import OreSpawn.entities.KrakenKing;
import OreSpawn.entities.LavaLizard;
import OreSpawn.entities.LazerLizard;
import OreSpawn.entities.LightningLizard;
import OreSpawn.entities.NastysaurusPrime;
import OreSpawn.entities.Needlenose;
import OreSpawn.entities.Squid;
import OreSpawn.entities.SquidGuard;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Lizard
extends EntityLiving {
    Entity targetentity = null;
    float attackRange = 0.0f;
    int searchcounter = 0;

    public Lizard(World w) {
        super(w);
        this.maxrenderdist = 110;
        this.height = 1.1f;
        this.width = 1.5f;
        this.uniquename = "OreSpawn:Lizard";
        this.moveSpeed = 0.3f;
        this.setMaxHealth(50.0f);
        this.setHealth(50.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(10.0f);
        this.movefrequency = 50;
        this.setExperience(33);
        this.canSwim = true;
        this.attackRange = 3.5f;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = true;
        this.enable_buddy = true;
        this.findbuddydistance = 20;
        this.searchDistance = 24.0f;
        this.enable_droppedfood = true;
        this.foodsearchDistance = 12;
        this.enableBreeding(10);
        this.enableTaming(20);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 100;
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof Lizard;
    }

    @Override
    public void init() {
        super.init();
        this.setSinging(false);
    }

    @Override
    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == OreSpawnMain.crystalapple.itemID) {
            return true;
        }
        return this.isFoodForMe(bid, iid);
    }

    @Override
    public boolean isFoodItem(int foodid) {
        if (foodid == Items.deadbug.itemID) {
            return true;
        }
        return foodid == Items.fishmeat.itemID;
    }

    @Override
    public void doEntityAction(float deltaT) {
        ++this.searchcounter;
        if (this.searchcounter >= 10 && this.world.rand.nextInt(3) == 0) {
            this.searchcounter = this.world.rand.nextInt(4);
            this.targetentity = this.findSomethingToAttack();
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(10) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            this.targetentity.doAttackFrom(this, 4, this.getAttackDamage());
        }
        super.doEntityAction(deltaT);
    }

    @Override
    public void onKill(Entity e) {
        this.heal(1.0f);
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        Entity princess;
        if (this.world.isServer && p != null && ic == null && (princess = this.world.createEntityByName("OreSpawn:Girlfriend", this.dimension, this.posx, this.posy, this.posz)) != null) {
            princess.init();
            princess.setVarInt(21, 1 + this.world.rand.nextInt(2));
            princess.setMaxHealth(100.0f);
            princess.setOwnerName(p.myname);
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
            princess.setHealth(princess.getMaxHealth());
            this.world.spawnEntityInWorld(princess);
            this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            this.deadflag = true;
        }
        return false;
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (DangerZone.playnicely) {
            return false;
        }
        if (e.deadflag) {
            return false;
        }
        if (e instanceof LightningLizard) {
            return false;
        }
        if (e instanceof LavaLizard) {
            return false;
        }
        if (e instanceof LazerLizard) {
            return false;
        }
        if (e instanceof Lizard) {
            return false;
        }
        if (e instanceof Needlenose) {
            return false;
        }
        if (e instanceof NastysaurusPrime) {
            return false;
        }
        if (e.getWidth() * e.getHeight() < 0.53f && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Squid && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Kraken && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof SquidGuard && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof KrakenKing && this.CanProbablySeeEntity(e);
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(10000) == 1 && this.getCanDespawn()) {
            this.deadflag = true;
        }
        super.update(deltaT);
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:alo_hurt";
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:alo_death";
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, Blocks.flower_red.blockID, 0, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.fishmeat.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophylizard.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Lizardtexture.png");
        }
        return this.texture;
    }
}

