/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Leon
extends EntityLiving {
    private int soundcount = 0;
    Entity targetentity = null;
    Entity hurtMe = null;
    float attackRange = 4.5f;
    int searchcounter = 0;
    float myspeed = 0.25f;

    public Leon(World w) {
        super(w);
        this.maxrenderdist = 200;
        this.height = 2.75f;
        this.width = 2.75f;
        this.uniquename = "OreSpawn:Leon";
        this.moveSpeed = 0.2f;
        this.setMaxHealth(300.0f);
        this.setHealth(300.0f);
        this.setDefense(3.5f);
        this.setAttackDamage(45.0f);
        this.movefrequency = 55;
        this.setExperience(199);
        this.canSwim = true;
        this.sit_when_riding = true;
        this.takesFallDamage = false;
        this.isImmuneToFire = false;
        this.searchDistance = 30.0f;
        this.canSwim = true;
        this.enable_taming = true;
        this.maxdisttoowner = 24.0f;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.enable_droppedfood = true;
        this.canFly = true;
        this.temperament = 1;
        this.tower_defense_enable = true;
        this.setGroundFactor(0.55f);
        this.setAirFactor(1.75f);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Leontexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer && ic == null && this.getOwnerName() != null && p.getPetName().equals(this.getOwnerName())) {
            if (this.isMountedBy(p)) {
                this.unMount(p);
            } else {
                this.Mount(p);
                this.setSitting(false);
                this.setStaying(false);
            }
            return false;
        }
        return super.rightClickedByPlayer(p, ic);
    }

    @Override
    public boolean isFoodItem(int iid) {
        return iid == Items.moosemeat.itemID;
    }

    @Override
    public float getRiderYoffset() {
        if (this.isBaby()) {
            return 0.575f;
        }
        return 2.3f;
    }

    @Override
    public float getRiderXZoffset() {
        if (this.isBaby()) {
            return 0.1375f;
        }
        return 0.55f;
    }

    private void doFlyingAttack() {
        ++this.searchcounter;
        if (this.searchcounter >= 6) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(4) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange * 2.0f + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom(this, dt, dmg);
        }
    }

    private void doNormalAttack() {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(10) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(8) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom(this, dt, dmg);
        }
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Leon) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e) && this.getOwnerName() == null;
    }

    @Override
    public String getHurtSound() {
        int which = this.world.rand.nextInt(3);
        if (which == 0) {
            return "OreSpawn:Leon_hit1";
        }
        if (which == 1) {
            return "OreSpawn:Leon_hit2";
        }
        return "OreSpawn:Leon_hit3";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:Leon_death";
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(3) != 1) {
            return null;
        }
        return "OreSpawn:Leon_living";
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        this.setFlying(true);
        this.setStaying(false);
        if (!(e == this || DangerZone.playnicely || e instanceof Leon || this.getOwnerName() != null && e instanceof Player)) {
            this.hurtMe = e;
        }
        super.doAttackFrom(e, dt, pain);
    }

    @Override
    public void doEntityAction(float deltaT) {
        Entity rider = this.getRiderEntity();
        if (this.isFlying()) {
            ++this.soundcount;
            if (this.soundcount > 12) {
                this.soundcount = 0;
                int which = this.world.rand.nextInt(3);
                if (which == 0) {
                    this.world.playSound("OreSpawn:MothraWings1", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                }
                if (which == 1) {
                    this.world.playSound("OreSpawn:MothraWings2", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                }
                if (which == 2) {
                    this.world.playSound("OreSpawn:MothraWings3", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                }
            }
        }
        if (rider == null) {
            if (!this.isFlying()) {
                if (!this.getStaying()) {
                    this.doNormalAttack();
                    if (this.getOwnerName() != null) {
                        double dist = 0.0;
                        Entity e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName());
                        if (e != null) {
                            dist = this.getDistanceFromEntity(e);
                        }
                        if (dist > (double)(this.maxdisttoowner + 8.0f)) {
                            this.setFlying(true);
                        }
                    }
                    if (this.world.rand.nextInt(500) == 1) {
                        this.setFlying(true);
                    }
                }
                super.doEntityAction(deltaT);
                return;
            }
            this.doFlyingAttack();
            this.doSoloFlying(deltaT);
            this.doLookAction();
            if (this.world.rand.nextInt(500) == 1) {
                this.setFlying(false);
            }
            return;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.toRadians(rider.rotation_yaw);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        if (ddiff > 0.2f) {
            ddiff = 0.2f;
        }
        if (ddiff < -0.2f) {
            ddiff = -0.2f;
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 6.0);
        cdir = (float)Math.toRadians(this.rotation_yaw_head);
        tdir = (float)Math.toRadians(rider.rotation_yaw_head);
        ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 5.0);
        if (this.getOnGround()) {
            this.setFlying(false);
        } else {
            this.setFlying(true);
            Utils.SpawnDustAlongPath(this);
        }
        this.doFlyingAttack();
    }

    public void doSoloFlying(float deltaT) {
        int bid;
        Entity e;
        int keep_trying = 35;
        double px = this.posx;
        double py = this.posy;
        double pz = this.posz;
        double dist = 0.0;
        int dxz = 25;
        float speedadjust = 1.0f;
        if (this.getOwnerName() != null && (e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null) {
            px = e.posx;
            py = e.posy + (double)(e.getHeight() / 2.0f);
            pz = e.posz;
            dxz = 20;
            dist = this.getDistanceFromEntity(e);
            if (dist > (double)this.maxdisttoowner) {
                speedadjust = 1.75f;
            }
            if (dist > (double)(this.maxdisttoowner * 1.5f)) {
                speedadjust = 2.75f;
            }
        }
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                this.target.setTarget(px + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)), py + (double)(this.world.rand.nextInt(8) - 2), pz + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)));
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                --keep_trying;
            }
            this.myspeed = 0.25f + this.world.rand.nextFloat() * 0.25f;
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
            this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.12f * deltaT;
        if ((dy /= 20.0) > (double)0.2f) {
            dy = 0.2f;
        }
        if (dy < (double)-0.2f) {
            dy = -0.2f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 8.0);
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        Utils.SpawnDustAlongPath(this);
    }

    @Override
    public void doDeathDrops() {
        int howmany = 6 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.fishmeat.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 6 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.feather.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyleon.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    public String getBossName() {
        return "Leonopteryx";
    }
}

