/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class LeafMonster
extends EntityLiving {
    public LeafMonster(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.height = 0.99f;
        this.width = 0.99f;
        this.uniquename = "OreSpawn:LeafMonster";
        this.moveSpeed = 0.31f;
        this.setMaxHealth(20.0f);
        this.setHealth(20.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(3.0f);
        this.searchDistance = 8.0f;
        this.attackRange = 3.0f;
        this.movefrequency = 999;
        this.setExperience(19);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = true;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = true;
        this.tower_defense_enable = true;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:leaves_hit";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:leaves_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, Blocks.leaves.blockID, 0, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            Utils.doDropRand(this.world, Blocks.log.blockID, 0, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyleafmonster.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public void update(float deltaT) {
        if (!this.getAttacking()) {
            this.rotation_yaw_motion = 0.0f;
            int i = (int)this.rotation_yaw / 90;
            this.rotation_yaw = i * 90;
        }
        super.update(deltaT);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof LeafMonster) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/LeafMonstertexture.png");
        }
        return this.texture;
    }
}

