/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.EntityLivingDragon;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.Putin;
import OreSpawn.entities.Russian;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Cockroach;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Lavrov
extends EntityLiving {
    public Lavrov(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 1.9f;
        this.width = 0.85f;
        this.uniquename = "OreSpawn:Sergey Lavrov";
        this.moveSpeed = 0.28f;
        this.setMaxHealth(100.0f);
        this.setHealth(100.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(2.0f);
        this.setMaxHunger(50.0f);
        this.setHunger(50.0f);
        this.setMaxAir(100.0f);
        this.setAir(100.0f);
        this.setExperience(150);
        this.searchDistance = 16.0f;
        this.attackRange = 3.0f;
        this.movefrequency = 55;
        this.canSwim = true;
        this.has_inventory = true;
        this.temperament = 2;
        this.enable_hostile = true;
        this.tower_defense_enable = false;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.setPetName("Sergey Lavrov");
        this.setCanDespawn(false);
    }

    @Override
    public boolean isFoodItem(int iid) {
        if (iid == Items.moosemeat.itemID) {
            return true;
        }
        if (iid == Items.moosemeat_cooked.itemID) {
            return true;
        }
        if (iid == Items.goosemeat.itemID) {
            return true;
        }
        return iid == Items.goosemeat_cooked.itemID;
    }

    @Override
    public void init() {
        super.init();
        if (this.world != null && this.world.isServer && this.getInitialized() == 0) {
            this.setInitialized(1);
            InventoryContainer ic = new InventoryContainer();
            ic = new InventoryContainer();
            ic.iid = OreSpawnMain.jacket.itemID;
            ic.count = 1;
            ic.currentuses = this.world.rand.nextInt(ic.getItem().maxuses);
            this.setArmor(1, ic);
        }
    }

    @Override
    public void doAttack(Entity victim) {
        super.doAttack(victim);
        if (victim instanceof EntityLiving && !(victim instanceof EntityLivingDragon)) {
            EntityLiving el = (EntityLiving)victim;
            el.temperament = 2;
            el.enable_hostile = false;
            el.setAttacking(false);
        }
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        int i = this.world.rand.nextInt(3);
        if (i == 0) {
            return "DangerZone:ouch1";
        }
        if (i == 1) {
            return "DangerZone:ouch2";
        }
        return "DangerZone:ouch3";
    }

    @Override
    public String getAttackSound() {
        int i = this.world.rand.nextInt(5);
        if (i == 0) {
            return "OreSpawn:lavrov1";
        }
        if (i == 1) {
            return "OreSpawn:lavrov2";
        }
        if (i == 2) {
            return "OreSpawn:lavrov3";
        }
        if (i == 3) {
            return "OreSpawn:lavrov4";
        }
        return "OreSpawn:lavrov5";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophylavrov.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Lavrov) {
            return false;
        }
        if (e instanceof Putin) {
            return false;
        }
        if (e instanceof Russian) {
            return false;
        }
        if (e instanceof Cockroach) {
            return true;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Player) {
            return false;
        }
        if (e instanceof Girlfriend) {
            return false;
        }
        return false;
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Lavrov.png");
        }
        return this.texture;
    }
}

