/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Kraken;
import OreSpawn.entities.KrakenKing;
import OreSpawn.entities.LazerLizard;
import OreSpawn.entities.LightningLizard;
import OreSpawn.entities.Lizard;
import OreSpawn.entities.NastysaurusPrime;
import OreSpawn.entities.Needlenose;
import OreSpawn.entities.Squid;
import OreSpawn.entities.SquidGuard;
import OreSpawn.entities.ThrownBlock;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class LavaLizard
extends EntityLiving {
    public LavaLizard(World w) {
        super(w);
        this.uniquename = "OreSpawn:Lava Lizard";
        this.maxrenderdist = 110;
        this.height = 1.1f;
        this.width = 1.5f;
        this.moveSpeed = 0.3f;
        this.setMaxHealth(50.0f);
        this.setHealth(50.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(10.0f);
        this.movefrequency = 50;
        this.setExperience(55);
        this.canSwim = false;
        this.attackRange = 3.5f;
        this.searchDistance = 32.0f;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = true;
        this.tower_defense_enable = true;
        this.enable_buddy = true;
        this.isImmuneToFire = true;
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof LavaLizard;
    }

    @Override
    public void doEntityAction(float deltaT) {
        ++this.searchcounter;
        if (this.searchcounter >= 10 && this.world.rand.nextInt(3) == 0) {
            this.searchcounter = this.world.rand.nextInt(4);
            this.targetentity = this.findSomethingToAttack();
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(10) == 1) {
            if (this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                this.targetentity.doAttackFrom(this, 4, this.getAttackDamage());
            } else {
                double cdir = Math.toRadians(this.rotation_yaw);
                double tdir = Math.atan2(this.targetentity.posx - this.posx, this.targetentity.posz - this.posz);
                double ddiff = tdir - cdir;
                while (ddiff > Math.PI) {
                    ddiff -= Math.PI * 2;
                }
                while (ddiff < -Math.PI) {
                    ddiff += Math.PI * 2;
                }
                if (Math.abs(ddiff) < 1.0471975511965976) {
                    this.do_distance_attack(this.targetentity);
                }
            }
        }
        super.doEntityAction(deltaT);
    }

    private void do_distance_attack(Entity victim) {
        if (victim.getHeight() * victim.getWidth() < 0.5f) {
            return;
        }
        double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f));
        double starty = this.posy + (double)(this.getHeight() * 3.0f / 4.0f);
        double startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f));
        float hdist = (float)Math.sqrt((victim.posx - startx) * (victim.posx - startx) + (victim.posz - startz) * (victim.posz - startz));
        float tdirxz = (float)Math.atan2(victim.posx - startx, victim.posz - startz);
        float tdiry = (float)Math.atan2(starty - (victim.posy + (double)victim.getHeight()), hdist);
        tdiry = (float)((double)tdiry - 0.15707963267948966);
        ThrownBlock e = (ThrownBlock)this.world.createEntityByName("OreSpawn:ThrownBlock", this.dimension, startx, starty, startz);
        if (e != null) {
            e.init();
            e.setBID(Blocks.lava.blockID);
            e.setIID(this.world.rand.nextInt(15) + 1);
            e.thrower = this;
            e.setAttackDamage(30.0f);
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 2.5f, 0.2f);
            this.world.spawnEntityInWorld(e);
        }
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.lumptin.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, Blocks.blocktin.blockID, 0, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinboots.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinleggings.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinchestplate.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinhelmet.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinaxe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinpickaxe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinshovel.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinsword.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, Items.tinhoe.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophylavalizard.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof LightningLizard) {
            return false;
        }
        if (e instanceof LavaLizard) {
            return false;
        }
        if (e instanceof LazerLizard) {
            return false;
        }
        if (e instanceof Lizard) {
            return false;
        }
        if (e instanceof Needlenose) {
            return false;
        }
        if (e instanceof NastysaurusPrime) {
            return false;
        }
        if (e.getWidth() * e.getHeight() < 0.53f && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Squid && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Kraken && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof SquidGuard && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof KrakenKing && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/LavaLizardtexture.png");
        }
        return this.texture;
    }
}

