/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.BabySitter;
import OreSpawn.entities.ChaosDemon;
import OreSpawn.entities.Kraken;
import OreSpawn.entities.Squid;
import OreSpawn.entities.SquidGuard;
import OreSpawn.entities.ThePrincessYoungAdult;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.RenderInfo;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Item;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class KrakenKing
extends EntityLiving {
    float myspeed = 0.0f;
    public RenderInfo renderdata = new RenderInfo();
    private boolean isalive = false;
    private Entity caught = null;
    private int newtarget = 0;
    private int release = 0;
    private int straight_down = 1;

    public KrakenKing(World w) {
        super(w);
        this.maxrenderdist = 320;
        this.uniquename = "OreSpawn:KrakenKing";
        if (w != null) {
            this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = true;
        this.canBreateUnderWater = true;
        this.setExperience(150);
        this.height = 15.75f;
        this.width = 4.75f;
        this.setMaxHealth(8000.0f);
        this.setHealth(8000.0f);
        this.setDefense(8.5f);
        this.setAttackDamage(320.0f);
        this.searchDistance = 128.0f;
        this.attackRange = 12.0f;
        this.setCanDespawn(false);
        this.isImmuneToFire = true;
        this.ignoreCollisions = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = false;
        this.canFly = true;
        this.setFlying(true);
        this.tower_defense_enable = false;
        this.setIID(0);
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (dt == 9) {
            return;
        }
        if (dt == 12) {
            return;
        }
        if (dt == 10) {
            return;
        }
        if (this.world.rand.nextBoolean() && this.caught != null) {
            this.release = 1;
        }
        super.doAttackFrom(e, dt, pain);
        if (this.getIID() == 0) {
            this.setIID(1);
            ThePrincessYoungAdult sc = (ThePrincessYoungAdult)this.world.createEntityByName("OreSpawn:ThePrincessYoungAdult", this.dimension, this.posx, this.posy, this.posz);
            if (sc != null) {
                sc.init();
                sc.setCanDespawn(false);
                sc.setIID(1);
                this.world.spawnEntityInWorld(sc);
            }
        }
    }

    public void setGuardMode() {
        this.setVarInt(21, (int)this.posx);
        this.setVarInt(22, (int)this.posz);
        this.setBID(1);
    }

    private boolean canSeeTarget(double px, double py, double pz) {
        return this.CanProbablySee(this.dimension, px, py, pz, (int)Math.sqrt((this.posx - px) * (this.posx - px) + (this.posy - py) * (this.posy - py) + (this.posz - pz) * (this.posz - pz)));
    }

    @Override
    public void doEntityAction(float deltaT) {
        int bid;
        Entity e;
        ++this.searchcounter;
        if (this.searchcounter >= 10 && this.caught == null) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(30) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + 15.0, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.caught == null && this.target != null && this.targetentity != null && this.world.rand.nextInt(15) == 1 && !this.targetentity.deadflag && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            this.targetentity.doAttackFrom(this, 4, this.getAttackDamage());
        }
        int keep_trying = 15;
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(100) == 1 && !DangerZone.playnicely && (this.getAttacking() || this.caught != null) && (e = this.world.createEntityByName("DangerZone:Lightning", this.dimension, this.posx, this.posy - 16.0, this.posz)) != null) {
            e.init();
            e.setAttackDamage(15.0f);
            this.world.spawnEntityInWorld(e);
        }
        if (!(this.world.rand.nextInt(400) != 1 && DangerZone.thundercount != 0 || DangerZone.playnicely || !this.getAttacking() && this.caught == null || (e = this.world.createEntityByName("DangerZone:Cloud", this.dimension, this.posx + (double)(this.world.rand.nextInt(64) - this.world.rand.nextInt(64)), 200.0, this.posz + (double)(this.world.rand.nextInt(64) - this.world.rand.nextInt(64)))) == null)) {
            e.init();
            e.setBID(Blocks.cloud_thunder.blockID);
            this.world.spawnEntityInWorld(e);
        }
        if (this.newtarget != 0 || this.world.rand.nextInt(250) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < (double)6.1f) {
            int randdist = 16;
            double px = this.posx;
            double pz = this.posz;
            if (this.getBID() != 0) {
                px = this.getVarInt(21);
                pz = this.getVarInt(22);
                randdist = 128;
            }
            this.newtarget = 0;
            int ground_dist = 0;
            while (ground_dist < 31) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - ground_dist, (int)this.posz);
                if (bid != 0) {
                    this.straight_down = 0;
                    break;
                }
                ++ground_dist;
            }
            ground_dist = 20 - ground_dist;
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                int zdir = this.world.rand.nextInt(randdist) + 8;
                int xdir = this.world.rand.nextInt(randdist) + 8;
                if (this.world.rand.nextBoolean()) {
                    zdir = -zdir;
                }
                if (this.world.rand.nextBoolean()) {
                    xdir = -xdir;
                }
                if (this.straight_down != 0) {
                    xdir = 0;
                    zdir = 0;
                }
                this.target.setTarget((int)px + xdir, (int)this.posy + ground_dist + this.world.rand.nextInt(9) - 6, (int)pz + zdir);
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                if (bid == 0 || bid == Blocks.waterstatic.blockID) {
                    bid = 0;
                    if (!this.canSeeTarget((int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) {
                        bid = 1;
                    }
                }
                --keep_trying;
            }
            this.myspeed = 0.38f + this.world.rand.nextFloat() * 0.15f;
        }
        if (this.caught == null && this.hurtMe == null && this.world.rand.nextInt(7) == 1 && !DangerZone.playnicely) {
            e = null;
            e = this.findSomethingToAttack();
            if (e != null) {
                this.myspeed = 0.4f + this.world.rand.nextFloat() * 0.15f;
                this.target.setTarget((int)e.posx, (int)e.posy + 15, (int)e.posz);
                this.pickItUpMaybe(e);
            }
        }
        if (this.caught != null) {
            if (!this.caught.deadflag) {
                this.myspeed = 0.0f;
                this.motionz = 0.0f;
                this.motionx = 0.0f;
                this.target.setTarget((int)this.posx, 210.0, (int)this.posz);
                if (this.posy > 200.0) {
                    this.release = 1;
                }
                if (this.world.rand.nextInt(15) == 1) {
                    this.caught.doAttackFrom(this, 4, this.getAttackDamage());
                }
                this.caught.motionx = this.motionx;
                this.caught.motionz = this.motionz;
                this.caught.motiony = this.motiony;
                this.caught.posx = this.posx;
                if (this.posy - this.caught.posy > 16.0) {
                    this.caught.motiony = (float)((double)this.caught.motiony + 0.25);
                }
                this.caught.posy = this.posy - 15.0;
                this.caught.posz = this.posz;
                if (this.caught instanceof Player) {
                    Player p = (Player)this.caught;
                    p.server_thread.sendPositionAndVelocityUpdateToPlayer(p);
                }
                if (this.release != 0 || this.world.rand.nextInt(250) == 1) {
                    this.caught = null;
                    this.newtarget = 1;
                    this.release = 0;
                    this.setAttacking(false);
                }
            } else {
                this.caught = null;
                this.newtarget = 1;
                this.release = 0;
                this.setAttacking(false);
            }
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.025f * deltaT;
        if ((dy /= 20.0) > (double)0.2f) {
            dy = 0.2f;
        }
        if (dy < (double)-0.1f) {
            dy = -0.1f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        double obstruction_factor = 0.0;
        double dx = 0.0;
        double dz = 0.0;
        int dist = 10;
        int k = -20;
        while (k < 18) {
            int i = 1;
            while (i < dist) {
                dx = (double)i * Math.cos(Math.toRadians(this.rotation_yaw + 90.0f));
                bid = this.world.getblock(this.dimension, (int)(this.posx + dx), (int)this.posy + k, (int)(this.posz + (dz = (double)i * Math.sin(Math.toRadians(this.rotation_yaw + 90.0f)))));
                if (bid != 0 && bid != Blocks.waterstatic.blockID) {
                    obstruction_factor += 0.1;
                }
                i += 2;
            }
            k += 2;
        }
        this.motiony = (float)((double)this.motiony + obstruction_factor * 0.08);
        this.posy += obstruction_factor * 0.08;
        if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
    }

    private void pickItUpMaybe(Entity par1) {
        if (DangerZone.playnicely) {
            return;
        }
        if (this.caught != null) {
            return;
        }
        double dist = (this.posx - par1.posx) * (this.posx - par1.posx);
        dist += (this.posz - par1.posz) * (this.posz - par1.posz);
        if ((dist += (this.posy - par1.posy - 15.0) * (this.posy - par1.posy - 15.0)) < 40.0) {
            this.caught = par1;
            this.release = 0;
            this.setAttacking(true);
        }
    }

    @Override
    public void update(float deltaT) {
        this.isalive = true;
        super.update(deltaT);
    }

    public boolean isAlive() {
        return this.isalive;
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof KrakenKing) {
            return false;
        }
        if (e instanceof Kraken) {
            return false;
        }
        if (e instanceof Squid) {
            return false;
        }
        if (e instanceof SquidGuard) {
            return false;
        }
        if (e instanceof ChaosDemon) {
            return false;
        }
        if (e instanceof BabySitter) {
            return false;
        }
        if (e instanceof ThePrincessYoungAdult) {
            return false;
        }
        if (e.getWidth() * e.getHeight() < 1.0f) {
            return false;
        }
        if (e.getRiddenEntity() != null) {
            return false;
        }
        if (e.getRiderEntity() != null) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof EntityLiving && this.CanProbablySeeEntity(e);
    }

    @Override
    public void doDeathDrops() {
        int howmany = 60 + this.world.rand.nextInt(40);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.fishmeat.itemID, 12.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 60 + this.world.rand.nextInt(40);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.feather.itemID, 20.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 10 + this.world.rand.nextInt(20);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 20.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 125;
        i = 0;
        while (i < howmany) {
            int iid = this.world.rand.nextInt(2048);
            Item it = Items.getItem(iid);
            if (it == null || !it.showInInventory) continue;
            iid = it.itemID;
            ++i;
            Utils.doDropRand(this.world, 0, iid, 20.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        i = 0;
        while (i < howmany) {
            int bid = this.world.rand.nextInt(2048);
            Block bl = Blocks.getBlock(bid);
            if (bl == null || !bl.showInInventory) continue;
            bid = bl.blockID;
            ++i;
            Utils.doDropRand(this.world, bid, 0, 20.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, OreSpawnMain.trophykrakenking.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, OreSpawnMain.eggkrakenking.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, OreSpawnMain.dimensionstaff.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/KrakenKingtexture.png");
        }
        return this.texture;
    }

    @Override
    public String getHurtSound() {
        return null;
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:alo_death";
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(2) != 1) {
            return null;
        }
        return "OreSpawn:kraken_living";
    }

    @Override
    public void setBaby(boolean tf) {
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    public String getBossName() {
        return "The Kraken King!!!";
    }
}

