/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.OreSpawnTrees;
import dangerzone.DangerZone;
import dangerzone.Explosion;
import dangerzone.KVPair;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityLiving;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.List;
import java.util.Properties;
import slick.Texture;

public class IslandToo
extends EntityLiving {
    private int dir = 0;
    private float speed = 0.1f;
    private int iwidth = 5;
    private int depth = 3;
    private int length = 10;
    private int just_spawned = 1;
    private int ticker = 0;
    private int once = 1;
    private double myX;
    private double myZ;
    private int dirchange;
    private int blocktype = 0;

    public IslandToo(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.5f;
        this.width = 0.5f;
        this.uniquename = "OreSpawn:IslandToo";
        this.moveSpeed = 0.0f;
        this.setMaxHealth(30.0f);
        this.setHealth(30.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 20000;
        this.setExperience(30);
        this.canSwim = false;
        this.takesFallDamage = false;
        this.ignoreCollisions = true;
        this.setCanDespawn(false);
        this.tower_defense_enable = false;
    }

    @Override
    public void init() {
        super.init();
        this.ticker = DangerZone.rand.nextInt(50);
        this.dirchange = DangerZone.rand.nextInt(2500);
    }

    @Override
    public void update(float deltaT) {
        if (!this.world.isServer) {
            super.update(deltaT);
            return;
        }
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        if (this.once != 0) {
            this.myX = this.posx;
            this.myZ = this.posz;
            this.once = 0;
        }
        if (this.just_spawned != 0) {
            this.dir = this.world.rand.nextInt(4);
            if (this.world.rand.nextInt(30) != 1) {
                this.length = this.iwidth = 1 + this.world.rand.nextInt(12);
                this.depth = 1 + this.world.rand.nextInt(4);
                this.speed = this.world.rand.nextFloat() / 5.0f;
                if (this.length * this.iwidth * this.depth <= 64) {
                    this.speed *= 2.0f;
                }
                if (this.length * this.iwidth * this.depth <= 32) {
                    this.speed *= 2.0f;
                }
            } else {
                this.length = this.iwidth = 12 + this.world.rand.nextInt(24);
                this.depth = 4 + this.world.rand.nextInt(6);
                this.speed = this.world.rand.nextFloat() / 25.0f;
            }
            this.create_island();
            this.ticker = this.world.rand.nextInt(50);
            this.dirchange = this.world.rand.nextInt(10000);
        }
        --this.ticker;
        if (this.ticker <= 0) {
            this.update_island();
            this.ticker = 20 + this.world.rand.nextInt(10);
        }
        --this.dirchange;
        if (this.dirchange <= 0) {
            this.dirchange = this.world.rand.nextInt(5000);
            this.dir = this.world.rand.nextInt(4);
        }
        this.just_spawned = 0;
        super.update(deltaT);
    }

    @Override
    public void writeSelf(List<KVPair> prop, String tag) {
        super.writeSelf(prop, tag);
        prop.add(new KVPair(String.format("%s%s", tag, "JustSpawned"), String.format("%d", this.just_spawned)));
        prop.add(new KVPair(String.format("%s%s", tag, "Iwidth"), String.format("%d", this.iwidth)));
        prop.add(new KVPair(String.format("%s%s", tag, "Idepth"), String.format("%d", this.depth)));
        prop.add(new KVPair(String.format("%s%s", tag, "Ilength"), String.format("%d", this.length)));
        prop.add(new KVPair(String.format("%s%s", tag, "Ispeed"), String.format("%f", Float.valueOf(this.speed))));
        prop.add(new KVPair(String.format("%s%s", tag, "Idir"), String.format("%d", this.dir)));
        prop.add(new KVPair(String.format("%s%s", tag, "Iblocktype"), String.format("%d", this.blocktype)));
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        this.just_spawned = Utils.getPropertyInt(prop, String.format("%s%s", tag, "JustSpawned"), 0, 1, 0);
        this.iwidth = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Iwidth"), 1, 36, 2);
        this.depth = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Idepth"), 1, 10, 2);
        this.length = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Ilength"), 1, 36, 2);
        this.speed = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "Ispeed"), 0.0f, 1.0f, 0.1f);
        this.dir = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Idir"), 0, 3, 2);
        this.blocktype = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Iblocktype"), 1, 16384, 1);
    }

    private void create_island() {
        int bid = 0;
        int k = 0;
        while (k <= this.depth) {
            int il = this.length / (this.depth - k + 1);
            if (il < 1) {
                il = 1;
            }
            int i = -il;
            while (i <= il) {
                int j = -il;
                while (j <= il) {
                    int ix = (int)this.posx + j;
                    int iz = (int)this.posz + i;
                    if (k == this.depth) {
                        bid = this.world.getblock(this.dimension, ix, (int)this.posy + k, iz);
                        if (!Blocks.isSolid(bid)) {
                            if (this.world.rand.nextInt(5000) == 1) {
                                this.FastSetBlock(ix, (int)this.posy + k, iz, Blocks.waterstatic.blockID);
                            } else {
                                this.world.setblockandmeta(this.dimension, ix, (int)this.posy + k, iz, OreSpawnMain.nofallgrassblock.blockID, this.world.rand.nextInt(4) << 12);
                                if (this.world.rand.nextInt(30) == 1) {
                                    if (this.world.getblock(this.dimension, ix, (int)this.posy + k + 1, iz) == 0) {
                                        if (this.world.rand.nextInt(2) == 1) {
                                            this.FastSetBlock(ix, (int)this.posy + k + 1, iz, OreSpawnMain.blockflower_pink.blockID);
                                        } else {
                                            this.FastSetBlock(ix, (int)this.posy + k + 1, iz, OreSpawnMain.blockflower_blue.blockID);
                                        }
                                    }
                                } else if (this.world.rand.nextInt(100) == 1 && this.world.getblock(this.dimension, ix, (int)this.posy + k + 1, iz) == 0) {
                                    OreSpawnTrees.SmallTree(this.world, this.dimension, ix, (int)this.posy + k + 1, iz);
                                }
                            }
                        } else if (bid == Blocks.stopblock.blockID) {
                            this.deadflag = true;
                            return;
                        }
                    } else {
                        this.mySetBlock(ix, (int)this.posy + k, iz);
                    }
                    ++j;
                }
                ++i;
            }
            ++k;
        }
    }

    private void update_island() {
        if (this.dir == 0) {
            this.myZ -= (double)this.speed;
        } else if (this.dir == 1) {
            this.myZ += (double)this.speed;
        } else {
            this.myX = this.dir == 2 ? (this.myX += (double)this.speed) : (this.myX -= (double)this.speed);
        }
        int ke = 0;
        int ks = 0;
        int je = 0;
        int js = 0;
        int mx = (int)this.myX;
        int mz = (int)this.myZ;
        int px = (int)this.posx;
        int pz = (int)this.posz;
        if (mx != px || mz != pz) {
            int bid;
            int iz;
            int ix;
            int k;
            int j;
            int il;
            if (this.dir == 0) {
                js = 1;
                je = 1;
                ks = -1;
                ke = 1;
            } else if (this.dir == 1) {
                js = -1;
                je = -1;
                ks = -1;
                ke = 1;
            } else if (this.dir == 2) {
                js = -1;
                je = 1;
                ks = -1;
                ke = -1;
            } else {
                js = -1;
                je = 1;
                ks = 1;
                ke = 1;
            }
            int i = 0;
            while (i <= this.depth) {
                il = this.length / (this.depth - i + 1);
                if (il < 1) {
                    il = 1;
                }
                j = js * il;
                while (j <= je * il) {
                    k = ks * il;
                    while (k <= ke * il) {
                        ix = (int)this.posx + k;
                        iz = (int)this.posz + j;
                        if (i == this.depth) {
                            bid = this.world.getblock(this.dimension, ix, (int)this.posy + i + 1, iz);
                            if (bid == OreSpawnMain.blockflower_pink.blockID || bid == OreSpawnMain.blockflower_blue.blockID || bid == OreSpawnMain.blockflower_black.blockID || bid == OreSpawnMain.blockflower_scary.blockID) {
                                this.FastSetBlock(ix, (int)this.posy + i + 1, iz, 0);
                            }
                            if (bid == Blocks.waterstatic.blockID) {
                                this.FastSetBlock(ix, (int)this.posy + i, iz, 0);
                            }
                            if (bid == OreSpawnMain.MySkyTreeLog.blockID) {
                                this.FastSetBlock(ix, (int)this.posy + i + 1, iz, 0);
                                bid = this.world.getblock(this.dimension, ix, (int)this.posy + i + 2, iz);
                                if (bid == OreSpawnMain.MySkyTreeLog.blockID) {
                                    this.FastSetBlock(ix, (int)this.posy + i + 2, iz, 0);
                                    bid = this.world.getblock(this.dimension, ix, (int)this.posy + i + 3, iz);
                                    if (bid == OreSpawnMain.MySkyTreeLog.blockID) {
                                        this.FastSetBlock(ix, (int)this.posy + i + 3, iz, 0);
                                    }
                                }
                            }
                            if ((bid = this.world.getblock(this.dimension, ix, (int)this.posy + i, iz)) == Blocks.waterstatic.blockID) {
                                this.FastSetBlock(ix, (int)this.posy + i, iz, 0);
                            }
                        }
                        this.FastSetBlock(ix, (int)this.posy + i, iz, 0);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            this.posx = mx;
            this.posz = mz;
            if (this.dir == 0) {
                js = -1;
                je = -1;
                ks = -1;
                ke = 1;
            } else if (this.dir == 1) {
                js = 1;
                je = 1;
                ks = -1;
                ke = 1;
            } else if (this.dir == 2) {
                js = -1;
                je = 1;
                ks = 1;
                ke = 1;
            } else {
                js = -1;
                je = 1;
                ks = -1;
                ke = -1;
            }
            i = 0;
            while (i <= this.depth) {
                il = this.length / (this.depth - i + 1);
                if (il < 1) {
                    il = 1;
                }
                j = js * il;
                while (j <= je * il) {
                    k = ks * il;
                    while (k <= ke * il) {
                        ix = (int)this.posx + k;
                        iz = (int)this.posz + j;
                        if (i == this.depth) {
                            bid = this.world.getblock(this.dimension, ix, (int)this.posy + i, iz);
                            if (!Blocks.isSolid(bid)) {
                                if (this.world.rand.nextInt(5000) == 1) {
                                    this.FastSetBlock(ix, (int)this.posy + i, iz, Blocks.waterstatic.blockID);
                                } else {
                                    this.world.setblockandmeta(this.dimension, ix, (int)this.posy + i, iz, OreSpawnMain.nofallgrassblock.blockID, this.world.rand.nextInt(4) << 12);
                                    if (this.world.rand.nextInt(30) == 1) {
                                        if (this.world.getblock(this.dimension, ix, (int)this.posy + i + 1, iz) == 0) {
                                            if (this.world.rand.nextInt(2) == 1) {
                                                this.FastSetBlock(ix, (int)this.posy + i + 1, iz, OreSpawnMain.blockflower_pink.blockID);
                                            } else {
                                                this.FastSetBlock(ix, (int)this.posy + i + 1, iz, OreSpawnMain.blockflower_blue.blockID);
                                            }
                                        }
                                    } else if (this.world.rand.nextInt(100) == 1 && this.world.getblock(this.dimension, ix, (int)this.posy + i + 1, iz) == 0) {
                                        OreSpawnTrees.SmallTree(this.world, this.dimension, ix, (int)this.posy + i + 1, iz);
                                    }
                                }
                            } else if (bid == Blocks.stopblock.blockID) {
                                this.deadflag = true;
                                return;
                            }
                        } else {
                            bid = this.world.getblock(this.dimension, ix, (int)this.posy + i, iz);
                            if (bid == Blocks.greystone.blockID) {
                                Explosion.boom(this, this.world, this.dimension, ix, (int)(this.posy + (double)i), iz, 10, true);
                            } else {
                                this.mySetBlock(ix, (int)this.posy + i, iz);
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void mySetBlock(int ix, int iy, int iz) {
        int bid = Blocks.stone.blockID;
        if (this.blocktype == 0) {
            this.blocktype = 1 + this.world.rand.nextInt(11);
        }
        if (this.blocktype == 1 && this.world.rand.nextInt(5) == 1) {
            bid = Blocks.orelight.blockID;
        }
        if (this.blocktype == 2 && this.world.rand.nextInt(5) == 1) {
            bid = Blocks.oredark.blockID;
        }
        if (this.blocktype == 3 && this.world.rand.nextInt(20) == 1) {
            bid = Blocks.oresilver.blockID;
        }
        if (this.blocktype == 4 && this.world.rand.nextInt(20) == 1) {
            bid = Blocks.oreplatinum.blockID;
        }
        if (this.blocktype == 5 && this.world.rand.nextInt(20) == 1) {
            bid = Blocks.oreemerald.blockID;
        }
        if (this.blocktype == 6 && this.world.rand.nextInt(30) == 1) {
            bid = Blocks.orebloodstone.blockID;
        }
        if (this.blocktype == 7 && this.world.rand.nextInt(30) == 1) {
            bid = Blocks.oresunstone.blockID;
        }
        if (this.blocktype == 8 && this.world.rand.nextInt(50) == 1) {
            bid = OreSpawnMain.oretitanium.blockID;
        }
        if (this.blocktype == 9 && this.world.rand.nextInt(50) == 1) {
            bid = OreSpawnMain.oreuranium.blockID;
        }
        if (this.blocktype == 10 && this.world.rand.nextInt(40) == 1) {
            bid = OreSpawnMain.oreruby.blockID;
        }
        if (this.blocktype == 11 && this.world.rand.nextInt(30) == 1) {
            bid = OreSpawnMain.oreamethyst.blockID;
        }
        if (bid == Blocks.stone.blockID) {
            if (this.world.rand.nextInt(3000) == 1) {
                bid = Blocks.blocklight.blockID;
            }
            if (this.world.rand.nextInt(3000) == 2) {
                bid = Blocks.blockdark.blockID;
            }
            if (this.world.rand.nextInt(3000) == 3) {
                bid = OreSpawnMain.blockamethyst.blockID;
            }
            if (this.world.rand.nextInt(3000) == 4) {
                bid = OreSpawnMain.blockruby.blockID;
            }
            if (this.world.rand.nextInt(5000) == 5) {
                bid = OreSpawnMain.blockuranium.blockID;
            }
            if (this.world.rand.nextInt(5000) == 6) {
                bid = OreSpawnMain.blocktitanium.blockID;
            }
            if (this.world.rand.nextInt(3000) == 7) {
                bid = Blocks.blockplatinum.blockID;
            }
            if (this.world.rand.nextInt(3000) == 8) {
                bid = Blocks.blockdiamond.blockID;
            }
            if (this.world.rand.nextInt(3000) == 9) {
                bid = Blocks.blockbloodstone.blockID;
            }
            if (this.world.rand.nextInt(3000) == 10) {
                bid = Blocks.blocksunstone.blockID;
            }
            if (this.world.rand.nextInt(3000) == 11) {
                bid = Blocks.blockemerald.blockID;
            }
        }
        this.FastSetBlock(ix, iy, iz, bid);
    }

    private void FastSetBlock(int ix, int iy, int iz, int id) {
        this.world.setblock(this.dimension, ix, iy, iz, id);
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, OreSpawnMain.islandblock.blockID, 0, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/IslandTootexture.png");
        }
        return this.texture;
    }

    @Override
    public void setBaby(boolean tf) {
    }
}

