/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Effects;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Irukandji
extends EntityLiving {
    public Irukandji(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.35f;
        this.width = 0.35f;
        this.uniquename = "OreSpawn:Irukandji";
        this.moveSpeed = 0.07f;
        this.setMaxHealth(2.0f);
        this.setHealth(2.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(100.0f);
        this.movefrequency = 25;
        this.setExperience(50);
        this.canSwim = true;
        this.swimoffset = -0.25f;
        this.takesFallDamage = true;
        this.canBreateUnderWater = true;
        this.searchDistance = 8.0f;
        this.attackRange = 0.5f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = true;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 5;
        this.foodblockdistxz = 16;
        this.foodblockdisty = 5;
        this.foodblockheal = 0;
        this.foodblockdisteat = 0;
        this.fooddaytimeonly = false;
    }

    @Override
    public void doAttack(Entity victim) {
        Effects ef = new Effects(6, 0.1f, 200);
        victim.addEffectFromServer(ef);
        ef = new Effects(7, 2.0f, 200);
        victim.addEffectFromServer(ef);
        super.doAttack(victim);
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyirukandji.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, OreSpawnMain.deadirukandji.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        this.enable_findfoodblock = !this.getInLiquid();
    }

    @Override
    public boolean isFoodBlock(int bid) {
        return bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID;
    }

    @Override
    public void doEatFoodAction(int d, int x, int y, int z) {
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Irukandjitexture.png");
        }
        return this.texture;
    }
}

