/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Hydrolisc
extends EntityLiving {
    public Hydrolisc(World w) {
        super(w);
        this.maxrenderdist = 110;
        this.height = 0.75f;
        this.width = 0.95f;
        this.uniquename = "OreSpawn:Hydrolisc";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(100.0f);
        this.setHealth(100.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 25;
        this.setExperience(25);
        this.setCanDespawn(false);
        this.enable_avoid = true;
        this.avoiddistance = 20;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 30;
        this.foodblockdistxz = 13;
        this.foodblockdisty = 4;
        this.foodblockheal = 1;
        this.foodblockdisteat = 12;
        this.fooddaytimeonly = false;
        this.canSwim = true;
        this.enable_taming = true;
        this.maxdisttoowner = 22.0f;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.enable_droppedfood = true;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 6;
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof Hydrolisc;
    }

    @Override
    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.isBaby();
        super.doEntityAction(deltaT);
        if (this.getOwnerName() != null) {
            Player p = (Player)DangerZone.server.entityManager.findPlayerByName(this.getOwnerName());
            if (p != null && p.getHealth() < p.getMaxHealth() && this.getHealth() - 10.0f > 0.0f) {
                p.heal(1.0f);
                p.server_thread.sendVarFloatUpdate(1, p.getHealth());
                this.heal(-1.0f);
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, this.posx, this.posy, this.posz);
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, p.posx, p.posy, p.posz);
            }
            this.avoiddistance = 10;
        }
        if (this.world.rand.nextInt(10) == 1) {
            if (this.getInLiquid()) {
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleDroplet", 20, this.dimension, this.posx, this.posy + 1.0, this.posz);
                this.enable_findfoodblock = false;
            } else {
                this.enable_findfoodblock = true;
            }
        }
    }

    @Override
    public boolean shouldAvoidEntity(Entity e) {
        return e.temperament == 1;
    }

    @Override
    public boolean isFoodBlock(int bid) {
        return bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID;
    }

    @Override
    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == Items.fishmeat.itemID) {
            return true;
        }
        return iid == OreSpawnMain.crystalapple.itemID;
    }

    @Override
    public boolean isFoodItem(int iid) {
        return iid == Items.fishmeat.itemID;
    }

    @Override
    public void doEatFoodAction(int d, int x, int y, int z) {
        if (this.getInLiquid() && this.getHealth() < this.getMaxHealth()) {
            this.heal(2.0f);
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 10, this.dimension, this.posx, this.posy + 1.0, this.posz);
        }
    }

    @Override
    public String getLivingSound() {
        if (this.getInLiquid()) {
            return "DangerZone:little_splash";
        }
        return null;
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:cryo_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:cryo_death";
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, Blocks.flower_red.blockID, 0, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.fishmeat.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        if (this.world.rand.nextInt(6) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyhydrolisc.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Hydrolisctexture.png");
        }
        return this.texture;
    }
}

