/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Hammerhead
extends EntityLiving {
    public Hammerhead(World w) {
        super(w);
        this.maxrenderdist = 240;
        this.height = 5.25f;
        this.width = 4.25f;
        this.uniquename = "OreSpawn:Hammerhead";
        this.moveSpeed = 0.3f;
        this.setMaxHealth(500.0f);
        this.setHealth(500.0f);
        this.setDefense(5.0f);
        this.setAttackDamage(75.0f);
        this.searchDistance = 35.0f;
        this.attackRange = 6.0f;
        this.movefrequency = 75;
        this.setExperience(299);
        this.canSwim = false;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.tower_defense_enable = true;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        if (this.world.rand.nextBoolean()) {
            return "OreSpawn:hammerhead_living1";
        }
        return "OreSpawn:hammerhead_living2";
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:hammerhead_death";
    }

    @Override
    public void doAttack(Entity victim) {
        super.doAttack(victim);
        victim.addKnockback(this, 0.0f, 1.55f + this.world.rand.nextFloat() * 2.75f);
        if (this.world.rand.nextInt(3) == 1) {
            this.world.playSound("OreSpawn:scorpion_living", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
        } else {
            this.world.playSound("OreSpawn:scorpion_attack", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
        }
    }

    @Override
    public void doDeathDrops() {
        int howmany = 10 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 10 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 5.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.bighammer.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(3) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyhammerhead.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Hammerhead) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Hammerheadtexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isBoss() {
        return true;
    }
}

