/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class GrassMonster
extends EntityLiving {
    public float newangle = 0.0f;

    public GrassMonster(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.height = 0.25f;
        this.width = 0.95f;
        this.uniquename = "OreSpawn:Grass Monster";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(5.0f);
        this.searchDistance = 5.0f;
        this.attackRange = 2.25f;
        this.movefrequency = 185;
        this.setExperience(29);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = true;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = true;
        this.tower_defense_enable = false;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getAttackSound() {
        return "DangerZone:eating";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:dirt_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:dirt_place";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophygrassmonster.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof GrassMonster) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/GrassMonstertexture.png");
        }
        return this.texture;
    }
}

