/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Flounder
extends EntityLiving {
    public Flounder(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.height = 0.85f;
        this.width = 0.85f;
        this.uniquename = "OreSpawn:Flounder";
        this.moveSpeed = 0.175f;
        this.setMaxHealth(2.0f);
        this.setHealth(2.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 25;
        this.setExperience(2);
        this.canSwim = true;
        this.takesFallDamage = true;
        this.canBreateUnderWater = true;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 5;
        this.foodblockdistxz = 16;
        this.foodblockdisty = 5;
        this.foodblockdisteat = 0;
        this.foodblockheal = 0;
        this.fooddaytimeonly = false;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 6;
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof Flounder;
    }

    @Override
    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == Items.fishmeat.itemID) {
            return true;
        }
        return iid == OreSpawnMain.crystalapple.itemID;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "DangerZone:little_splash";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    @Override
    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.isBaby();
        super.doEntityAction(deltaT);
        if (!this.getInLiquid()) {
            this.enable_findfoodblock = true;
        } else {
            this.enable_findfoodblock = false;
            Utils.SpawnBubblesAlongPath(this);
        }
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyflounder.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.fishmeat.itemID, 1.5f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public boolean isFoodBlock(int bid) {
        return bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID;
    }

    @Override
    public void doEatFoodAction(int d, int x, int y, int z) {
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Floundertexture.png");
        }
        return this.texture;
    }
}

