/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Flattop
extends EntityLiving {
    public Flattop(World w) {
        super(w);
        this.maxrenderdist = 200;
        this.height = 0.95f;
        this.width = 2.28f;
        this.uniquename = "OreSpawn:Flattop";
        this.moveSpeed = 0.37f;
        this.setMaxHealth(125.0f);
        this.setHealth(125.0f);
        this.setDefense(2.5f);
        this.setAttackDamage(13.0f);
        this.searchDistance = 32.0f;
        this.attackRange = 2.25f;
        this.movefrequency = 40;
        this.setExperience(409);
        this.canSwim = false;
        this.daytimespawn = true;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.tower_defense_enable = true;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        if (this.world.rand.nextBoolean()) {
            return "OreSpawn:creaky1";
        }
        return "OreSpawn:creaky2";
    }

    @Override
    public String getHurtSound() {
        return "OreSpawn:creaky_hit";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:creaky_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 3 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 2 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, OreSpawnMain.table.blockID, 0, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 2 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, Blocks.stand.blockID, 0, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(2) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyflattop.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Flattop) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/Flattoptexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isBoss() {
        return true;
    }
}

