/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.OreSpawnUtils;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class FatBat
extends EntityLiving {
    public float myspeed = 0.0f;

    public FatBat(World w) {
        super(w);
        this.maxrenderdist = 128;
        this.height = 0.95f;
        this.width = 0.95f;
        this.uniquename = "OreSpawn:Fat Bat";
        this.setMaxHealth(35.0f);
        this.setHealth(35.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(5.0f);
        if (w != null) {
            this.myspeed = 0.25f + w.rand.nextFloat() * 0.1f;
        }
        this.takesFallDamage = false;
        this.setExperience(45);
        this.daytimespawn = false;
        this.nighttimespawn = true;
        this.daytimedespawn = true;
        this.nighttimedespawn = false;
        this.canFly = true;
        this.setFlying(true);
        this.temperament = 1;
        this.searchDistance = 40.0f;
        this.attackRange = 4.5f;
        if (w != null) {
            this.lifetimeticker += (long)w.rand.nextInt(10000);
        }
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return "DangerZone:chirp1";
        }
        return "DangerZone:chirp2";
    }

    @Override
    public String getAttackSound() {
        if (this.world.rand.nextBoolean()) {
            return "DangerZone:batattack1";
        }
        return "DangerZone:batattack2";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public void doEntityAction(float deltaT) {
        int bid;
        int keep_trying = 25;
        if (this.target == null) {
            this.target = new TargetHelper(this.posx + 1.0, this.posy, this.posz + 1.0);
        }
        this.do_swarm_despawn();
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(30) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)this.targetentity.getHeight() - 1.0, this.targetentity.posz);
                float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
                tdir = (float)((double)tdir - 1.5707963267948966);
                this.target.setTarget(this.target.targetx + Math.sin(tdir) * (double)(8.0f + this.targetentity.getWidth() / 2.0f) + (double)this.world.rand.nextInt(2) - (double)this.world.rand.nextInt(2), this.target.targety + (double)(this.world.rand.nextInt(3) - this.world.rand.nextInt(3)), this.target.targetz + Math.cos(tdir) * (double)(8.0f + this.targetentity.getWidth() / 2.0f) + (double)this.world.rand.nextInt(2) - (double)this.world.rand.nextInt(2));
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(8) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom(this, dt, dmg);
            this.world.playSound(this.getAttackSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        if (!this.isHurt() && !this.deadflag && this.world.rand.nextInt(50) == 1) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) == 0 && this.wouldBump(this.posx + (double)(this.motionx * deltaT), this.posy + (double)(this.motiony * deltaT) + (double)(this.getHeight() / 2.0f), this.posz + (double)(this.motionz * deltaT), this.getWidth())) {
            bid = 1;
        }
        if (bid != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
            int updown = 5;
            int k = 1;
            while (k < 10) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - k, (int)this.posz);
                if (bid != 0) {
                    updown = -1;
                    break;
                }
                ++k;
            }
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                if (this.getAttacking() && this.targetentity != null) {
                    this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)this.targetentity.getHeight() - 1.0, this.targetentity.posz);
                    float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
                    tdir = (float)((double)tdir - 1.5707963267948966);
                    this.target.setTarget(this.target.targetx + Math.sin(tdir) * (double)(8.0f + this.targetentity.getWidth() / 2.0f) + (double)this.world.rand.nextInt(2) - (double)this.world.rand.nextInt(2), this.target.targety + (double)(this.world.rand.nextInt(7) - updown), this.target.targetz + Math.cos(tdir) * (double)(8.0f + this.targetentity.getWidth() / 2.0f) + (double)this.world.rand.nextInt(2) - (double)this.world.rand.nextInt(2));
                } else if (this.isSwarming()) {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(15), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(15));
                } else {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(15) - (double)this.world.rand.nextInt(15), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(15) - (double)this.world.rand.nextInt(15));
                }
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                if (bid == 0 && !this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((this.posx - this.target.targetx) * (this.posx - this.target.targetx) + (this.posz - this.target.targetz) * (this.posz - this.target.targetz) + (this.posy - this.target.targety) * (this.posy - this.target.targety)))) {
                    bid = 1;
                }
                --keep_trying;
                this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.12f;
            }
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
            this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
        }
        float dy = (float)(this.target.targety - this.posy);
        this.motiony += 0.12f * deltaT;
        if ((dy /= 20.0f) > 0.2f) {
            dy = 0.2f;
        }
        if (dy < -0.2f) {
            dy = -0.2f;
        }
        this.motiony += dy;
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        Utils.SpawnDustAlongPath(this);
        float dx = (float)Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
        float dz = (float)Math.atan2(-this.motiony * 0.5f, dx);
        this.rotation_pitch = (float)Math.toDegrees(dz);
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(1000) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.batscat.itemID, 0.5f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.update(deltaT);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (OreSpawnUtils.isBat(e).booleanValue()) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyfatbat.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.deadbug.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.furball.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/FatBattexture.png");
        }
        return this.texture;
    }
}

