/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.EnderKnight;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Flag;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class EnderReaper
extends EntityLiving {
    public float attackRange = 1.5f;
    public int searchcounter = 0;
    public Entity hurtMe = null;
    public Entity targetentity = null;

    public EnderReaper(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.height = 3.33f;
        this.width = 1.25f;
        this.uniquename = "OreSpawn:EnderReaper";
        this.moveSpeed = 0.31f;
        this.setMaxHealth(200.0f);
        this.setHealth(200.0f);
        this.setDefense(3.0f);
        this.setAttackDamage(30.0f);
        this.searchDistance = 24.0f;
        this.attackRange = 4.0f;
        this.movefrequency = 65;
        this.setExperience(-399);
        this.canSwim = true;
        this.daytimespawn = false;
        this.nighttimespawn = true;
        this.daytimedespawn = true;
        this.nighttimedespawn = false;
        this.temperament = 1;
        this.tower_defense_enable = true;
    }

    @Override
    public void doEntityAction(float deltaT) {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(30) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(8) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 1;
            this.targetentity.doAttackFrom(this, dt, dmg);
        }
        if (this.world.rand.nextInt(10) == 1 && this.getAttacking() && this.targetentity != null && this.targetentity.CanProbablySeeEntity(this)) {
            this.teleportnearby(this.targetentity, 10);
        }
        if (this.world.rand.nextInt(100) == 1 && !this.getAttacking()) {
            this.teleportnearby(this, 32);
            this.newtargetnow = true;
        }
        super.doEntityAction(deltaT);
    }

    private void teleportnearby(Entity entity, int dist) {
        int tries = 10;
        while (tries > 0) {
            --tries;
            int py = (int)this.posy;
            int px = (int)(this.posx + (double)(this.world.rand.nextInt(dist) - this.world.rand.nextInt(dist)));
            int pz = (int)(this.posz + (double)(this.world.rand.nextInt(dist) - this.world.rand.nextInt(dist)));
            int i = -7;
            while (i <= 9) {
                int bid = this.world.getblock(this.dimension, px, py + i, pz);
                if (bid == 0 && (bid = this.world.getblock(this.dimension, px, py + i - 1, pz)) == 0 && (bid = this.world.getblock(this.dimension, px, py + i - 2, pz)) == 0 && (bid = this.world.getblock(this.dimension, px, py + i - 3, pz)) != 0) {
                    int j = 0;
                    while (j < 3) {
                        Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 12, this.dimension, this.posx, this.posy + (double)j, this.posz);
                        ++j;
                    }
                    this.posx = 0.5f + (float)px;
                    this.posz = 0.5f + (float)pz;
                    this.posy = py + i - 2;
                    tries = 0;
                    int which = this.world.rand.nextInt(3);
                    if (which == 0) {
                        this.world.playSound("DangerZone:teleport1", this.dimension, this.posx, this.posy, this.posz, 0.75f, 1.0f);
                    }
                    if (which == 1) {
                        this.world.playSound("DangerZone:teleport2", this.dimension, this.posx, this.posy, this.posz, 0.75f, 1.0f);
                    }
                    if (which == 2) {
                        this.world.playSound("DangerZone:teleport3", this.dimension, this.posx, this.posy, this.posz, 0.75f, 1.0f);
                    }
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return null;
    }

    @Override
    public String getDeathSound() {
        return null;
    }

    @Override
    public void doDeathDrops() {
        int howmany = 5 + this.world.rand.nextInt(6);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.dark.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand(this.world, Blocks.blockdark.blockID, 0, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            }
            Utils.doDropRand(this.world, Blocks.flower_purple.blockID, 0, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(6) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophyenderreaper.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof EnderReaper) {
            return false;
        }
        if (e instanceof EnderKnight) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Flag && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/EnderReapertexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    public String getBossName() {
        return "Ender Reaper";
    }
}

