/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Fairy;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.Irukandji;
import OreSpawn.entities.Rotator;
import OreSpawn.entities.Skate;
import OreSpawn.entities.Urchin;
import OreSpawn.entities.Vortex;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Rat;
import dangerzone.entities.RenderInfo;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class DungeonBeast
extends EntityLiving {
    public RenderInfo renderdata = new RenderInfo();

    public DungeonBeast(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 1.33f;
        this.width = 1.25f;
        this.uniquename = "OreSpawn:DungeonBeast";
        this.moveSpeed = 0.35f;
        this.setMaxHealth(40.0f);
        this.setHealth(40.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(6.0f);
        this.searchDistance = 22.0f;
        this.attackRange = 2.0f;
        this.movefrequency = 35;
        this.setExperience(29);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        int which = this.world.rand.nextInt(3);
        if (which == 0) {
            return "OreSpawn:dbhit1";
        }
        if (which == 1) {
            return "OreSpawn:dbhit2";
        }
        return "OreSpawn:dbhit3";
    }

    @Override
    public String getDeathSound() {
        return "OreSpawn:dbdead";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(3);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.pink.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.crystalstoneaxe.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.crystalstonepickaxe.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.crystalstoneshovel.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.crystalstonesword.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.crystalstonehoe.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, OreSpawnMain.trophydungeonbeast.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Urchin) {
            return false;
        }
        if (e instanceof Rotator) {
            return false;
        }
        if (e instanceof Vortex) {
            return false;
        }
        if (e instanceof DungeonBeast) {
            return false;
        }
        if (e instanceof Skate) {
            return false;
        }
        if (e instanceof Irukandji) {
            return false;
        }
        if (e instanceof Rat) {
            return false;
        }
        if (e instanceof Fairy && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Girlfriend && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("orespawnres/skins/DungeonBeasttexture.png");
        }
        return this.texture;
    }
}

